/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ParametricCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.ParametricCS;
import org.opengis.referencing.datum.ParametricDatum;

@XmlType(name="ParametricCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="ParametricCRS")
public class DefaultParametricCRS
extends AbstractCRS
implements ParametricCRS {
    private static final long serialVersionUID = 4013698133331342649L;
    private ParametricDatum datum;

    public DefaultParametricCRS(Map<String, ?> properties, ParametricDatum datum, ParametricCS cs) {
        super(properties, (CoordinateSystem)cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
    }

    protected DefaultParametricCRS(ParametricCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.datum = crs.getDatum();
    }

    public static DefaultParametricCRS castOrCopy(ParametricCRS object) {
        return object == null || object instanceof DefaultParametricCRS ? (DefaultParametricCRS)object : new DefaultParametricCRS(object);
    }

    public Class<? extends ParametricCRS> getInterface() {
        return ParametricCRS.class;
    }

    @XmlElement(name="parametricDatum", required=true)
    public ParametricDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="parametricCS", required=true)
    public ParametricCS getCoordinateSystem() {
        return (ParametricCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultParametricCRS forConvention(AxesConvention convention) {
        return (DefaultParametricCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultParametricCRS(properties, this.datum, (ParametricCS)cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultParametricCRS.isBaseCRS(formatter) ? "BaseParamCRS" : "ParametricCRS";
    }

    private DefaultParametricCRS() {
    }

    private void setDatum(ParametricDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultParametricCRS.class, "setDatum", "parametricDatum");
        }
    }

    private void setCoordinateSystem(ParametricCS cs) {
        this.setCoordinateSystem("parametricCS", (CoordinateSystem)cs);
    }
}

