/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.GeodeticCalculator;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.Cache;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.AxisResolve;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.AbstractRingProperty;
import org.geotoolkit.gml.xml.AbstractSurface;
import org.geotoolkit.gml.xml.Coordinates;
import org.geotoolkit.gml.xml.Curve;
import org.geotoolkit.gml.xml.CurveProperty;
import org.geotoolkit.gml.xml.CurveSegmentArrayProperty;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.DirectPositionList;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.GeometryProperty;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.LineStringProperty;
import org.geotoolkit.gml.xml.LineStringSegment;
import org.geotoolkit.gml.xml.LinearRing;
import org.geotoolkit.gml.xml.MultiCurve;
import org.geotoolkit.gml.xml.MultiGeometry;
import org.geotoolkit.gml.xml.MultiLineString;
import org.geotoolkit.gml.xml.MultiPoint;
import org.geotoolkit.gml.xml.MultiPolygon;
import org.geotoolkit.gml.xml.MultiSurface;
import org.geotoolkit.gml.xml.Point;
import org.geotoolkit.gml.xml.PointProperty;
import org.geotoolkit.gml.xml.Polygon;
import org.geotoolkit.gml.xml.PolygonProperty;
import org.geotoolkit.gml.xml.Ring;
import org.geotoolkit.gml.xml.SurfaceProperty;
import org.geotoolkit.gml.xml.WithCoordinates;
import org.geotoolkit.gml.xml.v311.ArcByCenterPointType;
import org.geotoolkit.gml.xml.v311.MeasureType;
import org.geotoolkit.gml.xml.v311.PolygonPatchType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.GeodesicStringType;
import org.geotoolkit.gml.xml.v321.PointPropertyType;
import org.geotoolkit.gml.xml.v321.SurfaceType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeometryTransformer
implements Supplier<Geometry> {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.gml");
    private static final GeometryFactory GF = JTS.getFactory();
    private static final Measure ARC_PRECISION = new Measure(8.0, Units.DEGREE);
    private static final Cache<Map.Entry<String, Boolean>, CoordinateReferenceSystem> CRS_CACHE = new Cache(12, 0L, false);
    private final AbstractGeometry source;
    private final GeometryTransformer parent;
    private Boolean isLongitudeFirst;
    protected AxisResolve axisResolve;
    protected boolean forceMultiPolygon;

    public GeometryTransformer(AbstractGeometry source) {
        this(source, null);
    }

    public GeometryTransformer(AbstractGeometry source, GeometryTransformer parent) {
        ArgumentChecks.ensureNonNull("GML Geometry to convert", source);
        this.source = source;
        this.parent = parent;
        this.axisResolve = parent == null ? AxisResolve.getDefault() : parent.getAxisResolve();
    }

    public GeometryTransformer(AbstractGeometry source, GeometryTransformer parent, AxisResolve axisResolve) {
        ArgumentChecks.ensureNonNull("GML Geometry to convert", source);
        ArgumentChecks.ensureNonNull("AxisResolve", (Object)axisResolve);
        this.source = source;
        this.parent = parent;
        this.setAxisResolve(axisResolve);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Geometry get() throws UnconvertibleObjectException {
        HashMap<String, String> values;
        org.locationtech.jts.geom.Point geometry;
        if (this.source instanceof Point) {
            geometry = this.accumulateAndBuild(coords -> ((Coordinate[])coords).length > 0 ? GF.createPoint(coords[0]) : GF.createPoint((Coordinate)null));
        } else if (this.source instanceof LineString) {
            geometry = this.accumulateAndBuild(arg_0 -> ((GeometryFactory)GF).createLineString(arg_0));
        } else if (this.source instanceof LinearRing) {
            geometry = this.accumulateAndBuild(arg_0 -> ((GeometryFactory)GF).createLinearRing(arg_0));
        } else if (this.source instanceof Curve) {
            geometry = this.convertCurve((Curve)this.source);
        } else if (this.source instanceof Envelope) {
            geometry = this.convertEnvelope((Envelope)this.source);
        } else if (this.source instanceof Ring) {
            geometry = this.convertRing((Ring)this.source);
        } else if (this.source instanceof Polygon) {
            geometry = this.convertPolygon((Polygon)this.source);
            if (this.isForceMultiPolygon()) {
                org.locationtech.jts.geom.Polygon[] polys = new org.locationtech.jts.geom.Polygon[]{(org.locationtech.jts.geom.Polygon)geometry};
                org.locationtech.jts.geom.MultiPolygon result = GF.createMultiPolygon(polys);
                this.applyCRS((Geometry)result);
                geometry = result;
            }
        } else if (this.source instanceof AbstractSurface) {
            if (this.source instanceof SurfaceType) {
                geometry = this.convertSurface((SurfaceType)this.source);
            } else {
                if (!(this.source instanceof org.geotoolkit.gml.xml.v311.SurfaceType)) throw new IllegalArgumentException("Unsupported geometry type : " + this.source.getClass());
                geometry = this.convertSurface((org.geotoolkit.gml.xml.v311.SurfaceType)this.source);
            }
        } else if (this.source instanceof MultiPoint) {
            geometry = this.convertMultiPoint((MultiPoint)this.source);
        } else if (this.source instanceof MultiLineString) {
            geometry = this.convertMultiLineString((MultiLineString)this.source);
        } else if (this.source instanceof MultiCurve) {
            geometry = this.convertMultiCurve((MultiCurve)this.source);
        } else if (this.source instanceof MultiPolygon) {
            geometry = this.convertMultiPolygon((MultiPolygon)this.source);
        } else if (this.source instanceof MultiSurface) {
            geometry = this.convertMultiSurface((MultiSurface)this.source);
        } else {
            if (!(this.source instanceof MultiGeometry)) throw new IllegalArgumentException("Unsupported geometry type : " + this.source.getClass());
            geometry = this.convertMultiGeometry((MultiGeometry)this.source);
        }
        String id = this.source.getId();
        if (id == null || id.isEmpty()) return geometry;
        Object userData = geometry.getUserData();
        if (userData instanceof Map) {
            values = (HashMap<String, String>)userData;
        } else if (userData instanceof CoordinateReferenceSystem) {
            values = new HashMap<String, String>();
            values.put("CRS", (String)userData);
        } else {
            if (userData != null) throw new IllegalArgumentException("Unexpected user data object : " + userData);
            values = new HashMap();
        }
        values.put("@id", id);
        geometry.setUserData(values);
        return geometry;
    }

    protected void accumulate(List<Coordinate> target, boolean checkFirst) {
        boolean advanced;
        Spliterator<Coordinate> it = this.getCoordinates(this.source);
        if (checkFirst && !target.isEmpty()) {
            it.tryAdvance(coord -> {
                if (!((Coordinate)target.get(target.size() - 1)).equals(coord)) {
                    target.add((Coordinate)coord);
                }
            });
        }
        while (advanced = it.tryAdvance(target::add)) {
        }
    }

    private Spliterator<Coordinate> getCoordinates(Object source) throws UnconvertibleObjectException {
        List values = null;
        if (source instanceof WithCoordinates) {
            Coordinates coords = ((WithCoordinates)source).getCoordinates();
            if (coords != null) {
                Iterator it = coords.points().iterator();
                if (it.hasNext() && ((double[])it.next()).length > 1) {
                    return coords.points().map(GeometryTransformer::toCoordinate).spliterator();
                }
                values = coords.getValues();
            } else if (source instanceof Point) {
                DirectPosition dp = ((Point)source).getPos();
                if (dp != null) {
                    return Stream.of(GeometryTransformer.convertDirectPosition(dp)).spliterator();
                }
                return Spliterators.emptySpliterator();
            }
        }
        if (values == null) {
            boolean isLineString = source instanceof LineString;
            boolean isLineStringSegment = source instanceof LineStringSegment;
            if (isLineString || isLineStringSegment) {
                DirectPositionList posList = isLineString ? ((LineString)source).getPosList() : ((LineStringSegment)source).getPosList();
                if (posList != null) {
                    values = posList.getValue();
                } else {
                    List<? extends DirectPosition> pList = isLineString ? ((LineString)source).getPos() : ((LineStringSegment)source).getPos();
                    if (pList != null) {
                        return pList.stream().map(GeometryTransformer::convertDirectPosition).filter(Objects::nonNull).spliterator();
                    }
                    values = Collections.EMPTY_LIST;
                }
            } else if (source instanceof LinearRing) {
                values = GeometryTransformer.asDoubles(() -> ((LinearRing)source).getPosList());
            } else if (source instanceof org.geotoolkit.gml.xml.v311.GeodesicStringType) {
                values = GeometryTransformer.asDoubles(() -> ((org.geotoolkit.gml.xml.v311.GeodesicStringType)source).getPosList());
            } else if (source instanceof GeodesicStringType) {
                values = GeometryTransformer.asDoubles(() -> ((GeodesicStringType)source).getPosList());
            } else if (source instanceof Curve) {
                List<? extends AbstractCurveSegment> curveSegments;
                CurveSegmentArrayProperty segments = ((Curve)source).getSegments();
                if (segments != null && (curveSegments = segments.getAbstractCurveSegment()) != null) {
                    return curveSegments.stream().flatMap(seg -> StreamSupport.stream(this.getCoordinates(seg), false)).spliterator();
                }
                values = Collections.EMPTY_LIST;
            } else {
                if (source instanceof org.geotoolkit.gml.xml.v321.ArcByCenterPointType) {
                    CoordinateReferenceSystem crs;
                    org.geotoolkit.gml.xml.v321.ArcByCenterPointType arc = (org.geotoolkit.gml.xml.v321.ArcByCenterPointType)source;
                    DirectPositionType dp = arc.getPos();
                    if (dp == null) {
                        PointPropertyType pp = arc.getPointProperty();
                        if (pp == null) {
                            pp = arc.getPointRep();
                        }
                        if (pp == null) {
                            throw new UnconvertibleObjectException("Not enough information to build an arc.");
                        }
                        Geometry point = new GeometryTransformer(pp.getPoint(), this).get();
                        dp = JTS.toEnvelope((Geometry)point).getLowerCorner();
                    }
                    if ((crs = dp.getCoordinateReferenceSystem()) == null) {
                        crs = this.getSrsName().map(this::findCRS).orElseThrow(() -> new UnconvertibleObjectException("Cannot create an arc without its coordinate reference system"));
                        GeneralDirectPosition gdp = new GeneralDirectPosition((org.opengis.geometry.DirectPosition)dp);
                        gdp.setCoordinateReferenceSystem(crs);
                        dp = gdp;
                    }
                    try {
                        Measure endAngle;
                        Measure startAngle;
                        if (arc.getStartAngle() == null || arc.getEndAngle() == null) {
                            startAngle = new Measure(0.0, Units.DEGREE);
                            endAngle = new Measure(360.0, Units.DEGREE);
                        } else {
                            startAngle = this.asMeasure(arc.getStartAngle());
                            endAngle = this.asMeasure(arc.getEndAngle());
                        }
                        Object[] coordinates = GeometryTransformer.drawArc(dp, this.asMeasure(arc.getRadius()), startAngle, endAngle, ARC_PRECISION);
                        return Spliterators.spliterator(coordinates, 16);
                    }
                    catch (TransformException ex) {
                        throw new UnconvertibleObjectException("Cannot draw an arc.", ex);
                    }
                }
                if (source instanceof ArcByCenterPointType) {
                    CoordinateReferenceSystem crs;
                    ArcByCenterPointType arc = (ArcByCenterPointType)source;
                    org.geotoolkit.gml.xml.v311.DirectPositionType dp = arc.getPos();
                    if (dp == null) {
                        org.geotoolkit.gml.xml.v311.PointPropertyType pp = arc.getPointProperty();
                        if (pp == null) {
                            pp = arc.getPointRep();
                        }
                        if (pp == null) {
                            throw new UnconvertibleObjectException("Not enough information to build an arc.");
                        }
                        Geometry point = new GeometryTransformer(pp.getPoint(), this).get();
                        dp = JTS.toEnvelope((Geometry)point).getLowerCorner();
                    }
                    if ((crs = dp.getCoordinateReferenceSystem()) == null) {
                        crs = this.getSrsName().map(this::findCRS).orElseThrow(() -> new UnconvertibleObjectException("Cannot create an arc without its coordinate reference system"));
                        GeneralDirectPosition gdp = new GeneralDirectPosition((org.opengis.geometry.DirectPosition)dp);
                        gdp.setCoordinateReferenceSystem(crs);
                        dp = gdp;
                    }
                    try {
                        Measure endAngle;
                        Measure startAngle;
                        if (arc.getStartAngle() == null || arc.getEndAngle() == null) {
                            startAngle = new Measure(0.0, Units.DEGREE);
                            endAngle = new Measure(360.0, Units.DEGREE);
                        } else {
                            startAngle = this.asMeasure(arc.getStartAngle());
                            endAngle = this.asMeasure(arc.getEndAngle());
                        }
                        Object[] coordinates = GeometryTransformer.drawArc(dp, this.asMeasure(arc.getRadius()), startAngle, endAngle, ARC_PRECISION);
                        return Spliterators.spliterator(coordinates, 16);
                    }
                    catch (TransformException ex) {
                        throw new UnconvertibleObjectException("Cannot draw an arc.", ex);
                    }
                }
            }
        }
        if (values != null) {
            if (values.isEmpty()) {
                return Spliterators.emptySpliterator();
            }
            return new CoordinateSpliterator(values, this.getCoordinateDimension());
        }
        throw new UnconvertibleObjectException("Cannot extract coordinates from source geometry.");
    }

    private Measure asMeasure(org.geotoolkit.gml.xml.v321.MeasureType in) {
        return new Measure((double)in.getValue(), GeometryTransformer.hackUnit(in.getUomStr()));
    }

    private Measure asMeasure(MeasureType in) {
        return new Measure(in.getValue(), GeometryTransformer.hackUnit(in.getUom()));
    }

    private static Unit<?> hackUnit(String uom) {
        if ("[nmi_i]".equals(uom)) {
            return Units.NAUTICAL_MILE;
        }
        return Units.valueOf(uom);
    }

    private static List<Double> asDoubles(Supplier<DirectPositionList> positionProvider) {
        DirectPositionList posList = positionProvider.get();
        return posList != null ? posList.getValue() : Collections.EMPTY_LIST;
    }

    private static Coordinate convertDirectPosition(org.opengis.geometry.DirectPosition dp) {
        return GeometryTransformer.toCoordinate(dp.getCoordinate());
    }

    private static Coordinate toCoordinate(double[] values) {
        if (values.length <= 0) {
            return null;
        }
        if (values.length == 2) {
            return new Coordinate(values[0], values[1]);
        }
        if (values.length == 3) {
            return new Coordinate(values[0], values[1], values[2]);
        }
        throw new UnconvertibleObjectException("Only 2D and 3D positions accepted, but received dimension: " + values.length);
    }

    protected int getCoordinateDimension() {
        if (this.source instanceof Point) {
            Point pt = (Point)this.source;
            int dim2 = 0;
            if (pt.getCoordinates() != null) {
                dim2 = pt.getCoordinates().getValues().size();
            } else if (pt.getPos() != null) {
                dim2 = pt.getPos().getValue().size();
            }
            if (dim2 > 0) {
                return dim2;
            }
        }
        return this.familyTree().map(gt -> gt.source.getSrsDimension()).filter(dim -> dim != null && dim > 0).findFirst().orElseGet(() -> {
            LOGGER.fine("Arbitrary choice: GML geometry does not define any \"srsDimension\" attribute. Fallback on 2D.");
            return 2;
        });
    }

    protected Optional<String> getSrsName() {
        Optional<String> baseCrs = this.familyTree().map(gt -> gt.source.getSrsName()).filter(Objects::nonNull).findFirst();
        if (baseCrs.isPresent()) {
            return baseCrs;
        }
        if (this.source instanceof LinearRing) {
            DirectPositionList posList = ((LinearRing)this.source).getPosList();
            if (posList == null || posList.getSrsName() == null) {
                return Optional.empty();
            }
            return Optional.of(posList.getSrsName());
        }
        return Optional.empty();
    }

    public boolean isLongitudeFirst() {
        return this.familyTree().map(gt -> gt.isLongitudeFirst).filter(Objects::nonNull).findFirst().orElse(false);
    }

    private void applyAxisResolveStrategy() {
        AxisResolve lastAxisResolve = this.getAxisResolve();
        switch (lastAxisResolve) {
            case STRICT: {
                break;
            }
            case RIGHT_HANDED: {
                this.isLongitudeFirst = true;
                break;
            }
            case AUTO: {
                try {
                    String srsName = this.getSrsName().get();
                    this.isLongitudeFirst = !srsName.trim().startsWith("urn:");
                    break;
                }
                catch (NoSuchElementException ne) {
                    this.isLongitudeFirst = true;
                }
            }
        }
    }

    public final void setAxisResolve(AxisResolve axisResolve) {
        ArgumentChecks.ensureNonNull("AxisResolve input", (Object)axisResolve);
        this.axisResolve = axisResolve;
        if (this.parent != null) {
            this.parent.setAxisResolve(axisResolve);
        }
    }

    public final AxisResolve getAxisResolve() {
        AxisResolve parentAxisResolve;
        if (this.parent != null && (parentAxisResolve = this.parent.getAxisResolve()) != this.axisResolve) {
            this.axisResolve = parentAxisResolve;
        }
        return this.axisResolve;
    }

    public boolean isForceMultiPolygon() {
        return this.forceMultiPolygon;
    }

    public void setForceMultiPolygon(Boolean forceMultiPolygon) {
        this.forceMultiPolygon = forceMultiPolygon;
    }

    protected Stream<GeometryTransformer> familyTree() {
        Stream<GeometryTransformer> self = Stream.of(this);
        if (this.parent == null) {
            return self;
        }
        return Stream.concat(self, this.parent.familyTree());
    }

    protected void applyCRS(Geometry target) {
        this.getSrsName().map(this::findCRS).ifPresent(crs -> JTS.setCRS((Geometry)target, (CoordinateReferenceSystem)crs));
    }

    protected CoordinateReferenceSystem findCRS(String srsName) {
        this.applyAxisResolveStrategy();
        boolean longitudeFirst = this.isLongitudeFirst();
        try {
            return CRS_CACHE.getOrCreate(new AbstractMap.SimpleImmutableEntry<String, Boolean>(srsName, longitudeFirst), () -> GeometryTransformer.loadCRS(srsName, longitudeFirst));
        }
        catch (Exception ex) {
            throw new UnconvertibleObjectException("Referencing information cannot be read." + ex.getMessage(), ex);
        }
    }

    private static CoordinateReferenceSystem loadCRS(String name, boolean longitudeFirst) {
        CoordinateReferenceSystem crs;
        block6: {
            try {
                try {
                    crs = CRS.forCode((String)name);
                }
                catch (NoSuchAuthorityCodeException e) {
                    Matcher matcher = Pattern.compile("\\w+:\\d+$").matcher(name);
                    if (matcher.find()) {
                        crs = CRS.forCode((String)matcher.group());
                        break block6;
                    }
                    throw e;
                }
            }
            catch (FactoryException ex) {
                throw new UnconvertibleObjectException("Impossible to find a coordinate reference system for code " + name, ex);
            }
        }
        if (longitudeFirst) {
            crs = AbstractCRS.castOrCopy((CoordinateReferenceSystem)crs).forConvention(AxesConvention.RIGHT_HANDED);
        }
        return crs;
    }

    private org.locationtech.jts.geom.Polygon convertEnvelope(Envelope source) {
        org.locationtech.jts.geom.Envelope e = new org.locationtech.jts.geom.Envelope(GeometryTransformer.convertDirectPosition(source.getLowerCorner()), GeometryTransformer.convertDirectPosition(source.getUpperCorner()));
        org.locationtech.jts.geom.Polygon geom = JTS.toGeometry((org.locationtech.jts.geom.Envelope)e);
        this.applyCRS((Geometry)geom);
        return geom;
    }

    private org.locationtech.jts.geom.LinearRing convertRing(Ring source) {
        List coords = this.extractCurves(source.getCurveMember().stream()).reduce(new ArrayList(), (target, gt) -> {
            gt.accumulate((List<Coordinate>)target, true);
            return target;
        }, (l1, l2) -> {
            if (l1 != l2) {
                l1.addAll(l2);
            }
            return l1;
        });
        if (coords.size() > 1 && !((Coordinate)coords.get(0)).equals2D((Coordinate)coords.get(coords.size() - 1))) {
            coords.add((Coordinate)coords.get(0));
        }
        org.locationtech.jts.geom.LinearRing ring = GF.createLinearRing(coords.toArray(new Coordinate[coords.size()]));
        this.applyCRS((Geometry)ring);
        return ring;
    }

    private Stream<GeometryTransformer> extractCurves(Stream<? extends CurveProperty> curves) {
        return curves.map(CurveProperty::getAbstractCurve).map(ac -> {
            if (ac instanceof AbstractGeometry) {
                return new GeometryTransformer((AbstractGeometry)((Object)ac), this);
            }
            throw new UnconvertibleObjectException("Geometry type not supported yet: " + ac.getClass());
        });
    }

    private org.locationtech.jts.geom.Polygon convertPolygon(Polygon polygon) {
        return this.convertPolygonLike(polygon.getExterior(), polygon.getInterior());
    }

    private org.locationtech.jts.geom.Polygon convertPolygonLike(AbstractRingProperty exteriorProperty, List<? extends AbstractRingProperty> interiorProperties) {
        org.locationtech.jts.geom.LinearRing[] interiors;
        AbstractRing exterior = exteriorProperty.getAbstractRing();
        Geometry extRing = new GeometryTransformer(exterior, this).get();
        if (!(extRing instanceof org.locationtech.jts.geom.LinearRing)) {
            throw new UnconvertibleObjectException("Cannot create a polygon, because its exterior is not a ring");
        }
        try {
            Stream<Object> interiorStream = interiorProperties == null ? Stream.empty() : interiorProperties.stream();
            interiors = (org.locationtech.jts.geom.LinearRing[])interiorStream.map(AbstractRingProperty::getAbstractRing).map(ring -> new GeometryTransformer((AbstractGeometry)ring, this).get()).map(org.locationtech.jts.geom.LinearRing.class::cast).toArray(org.locationtech.jts.geom.LinearRing[]::new);
        }
        catch (ClassCastException e) {
            throw new UnconvertibleObjectException("Cannot create a polygon, because some of its interior geometries are not rings", e);
        }
        org.locationtech.jts.geom.Polygon poly = GF.createPolygon((org.locationtech.jts.geom.LinearRing)extRing, interiors);
        this.applyCRS((Geometry)poly);
        return poly;
    }

    private org.locationtech.jts.geom.LineString convertCurve(Curve mc) {
        CurveSegmentArrayProperty segments = mc.getSegments();
        ArrayList coords = new ArrayList();
        if (segments != null) {
            for (AbstractCurveSegment abstractCurveSegment : segments.getAbstractCurveSegment()) {
                StreamSupport.stream(this.getCoordinates(abstractCurveSegment), false).forEach(coords::add);
            }
        }
        org.locationtech.jts.geom.LineString mls = GF.createLineString(coords.toArray(new Coordinate[coords.size()]));
        this.applyCRS((Geometry)mls);
        return mls;
    }

    private org.locationtech.jts.geom.MultiPoint convertMultiPoint(MultiPoint mp) {
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        for (PointProperty pointProperty : mp.getPointMember()) {
            new GeometryTransformer(pointProperty.getPoint(), this).accumulate(points, false);
        }
        org.locationtech.jts.geom.MultiPoint result = GF.createMultiPoint(points.toArray(new Coordinate[points.size()]));
        this.applyCRS((Geometry)result);
        return result;
    }

    private org.locationtech.jts.geom.MultiLineString convertMultiLineString(MultiLineString mls) {
        org.locationtech.jts.geom.LineString[] lss;
        try {
            lss = (org.locationtech.jts.geom.LineString[])mls.getLineStringMember().stream().map(LineStringProperty::getLineString).map(ls -> new GeometryTransformer((AbstractGeometry)ls, this).get()).map(org.locationtech.jts.geom.LineString.class::cast).toArray(org.locationtech.jts.geom.LineString[]::new);
        }
        catch (ClassCastException e) {
            throw new UnconvertibleObjectException("Cannot create a multi-line string, because some of its components are not lines", e);
        }
        org.locationtech.jts.geom.MultiLineString result = GF.createMultiLineString(lss);
        this.applyCRS((Geometry)result);
        return result;
    }

    private org.locationtech.jts.geom.MultiLineString convertMultiCurve(MultiCurve mc) {
        org.locationtech.jts.geom.LineString[] lines;
        try {
            lines = (org.locationtech.jts.geom.LineString[])this.extractCurves(mc.getCurveMember().stream()).map(GeometryTransformer::get).map(org.locationtech.jts.geom.LineString.class::cast).toArray(org.locationtech.jts.geom.LineString[]::new);
        }
        catch (ClassCastException e) {
            throw new UnconvertibleObjectException("Cannot create a multi-curve, because some of its components are not lines", e);
        }
        org.locationtech.jts.geom.MultiLineString mls = GF.createMultiLineString(lines);
        this.applyCRS((Geometry)mls);
        return mls;
    }

    private org.locationtech.jts.geom.MultiPolygon convertMultiPolygon(MultiPolygon mp) {
        org.locationtech.jts.geom.Polygon[] polys;
        try {
            polys = (org.locationtech.jts.geom.Polygon[])mp.getPolygonMember().stream().map(PolygonProperty::getPolygon).map(p -> new GeometryTransformer((AbstractGeometry)p, this).get()).map(org.locationtech.jts.geom.Polygon.class::cast).toArray(org.locationtech.jts.geom.Polygon[]::new);
        }
        catch (ClassCastException e) {
            throw new UnconvertibleObjectException("Cannot create a multi-polygon, because some of its components are not polygons", e);
        }
        org.locationtech.jts.geom.MultiPolygon result = GF.createMultiPolygon(polys);
        this.applyCRS((Geometry)result);
        return result;
    }

    private org.locationtech.jts.geom.MultiPolygon convertMultiSurface(MultiSurface mp) {
        org.locationtech.jts.geom.Polygon[] polys;
        try {
            polys = (org.locationtech.jts.geom.Polygon[])mp.getSurfaceMember().stream().map(SurfaceProperty::getAbstractSurface).map(surface -> {
                if (surface instanceof AbstractGeometry) {
                    return (AbstractGeometry)((Object)surface);
                }
                throw new UnconvertibleObjectException("We cannot convert a non-geometric object: " + surface.getClass());
            }).map(p -> new GeometryTransformer((AbstractGeometry)p, this).get()).map(org.locationtech.jts.geom.Polygon.class::cast).toArray(org.locationtech.jts.geom.Polygon[]::new);
        }
        catch (ClassCastException e) {
            throw new UnconvertibleObjectException("Cannot create a multi-surface, because some of its components are not polygons", e);
        }
        org.locationtech.jts.geom.MultiPolygon result = GF.createMultiPolygon(polys);
        this.applyCRS((Geometry)result);
        return result;
    }

    private GeometryCollection convertMultiGeometry(MultiGeometry mg) {
        Geometry[] geometries = (Geometry[])mg.getGeometryMember().stream().map(GeometryProperty::getAbstractGeometry).map(geom -> new GeometryTransformer((AbstractGeometry)geom, this).get()).toArray(Geometry[]::new);
        GeometryCollection result = GF.createGeometryCollection(geometries);
        this.applyCRS((Geometry)result);
        return result;
    }

    private org.locationtech.jts.geom.MultiPolygon convertSurface(SurfaceType surface) {
        org.locationtech.jts.geom.Polygon[] polygons = (org.locationtech.jts.geom.Polygon[])surface.getPatches().getAbstractSurfacePatch().stream().peek(patch -> {
            if (!(patch instanceof org.geotoolkit.gml.xml.v321.PolygonPatchType)) {
                throw new UnconvertibleObjectException("Only polygon patches are currently supported for surface types. Found: " + patch.getClass());
            }
        }).map(org.geotoolkit.gml.xml.v321.PolygonPatchType.class::cast).map(polygon -> this.convertPolygonLike(polygon.getExterior(), polygon.getInterior())).toArray(org.locationtech.jts.geom.Polygon[]::new);
        org.locationtech.jts.geom.MultiPolygon mp = GF.createMultiPolygon(polygons);
        this.applyCRS((Geometry)mp);
        return mp;
    }

    private org.locationtech.jts.geom.MultiPolygon convertSurface(org.geotoolkit.gml.xml.v311.SurfaceType surface) {
        org.locationtech.jts.geom.Polygon[] polygons = (org.locationtech.jts.geom.Polygon[])surface.getPatches().getAbstractSurfacePatch().stream().peek(patch -> {
            if (!(patch instanceof PolygonPatchType)) {
                throw new UnconvertibleObjectException("Only polygon patches are currently supported for surface types. Found: " + patch.getClass());
            }
        }).map(PolygonPatchType.class::cast).map(polygon -> this.convertPolygonLike(polygon.getExterior(), polygon.getInterior())).toArray(org.locationtech.jts.geom.Polygon[]::new);
        org.locationtech.jts.geom.MultiPolygon mp = GF.createMultiPolygon(polygons);
        this.applyCRS((Geometry)mp);
        return mp;
    }

    protected <U extends Geometry> U accumulateAndBuild(Function<Coordinate[], U> builder) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        this.accumulate(coords, false);
        Geometry jtsGeometry = (Geometry)builder.apply(coords.toArray(new Coordinate[coords.size()]));
        this.applyCRS(jtsGeometry);
        return (U)jtsGeometry;
    }

    private static Coordinate[] drawArc(org.opengis.geometry.DirectPosition center, Measure radius, Measure startAzimuth, Measure endAzimuth, Measure angularStep) throws TransformException {
        double step;
        boolean isCircle;
        ArgumentChecks.ensureNonNull("Center point", center);
        CoordinateReferenceSystem sourceCrs = center.getCoordinateReferenceSystem();
        ArgumentChecks.ensureNonNull("coordinate reference system", sourceCrs);
        SingleCRS hCrs = CRS.getHorizontalComponent((CoordinateReferenceSystem)sourceCrs);
        if (hCrs == null) {
            throw new UnconvertibleObjectException("Cannot extract geometries without projected part.");
        }
        int xAxis = AxisDirections.indexOfColinear((CoordinateSystem)sourceCrs.getCoordinateSystem(), (CoordinateSystem)hCrs.getCoordinateSystem());
        int yAxis = xAxis + 1;
        GeodeticCalculator gc = GeodeticCalculator.create((CoordinateReferenceSystem)sourceCrs);
        gc.setStartPoint((Position)center);
        Unit radiusUnit = gc.getDistanceUnit();
        double r = radius.getUnit(Length.class).getConverterTo(radiusUnit).convert(radius.value);
        double theta = startAzimuth.getUnit(Angle.class).getConverterTo(Units.DEGREE).convert(startAzimuth.value);
        double end = endAzimuth.getUnit(Angle.class).getConverterTo(Units.DEGREE).convert(endAzimuth.value);
        double phi = end - theta;
        double positivePhi = Math.abs(phi);
        boolean bl = isCircle = positivePhi - 1.0E-8 <= 0.0 || positivePhi >= 360.0;
        if (isCircle) {
            phi = 360.0;
        }
        if (phi / (step = (double)(phi < 0.0 ? -1 : 1) * angularStep.getUnit(Angle.class).getConverterTo(Units.DEGREE).convert(angularStep.value)) < 3.0) {
            step = phi / 3.0;
        }
        Coordinate[] arcPerimeter = new Coordinate[(int)Math.ceil(phi / step) + 1];
        DoubleFunction<Coordinate> pointOnCircle = azimuth -> {
            azimuth = (azimuth + 180.0) % 360.0 - 180.0;
            gc.setStartingAzimuth(azimuth);
            gc.setGeodesicDistance(r);
            org.opengis.geometry.DirectPosition pt = gc.getEndPoint();
            return new Coordinate(pt.getOrdinate(xAxis), pt.getOrdinate(yAxis));
        };
        int i = 0;
        while (i < arcPerimeter.length - 1) {
            arcPerimeter[i] = pointOnCircle.apply(theta);
            ++i;
            theta += step;
        }
        arcPerimeter[arcPerimeter.length - 1] = isCircle ? arcPerimeter[0] : pointOnCircle.apply(end);
        return arcPerimeter;
    }

    protected static class CoordinateSpliterator
    implements Spliterator<Coordinate> {
        private final List<? extends Number> source;
        private final int dimension;
        private int idx = 0;

        public CoordinateSpliterator(List<? extends Number> source, int dimension) {
            ArgumentChecks.ensureNonNull("Source data", source);
            ArgumentChecks.ensureSizeBetween("Batch size", 2, 3, dimension);
            if (source.size() % dimension != 0) {
                throw new IllegalArgumentException(String.format("Source list size is not a multiple of queried dimension.%nSource size: %d%nQueried dimension: %d", source.size(), dimension));
            }
            this.source = source;
            this.dimension = dimension;
        }

        @Override
        public Spliterator<Coordinate> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return (this.source.size() - this.idx) / this.dimension;
        }

        @Override
        public int characteristics() {
            return 1104;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Coordinate> action) {
            if (this.idx > this.source.size() - this.dimension) {
                return false;
            }
            action.accept((Coordinate)(switch (this.dimension) {
                case 2 -> new Coordinate(this.source.get(this.idx++).doubleValue(), this.source.get(this.idx++).doubleValue());
                case 3 -> new Coordinate(this.source.get(this.idx++).doubleValue(), this.source.get(this.idx++).doubleValue(), this.source.get(this.idx++).doubleValue());
                default -> throw new IllegalStateException("Dimension value is invalid");
            }));
            return true;
        }
    }
}

