/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.geotoolkit.gml.xml.v311.GridType;
import org.geotoolkit.gml.xml.v311.PointType;
import org.geotoolkit.gml.xml.v311.VectorType;
import org.opengis.coverage.grid.Grid;
import org.opengis.coverage.grid.RectifiedGrid;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RectifiedGridType", propOrder={"origin", "offsetVector"})
public class RectifiedGridType
extends GridType {
    @XmlElement(required=true)
    private PointType origin;
    @XmlElement(required=true)
    private List<VectorType> offsetVector;

    public RectifiedGridType() {
    }

    public RectifiedGridType(RectifiedGrid grid) {
        super((Grid)grid);
        if (grid != null) {
            this.origin = new PointType(grid.getOrigin(), false);
            this.offsetVector = new ArrayList<VectorType>();
            List vectors = grid.getOffsetVectors();
            for (double[] vector : vectors) {
                this.offsetVector.add(new VectorType(vector));
            }
        }
    }

    public RectifiedGridType(GridGeometry gg) throws TransformException {
        super(gg);
        if (gg != null) {
            MathTransform gridToCRS = gg.getGridToCRS(PixelInCell.CELL_CORNER);
            DirectPosition ori = gridToCRS.transform((DirectPosition)new GeneralDirectPosition(gridToCRS.getSourceDimensions()), null);
            this.origin = new PointType(ori, false);
            this.origin.setId("pt-" + new Random().nextInt());
            this.offsetVector = new ArrayList<VectorType>();
            Matrix m = MathTransforms.getMatrix((MathTransform)gridToCRS);
            if (m == null) {
                m = MathTransforms.getMatrix((MathTransform)gg.selectDimensions(new int[]{0, 1}).getGridToCRS(PixelInCell.CELL_CORNER));
            }
            if (m != null) {
                for (int j = 0; j < m.getNumRow() - 1; ++j) {
                    double[] row = new double[gridToCRS.getSourceDimensions()];
                    for (int i = 0; i < m.getNumCol() - 1; ++i) {
                        row[i] = m.getElement(j, i);
                    }
                    this.offsetVector.add(new VectorType(row));
                }
            }
        }
    }

    public PointType getOrigin() {
        return this.origin;
    }

    public void setOrigin(PointType origin) {
        this.origin = origin;
    }

    public List<VectorType> getOffsetVector() {
        return this.offsetVector;
    }

    public void setOffsetVector(List<VectorType> offsetVector) {
        this.offsetVector = offsetVector;
    }
}

