/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;

public final class IdentityConverter<S extends T, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = -4410848323263094741L;
    private final SystemConverter<T, S> inverse;

    public IdentityConverter(Class<S> sourceClass, Class<T> targetClass, SystemConverter<T, S> inverse) {
        super(sourceClass, targetClass);
        if (inverse == null && sourceClass == targetClass) {
            inverse = this;
        }
        this.inverse = inverse;
    }

    @Override
    public Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> properties = EnumSet.allOf(FunctionProperty.class);
        if (this.inverse == null) {
            properties.remove((Object)FunctionProperty.INVERTIBLE);
        }
        return properties;
    }

    @Override
    public ObjectConverter<T, S> inverse() throws UnsupportedOperationException {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    public T apply(S source) {
        return (T)source;
    }
}

