/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;

class ObjectToString<S>
extends SystemConverter<S, String> {
    private static final long serialVersionUID = 502567744195102675L;
    private final SystemConverter<String, S> inverse;

    ObjectToString(Class<S> sourceClass, SystemConverter<String, S> inverse) {
        super(sourceClass, String.class);
        this.inverse = inverse;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.INVERTIBLE);
    }

    @Override
    public String apply(S source) {
        return source != null ? source.toString() : null;
    }

    @Override
    public final ObjectConverter<String, S> inverse() {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    public final ObjectConverter<S, String> unique() {
        ObjectConverter<S, String> singleton;
        if (this.inverse != null && (singleton = this.inverse.unique().inverse()) != null) {
            return singleton;
        }
        return this;
    }

    static final class Enum<S extends java.lang.Enum<S>>
    extends ObjectToString<S> {
        private static final long serialVersionUID = 5391817175838307542L;

        Enum(Class<S> sourceClass, SystemConverter<String, S> inverse) {
            super(sourceClass, inverse);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE, FunctionProperty.INVERTIBLE);
        }

        @Override
        public String apply(S source) {
            return source != null ? ((java.lang.Enum)source).name() : null;
        }
    }

    static final class CodeList<S extends org.opengis.util.CodeList<S>>
    extends ObjectToString<S> {
        private static final long serialVersionUID = 1454105232343463228L;

        CodeList(Class<S> sourceClass, SystemConverter<String, S> inverse) {
            super(sourceClass, inverse);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE, FunctionProperty.INVERTIBLE);
        }

        @Override
        public String apply(S source) {
            return source != null ? ((org.opengis.util.CodeList)source).name() : null;
        }
    }
}

