/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.temporal;

import java.util.Objects;
import org.apache.sis.internal.temporal.Primitive;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;

final class DefaultPeriod
extends Primitive
implements Period {
    private final Instant beginning;
    private final Instant ending;

    DefaultPeriod(Instant beginning, Instant ending) {
        this.beginning = beginning;
        this.ending = ending;
    }

    @Override
    public Instant getBeginning() {
        return this.beginning;
    }

    @Override
    public Instant getEnding() {
        return this.ending;
    }

    public String toString() {
        return "[" + String.valueOf(this.beginning) + " \u2026 " + String.valueOf(this.ending) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.beginning, this.ending);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultPeriod) {
            DefaultPeriod other = (DefaultPeriod)obj;
            return Objects.equals(other.beginning, this.beginning) && Objects.equals(other.ending, this.ending);
        }
        return false;
    }
}

