/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.relatedtables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.extensions.relatedtables.RTEBase;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SimpleAttributesTests
extends RTEBase {
    @Override
    @BeforeClass
    public void activeExtension(ITestContext testContext) throws SQLException {
        super.activeExtension(testContext);
        this.testRequirementsClassActive("simple_attributes", "Simple Attributes");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 18-000: Requirement 15")
    public void attributesTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT related_table_name FROM gpkgext_relations WHERE relation_name = 'simple_attributes';");){
            block26: while (resultSet.next()) {
                String simpleAttributesTableName = resultSet.getString("related_table_name");
                this.getPrimaryKeyColumn(simpleAttributesTableName, true);
                Statement statement2 = this.databaseConnection.createStatement();
                try {
                    ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", simpleAttributesTableName));
                    try {
                        while (true) {
                            if (!resultSet2.next()) continue block26;
                            String type = resultSet2.getString("type");
                            String name = resultSet2.getString("name");
                            switch (type) {
                                case "BLOB": {
                                    Assert.fail((String)ErrorMessage.format("InvalidDataType", type, name, simpleAttributesTableName));
                                    break;
                                }
                            }
                            int notNull = resultSet2.getInt("notnull");
                            Assert.assertEquals((int)notNull, (int)1, (String)ErrorMessage.format("InvalidColumnDefinition", name, simpleAttributesTableName, "notnull", 1, notNull));
                        }
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        resultSet2.close();
                    }
                }
                finally {
                    if (statement2 == null) continue;
                    statement2.close();
                }
            }
            return;
        }
    }
}

