/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.apache.sis.util.resources.Errors;

public final class TransferType<T extends Buffer>
implements Serializable {
    private static final long serialVersionUID = -2891665589742927570L;
    private final transient String name;
    final int dataBufferType;
    public static final TransferType<IntBuffer> INT = new TransferType("INT", 3);
    public static final TransferType<FloatBuffer> FLOAT = new TransferType("FLOAT", 4);
    public static final TransferType<DoubleBuffer> DOUBLE = new TransferType("DOUBLE", 5);

    private TransferType(String name, int dataBufferType) {
        this.name = name;
        this.dataBufferType = dataBufferType;
    }

    public static TransferType<?> valueOf(int type) {
        switch (type) {
            case 5: {
                return DOUBLE;
            }
            case 4: {
                return FLOAT;
            }
        }
        if (type >= 0 && type <= 3) {
            return INT;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "type", type));
    }

    Object readResolve() throws ObjectStreamException {
        try {
            return TransferType.valueOf(this.dataBufferType);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectException(e.toString());
        }
    }

    public String toString() {
        return this.name;
    }
}

