/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Numbers;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CommonDomainFinder {
    public static final boolean INTERSECTION = true;
    private GridGeometry reference;
    private CoordinateReferenceSystem crs;
    private MathTransform crsToGrid;
    private final PixelInCell anchor;
    private GridExtent extent;
    private final Map<GridGeometry, long[]> gridTranslations;
    private long[][] itemTranslations;
    private int sourceOfGridToCRS;

    CommonDomainFinder(PixelInCell anchor) {
        this.anchor = anchor;
        this.gridTranslations = new LinkedHashMap<GridGeometry, long[]>();
    }

    final void setFromGridAligned(GridGeometry ... items) {
        this.itemTranslations = new long[items.length][];
        for (int i = 0; i < items.length; ++i) {
            this.itemTranslations[i] = this.gridTranslations.computeIfAbsent(items[i], this::itemToCommon);
        }
        GridGeometry fallback = null;
        GridExtent location = null;
        for (Map.Entry<GridGeometry, long[]> entry : this.gridTranslations.entrySet()) {
            GridExtent expected;
            GridGeometry item = entry.getKey();
            GridExtent actual = item.getExtent();
            if (actual.equals(expected = this.extent.translate(entry.getValue()))) {
                this.setGridToCRS(items, item);
                this.reference = item;
                return;
            }
            if (fallback != null || !expected.getLow().equals((Object)actual.getLow())) continue;
            location = expected;
            fallback = item;
        }
        if (fallback == null) {
            fallback = this.reference;
            location = this.extent;
        }
        this.setGridToCRS(items, fallback);
        try {
            this.reference = fallback.relocate(location);
        }
        catch (TransformException e) {
            throw new IllegalGridGeometryException(Resources.format((short)87), e);
        }
    }

    private void setGridToCRS(GridGeometry[] items, GridGeometry item) {
        this.sourceOfGridToCRS = CommonDomainFinder.indexOf(items, item);
        if (item == this.reference) {
            return;
        }
        long[] oldReference = this.itemTranslations[CommonDomainFinder.indexOf(items, this.reference)];
        long[] newReference = this.itemTranslations[this.sourceOfGridToCRS];
        long[] change = new long[newReference.length];
        for (int i = 0; i < newReference.length; ++i) {
            change[i] = Math.subtractExact(newReference[i], oldReference[i]);
        }
        for (long[] offset : this.gridTranslations.values()) {
            for (int i = 0; i < offset.length; ++i) {
                offset[i] = Math.subtractExact(offset[i], change[i]);
            }
        }
    }

    private static int indexOf(GridGeometry[] items, GridGeometry item) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != item) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    final GridGeometry result() {
        if (this.crs != null && !this.reference.isDefined(1)) {
            this.reference = new GridGeometry(this.extent, this.anchor, this.reference.getGridToCRS(this.anchor), this.crs);
        }
        return this.reference;
    }

    final long[][] gridTranslations() {
        return this.itemTranslations;
    }

    final int sourceOfGridToCRS() {
        return this.sourceOfGridToCRS;
    }

    private long[] itemToCommon(GridGeometry item) {
        MathTransform change = item.getGridToCRS(this.anchor);
        try {
            if (this.crsToGrid == null) {
                this.crsToGrid = change.inverse();
                this.reference = item;
            }
            if (item.isDefined(1)) {
                CoordinateReferenceSystem src = item.getCoordinateReferenceSystem();
                if (this.crs == null) {
                    this.crs = src;
                } else {
                    change = MathTransforms.concatenate((MathTransform)change, (MathTransform)CRS.findOperation((CoordinateReferenceSystem)src, (CoordinateReferenceSystem)this.crs, null).getMathTransform());
                }
            }
            change = MathTransforms.concatenate((MathTransform)change, (MathTransform)this.crsToGrid);
        }
        catch (MismatchedDimensionException | NoninvertibleTransformException | FactoryException e) {
            throw new IllegalGridGeometryException(Resources.format((short)87), e);
        }
        long[] offset = CommonDomainFinder.integerTranslation(MathTransforms.getMatrix((MathTransform)change), null);
        if (offset == null) {
            throw new IllegalGridGeometryException(Resources.format((short)87));
        }
        GridExtent e = item.getExtent().translate(offset);
        this.extent = this.extent == null ? e : this.extent.intersect(e);
        for (int i = 0; i < offset.length; ++i) {
            offset[i] = Math.negateExact(offset[i]);
        }
        return offset;
    }

    public static long[] integerTranslation(Matrix change, long[] offset) {
        if (change == null) {
            return null;
        }
        int numRows = change.getNumRow();
        int numCols = change.getNumCol();
        for (int j = 0; j < numRows; ++j) {
            for (int i = 0; i < numCols; ++i) {
                double tolerance = 1.0E-13;
                double e = change.getElement(j, i);
                if (i == j) {
                    e -= 1.0;
                } else if (i == numCols - 1) {
                    double a = Math.abs(e);
                    if (a > 1.0) {
                        tolerance = Math.min(tolerance * a, 0.125);
                    }
                    e -= Math.rint(e);
                }
                if (Math.abs(e) <= tolerance) continue;
                return null;
            }
        }
        if (offset == null) {
            offset = new long[numRows - 1];
        }
        int i = numCols - 1;
        if (change instanceof ExtendedPrecisionMatrix) {
            ExtendedPrecisionMatrix epm = (ExtendedPrecisionMatrix)change;
            for (int j = 0; j < offset.length; ++j) {
                Number e = epm.getElementOrNull(j, i);
                offset[j] = e != null ? Numbers.round(e) : 0L;
            }
        } else {
            for (int j = 0; j < offset.length; ++j) {
                offset[j] = Math.round(change.getElement(j, i));
            }
        }
        return offset;
    }
}

