/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.image.ComponentColorModel;
import java.awt.image.RasterFormatException;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.feature.Resources;

final class ScaledColorModel
extends ComponentColorModel {
    private static final int MASK = 255;
    static final int RANGE = 256;
    private final ScaledColorSpace cs;

    ScaledColorModel(ScaledColorSpace colorSpace, int type) {
        super(colorSpace, false, false, 2, type);
        this.cs = colorSpace;
    }

    final ScaledColorModel derive(int numBands, int visibleBand) {
        if (numBands == this.cs.getNumComponents() && visibleBand == this.cs.visibleBand) {
            return this;
        }
        return new ScaledColorModel(new ScaledColorSpace(this.cs, numBands, visibleBand), this.transferType);
    }

    @Override
    public int getRed(int value) {
        return this.getRGB(value) >>> 16 & 0xFF;
    }

    @Override
    public int getRed(Object value) {
        return this.getRGB(value) >>> 16 & 0xFF;
    }

    @Override
    public int getGreen(int value) {
        return this.getRGB(value) >>> 8 & 0xFF;
    }

    @Override
    public int getGreen(Object value) {
        return this.getRGB(value) >>> 8 & 0xFF;
    }

    @Override
    public int getBlue(int value) {
        return this.getRGB(value) & 0xFF;
    }

    @Override
    public int getBlue(Object value) {
        return this.getRGB(value) & 0xFF;
    }

    @Override
    public int getAlpha(int value) {
        return 255;
    }

    @Override
    public int getTransparency() {
        return ImageUtilities.isIntegerType(this.transferType) ? 1 : 2;
    }

    @Override
    public int getAlpha(Object inData) {
        int visibleBand = this.cs.visibleBand;
        switch (this.transferType) {
            case 4: {
                return Float.isNaN(((float[])inData)[visibleBand]) ? 0 : 255;
            }
            case 5: {
                return Double.isNaN(((double[])inData)[visibleBand]) ? 0 : 255;
            }
        }
        return 255;
    }

    @Override
    public int getRGB(Object inData) {
        double value;
        int visibleBand = this.cs.visibleBand;
        switch (this.transferType) {
            case 0: {
                value = Byte.toUnsignedInt(((byte[])inData)[visibleBand]);
                break;
            }
            case 1: {
                value = Short.toUnsignedInt(((short[])inData)[visibleBand]);
                break;
            }
            case 2: {
                value = ((short[])inData)[visibleBand];
                break;
            }
            case 3: {
                value = ((int[])inData)[visibleBand];
                break;
            }
            case 4: {
                value = ((float[])inData)[visibleBand];
                break;
            }
            case 5: {
                value = ((double[])inData)[visibleBand];
                break;
            }
            default: {
                throw new RasterFormatException(Resources.format((short)69, this.transferType));
            }
        }
        if (Double.isNaN(value)) {
            return 0;
        }
        int c = Math.max(0, Math.min(255, (int)((value - this.cs.offset) * this.cs.scale)));
        return c | c << 8 | c << 16 | 0xFF000000;
    }

    @Override
    public int getRGB(int value) {
        int c = Math.max(0, Math.min(255, (int)(((double)value - this.cs.offset) * this.cs.scale)));
        return c | c << 8 | c << 16 | 0xFF000000;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ScaledColorModel) {
            ScaledColorModel other = (ScaledColorModel)obj;
            return this.transferType == other.getTransferType() && this.cs.equals(other.cs);
        }
        return false;
    }
}

