/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.sis.internal.feature.Resources;
import org.opengis.filter.ComparisonOperatorName;
import org.opengis.filter.DistanceOperatorName;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.LogicalOperatorName;
import org.opengis.filter.SpatialOperatorName;
import org.opengis.filter.TemporalOperatorName;
import org.opengis.util.CodeList;

public abstract class Visitor<R, A> {
    private final Map<CodeList<?>, BiConsumer<Filter<R>, A>> filters;
    private final Map<String, BiConsumer<Expression<R, ?>, A>> expressions;

    protected Visitor() {
        this.filters = new HashMap();
        this.expressions = new HashMap();
    }

    protected Visitor(boolean hasFilters, boolean hasExpressions) {
        this.filters = hasFilters ? new HashMap() : Collections.emptyMap();
        this.expressions = hasExpressions ? new HashMap() : Collections.emptyMap();
    }

    protected Visitor(Visitor<R, A> source, boolean copyFilters, boolean copyExpressions) {
        this.filters = copyFilters ? new HashMap(source.filters) : source.filters;
        this.expressions = copyExpressions ? new HashMap(source.expressions) : source.expressions;
    }

    protected final BiConsumer<Filter<R>, A> getFilterHandler(CodeList<?> type) {
        return this.filters.get(type);
    }

    protected final BiConsumer<Expression<R, ?>, A> getExpressionHandler(String type) {
        return this.expressions.get(type);
    }

    protected final void setFilterHandler(CodeList<?> type, BiConsumer<Filter<R>, A> action) {
        this.filters.put(type, action);
    }

    private void setFamilyHandlers(CodeList<?> lastType, BiConsumer<Filter<R>, A> action) {
        for (CodeList type : lastType.family()) {
            this.filters.put(type, action);
            if (type == lastType) break;
        }
    }

    protected final void setExpressionHandler(String type, BiConsumer<Expression<R, ?>, A> action) {
        this.expressions.put(type, action);
    }

    private void setExpressionHandlers(BiConsumer<Expression<R, ?>, A> action, String ... types) {
        for (String type : types) {
            this.expressions.put(type, action);
        }
    }

    protected final void setLogicalHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers((CodeList<?>)LogicalOperatorName.NOT, action);
    }

    protected final void setNullAndNilHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFilterHandler((CodeList<?>)ComparisonOperatorName.valueOf((String)"PROPERTY_IS_NULL"), action);
        this.setFilterHandler((CodeList<?>)ComparisonOperatorName.valueOf((String)"PROPERTY_IS_NIL"), action);
    }

    protected final void setBinaryComparisonHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers((CodeList<?>)ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, action);
    }

    protected final void setBinaryTemporalHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers((CodeList<?>)TemporalOperatorName.ANY_INTERACTS, action);
    }

    protected final void setSpatialHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers((CodeList<?>)SpatialOperatorName.OVERLAPS, action);
        this.setFamilyHandlers((CodeList<?>)DistanceOperatorName.WITHIN, action);
    }

    protected final void setMathHandlers(BiConsumer<Expression<R, ?>, A> action) {
        this.setExpressionHandlers(action, "Add", "Subtract", "Multiply", "Divide");
    }

    protected final void removeFilterHandlers(Collection<? extends CodeList<?>> types) {
        this.filters.keySet().removeAll(types);
    }

    public void visit(Filter<R> filter, A accumulator) {
        CodeList type = filter != null ? filter.getOperatorType() : null;
        BiConsumer<Filter<R>, A> f = this.filters.get(type);
        if (f != null) {
            f.accept(filter, accumulator);
        } else {
            this.typeNotFound(type, filter, accumulator);
        }
    }

    public void visit(Expression<R, ?> expression, A accumulator) {
        String type = expression != null ? expression.getFunctionName().tip().toString() : null;
        BiConsumer<Expression<R, ?>, A> f = this.expressions.get(type);
        if (f != null) {
            f.accept(expression, accumulator);
        } else {
            this.typeNotFound(type, expression, accumulator);
        }
    }

    protected void typeNotFound(CodeList<?> type, Filter<R> filter, A accumulator) {
        throw new UnsupportedOperationException(Resources.format((short)77, 0, type));
    }

    protected void typeNotFound(String type, Expression<R, ?> expression, A accumulator) {
        throw new UnsupportedOperationException(Resources.format((short)77, 1, type));
    }
}

