/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.image.RenderedImage;
import org.apache.sis.internal.processing.image.TiledProcess;
import org.apache.sis.internal.processing.isoline.Isolines;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class Parallelized
extends TiledProcess<Isolines[]> {
    private final double[][] levels;
    private final MathTransform gridToCRS;

    Parallelized(RenderedImage data, double[][] levels, MathTransform gridToCRS) {
        super(data, 1, 1, Isolines.iterators());
        this.levels = levels;
        this.gridToCRS = gridToCRS;
    }

    @Override
    protected TiledProcess.Task createSubTask() {
        return new Tile();
    }

    private final class Tile
    extends TiledProcess.Task {
        private Isolines[] isolines;

        Tile() {
        }

        @Override
        protected void execute() throws TransformException {
            this.isolines = Isolines.generate(this.iterator, Parallelized.this.levels, Parallelized.this.gridToCRS);
        }

        @Override
        protected void merge(TiledProcess.Task neighbor) throws TransformException {
            Isolines.merge(this.isolines, ((Tile)neighbor).isolines);
        }

        protected Isolines[] result() throws TransformException {
            return Isolines.flush(this.isolines);
        }
    }
}

