/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.code.DS_AssociationTypeCode;
import org.apache.sis.internal.jaxb.code.DS_InitiativeTypeCode;
import org.apache.sis.internal.jaxb.metadata.CI_Citation;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.AssociatedResource;
import org.opengis.metadata.identification.AssociationType;
import org.opengis.metadata.identification.InitiativeType;

@XmlType(name="MD_AssociatedResource_Type", propOrder={"name", "associationType", "initiativeType", "metadataReference"})
@XmlRootElement(name="MD_AssociatedResource")
public class DefaultAssociatedResource
extends ISOMetadata
implements AssociatedResource {
    private static final long serialVersionUID = -803259032236939135L;
    private Citation name;
    private AssociationType associationType;
    private InitiativeType initiativeType;
    private Citation metadataReference;

    public DefaultAssociatedResource() {
    }

    public DefaultAssociatedResource(Citation name, AssociationType associationType) {
        this.name = name;
        this.associationType = associationType;
    }

    public DefaultAssociatedResource(AssociatedResource object) {
        if (object != null) {
            this.name = object.getName();
            this.associationType = object.getAssociationType();
            this.initiativeType = object.getInitiativeType();
            this.metadataReference = object.getMetadataReference();
        }
    }

    public static DefaultAssociatedResource castOrCopy(AssociatedResource object) {
        if (object == null || object instanceof DefaultAssociatedResource) {
            return (DefaultAssociatedResource)object;
        }
        return new DefaultAssociatedResource(object);
    }

    @XmlElement(name="name")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="associationType", required=true)
    @XmlJavaTypeAdapter(value=DS_AssociationTypeCode.Since2014.class)
    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(AssociationType newValue) {
        this.checkWritePermission(this.associationType);
        this.associationType = newValue;
    }

    @XmlElement(name="initiativeType")
    @XmlJavaTypeAdapter(value=DS_InitiativeTypeCode.Since2014.class)
    public InitiativeType getInitiativeType() {
        return this.initiativeType;
    }

    public void setInitiativeType(InitiativeType newValue) {
        this.checkWritePermission(this.initiativeType);
        this.initiativeType = newValue;
    }

    @XmlElement(name="metadataReference")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    public Citation getMetadataReference() {
        return this.metadataReference;
    }

    public void setMetadataReference(Citation newValue) {
        this.checkWritePermission(this.metadataReference);
        this.metadataReference = newValue;
    }
}

