/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.referencing.CRS;
import org.geotoolkit.io.ContentFormatException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class PrjFiles
extends Static {
    private static final String ENCODING = "ISO-8859-1";

    private PrjFiles() {
    }

    public static CoordinateReferenceSystem read(File file) throws ContentFormatException, IOException {
        return PrjFiles.read(new FileInputStream(file), true);
    }

    public static CoordinateReferenceSystem read(Path file) throws ContentFormatException, IOException {
        return PrjFiles.read(Files.newInputStream(file, new OpenOption[0]), true);
    }

    public static CoordinateReferenceSystem read(URL file) throws ContentFormatException, IOException {
        return PrjFiles.read(file.openStream(), true);
    }

    public static CoordinateReferenceSystem read(ReadableByteChannel in, boolean close) throws ContentFormatException, IOException {
        return PrjFiles.read(Channels.newInputStream(in), close);
    }

    public static CoordinateReferenceSystem read(InputStream in, boolean close) throws ContentFormatException, IOException {
        return PrjFiles.read(new BufferedReader(new InputStreamReader(in, ENCODING)), close);
    }

    public static CoordinateReferenceSystem read(BufferedReader in, boolean close) throws ContentFormatException, IOException {
        String line;
        StringBuilder buffer = null;
        String wkt = null;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            if (wkt == null) {
                wkt = line;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder(wkt);
            }
            buffer.append('\n').append(line);
        }
        if (close) {
            in.close();
        }
        if (buffer != null) {
            wkt = buffer.toString();
        }
        if (wkt == null) {
            throw new EOFException(Errors.format((short)41));
        }
        try {
            return CRS.fromWKT((String)wkt);
        }
        catch (FactoryException e) {
            throw new ContentFormatException(e.getLocalizedMessage(), e);
        }
    }

    private static String format(CoordinateReferenceSystem crs) throws ContentFormatException {
        WKTFormat format = new WKTFormat(null, null);
        format.setConvention(Convention.WKT1);
        format.setIndentation(-1);
        String wkt = format.format((Object)crs);
        Warnings warning = format.getWarnings();
        if (warning != null) {
            throw new ContentFormatException(warning.toString());
        }
        return wkt;
    }

    public static void write(CoordinateReferenceSystem crs, File file) throws ContentFormatException, IOException {
        String wkt = PrjFiles.format(crs);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING);){
            out.write(wkt);
            ((Writer)out).write(10);
        }
    }

    public static void write(CoordinateReferenceSystem crs, Path file) throws ContentFormatException, IOException {
        String wkt = PrjFiles.format(crs);
        try (BufferedWriter out = Files.newBufferedWriter(file, Charset.forName(ENCODING), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            out.write(wkt);
            ((Writer)out).write(10);
        }
    }

    public static void write(CoordinateReferenceSystem crs, WritableByteChannel out) throws ContentFormatException, IOException {
        PrjFiles.write(crs, Channels.newOutputStream(out));
    }

    public static void write(CoordinateReferenceSystem crs, OutputStream out) throws ContentFormatException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, ENCODING);
        PrjFiles.write(crs, writer);
        ((Writer)writer).flush();
    }

    public static void write(CoordinateReferenceSystem crs, Writer out) throws ContentFormatException, IOException {
        out.write(PrjFiles.format(crs));
        out.write(10);
    }
}

