/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import org.geotoolkit.gml.AxisResolve;
import org.geotoolkit.gml.GeometryTransformer;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.GMLMarshallerPool;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.util.FactoryException;

public class GeometrytoJTS {
    private GeometrytoJTS() {
    }

    public static Geometry toJTS(String gmlString) throws JAXBException, FactoryException {
        StringReader reader = new StringReader(gmlString);
        Unmarshaller unmarshaller = GMLMarshallerPool.getInstance().acquireUnmarshaller();
        Object jax = unmarshaller.unmarshal((Reader)reader);
        GMLMarshallerPool.getInstance().recycle(unmarshaller);
        if (jax instanceof JAXBElement) {
            jax = ((JAXBElement)jax).getValue();
        }
        if (jax instanceof AbstractGeometry) {
            return GeometrytoJTS.toJTS((AbstractGeometry)jax);
        }
        throw new JAXBException("Object is not a valid GML " + jax);
    }

    public static Geometry toJTS(AbstractGeometry gml) throws NoSuchAuthorityCodeException, FactoryException {
        return GeometrytoJTS.toJTS(false, gml);
    }

    public static Geometry toJTS(boolean forceMultiPolygon, AbstractGeometry gml) {
        GeometryTransformer gt = new GeometryTransformer(gml);
        gt.setForceMultiPolygon(forceMultiPolygon);
        return gt.get();
    }

    public static Geometry toJTS(AbstractGeometry gml, AxisResolve axisResolve) throws NoSuchAuthorityCodeException, FactoryException {
        return GeometrytoJTS.toJTS(gml, axisResolve, false);
    }

    public static Geometry toJTS(AbstractGeometry gml, AxisResolve axisResolve, boolean forceMultiPolygon) throws NoSuchAuthorityCodeException, FactoryException {
        GeometryTransformer gt = new GeometryTransformer(gml);
        gt.setAxisResolve(axisResolve);
        gt.setForceMultiPolygon(forceMultiPolygon);
        return gt.get();
    }

    @Deprecated
    public static Geometry toJTS(AbstractGeometry gml, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        return GeometrytoJTS.toJTS(gml, longitudeFirst, false);
    }

    @Deprecated
    public static Geometry toJTS(AbstractGeometry gml, boolean longitudefirst, boolean forceMultiPolygon) throws NoSuchAuthorityCodeException, FactoryException {
        return GeometrytoJTS.toJTS(gml, longitudefirst ? AxisResolve.RIGHT_HANDED : AxisResolve.STRICT, forceMultiPolygon);
    }
}

