/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.opengis.cite.gpkg12.ColumnDefinition;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public abstract class TileFixture
extends CommonFixture {
    private String dataType = "tiles";
    protected final Collection<String> tileTableNames = new ArrayList<String>();
    private static final double EPSILON = 1.0E-4;
    protected static final Collection<ImageReader> jpegImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/jpeg"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    protected static final Collection<ImageReader> pngImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/png"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    protected static final Map<String, ColumnDefinition> TileTableExpectedColumns = new HashMap<String, ColumnDefinition>();

    protected static boolean isEqual(double first, double second) {
        return Math.abs(first - second) < 1.0E-4;
    }

    @BeforeClass
    public void setUp() throws SQLException {
        String tableName;
        ArrayList<String> extensionTableNames = new ArrayList<String>();
        if (DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions")) {
            try (Statement statement2 = this.databaseConnection.createStatement();
                 ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_extensions WHERE column_name = 'tile_data';");){
                while (resultSet2.next()) {
                    tableName = resultSet2.getString(1);
                    extensionTableNames.add(tableName);
                }
            }
        }
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT table_name FROM gpkg_contents WHERE data_type = '%s';", this.dataType));){
            while (resultSet.next()) {
                tableName = resultSet.getString(1);
                this.tileTableNames.add(tableName);
            }
            this.tileTableNames.removeAll(extensionTableNames);
            Assert.assertTrue((!this.tileTableNames.isEmpty() ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassDisabled", this.getTestName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean canReadImage(Iterable<ImageReader> imageReaders, ImageInputStream image) throws IOException {
        for (ImageReader imageReader : imageReaders) {
            try {
                image.mark();
                if (!imageReader.getOriginatingProvider().canDecodeInput(image)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                image.reset();
            }
        }
        return false;
    }

    protected boolean isAcceptedImageFormat(byte[] image) throws IOException {
        if (image == null) {
            return false;
        }
        try (ByteArrayInputStream byteArray = new ByteArrayInputStream(image);){
            boolean bl;
            try (MemoryCacheImageInputStream cacheImage = new MemoryCacheImageInputStream(byteArray);){
                bl = TileFixture.canReadImage(pngImageReaders, cacheImage) || TileFixture.canReadImage(jpegImageReaders, cacheImage);
            }
            return bl;
        }
    }

    protected void setDataType(String dataType) {
        this.dataType = dataType;
    }

    static {
        TileTableExpectedColumns.put("id", new ColumnDefinition("INTEGER", false, true, true, null));
        TileTableExpectedColumns.put("zoom_level", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_column", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_row", new ColumnDefinition("INTEGER", true, false, false, null));
        TileTableExpectedColumns.put("tile_data", new ColumnDefinition("BLOB", true, false, false, null));
    }
}

