/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.coverage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.TileFixture;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TiledGriddedCoverageTests
extends TileFixture {
    protected static final Collection<ImageReader> tiffImageReaders = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ImageIO.getImageReadersByMIMEType("image/tiff"), 16), false).collect(Collectors.toCollection(ArrayList::new));
    private boolean hasExtension = false;
    private final Collection<String> elevationTableNames = new ArrayList<String>();

    public TiledGriddedCoverageTests() {
        this.setDataType("2d-gridded-coverage");
    }

    @BeforeClass
    public void a_ValidateExtensionPresent(ITestContext testContext) throws SQLException {
        Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkg_extensions"), (String)ErrorMessage.format("ConformanceClassDisabled", "Coverage Extension"));
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT COUNT(*) FROM gpkg_extensions WHERE table_name = 'gpkg_2d_gridded_coverage_ancillary';");){
            resultSet1.next();
            Assert.assertTrue((resultSet1.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("ConformanceClassDisabled", "Coverage Extension"));
        }
    }

    @Override
    @BeforeClass
    public void setUp() throws SQLException {
        if (!this.hasExtension) {
            return;
        }
        try (Statement statement2 = this.databaseConnection.createStatement();
             ResultSet resultSet2 = statement2.executeQuery("SELECT table_name FROM gpkg_contents WHERE data_type = '2d-gridded-coverage';");){
            while (resultSet2.next()) {
                this.elevationTableNames.add(resultSet2.getString("table_name"));
            }
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 1")
    public void coverageAncillaryTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_2d_gridded_coverage_ancillary');");){
            int passFlag = 0;
            int flagMask = 127;
            this.checkPrimaryKey("gpkg_2d_gridded_coverage_ancillary", "id", true);
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("id".equals(name)) {
                    passFlag |= 1;
                    continue;
                }
                if ("tile_matrix_set_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "tile_matrix_set_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "tile_matrix_set_name notnull"));
                    passFlag |= 2;
                    continue;
                }
                if ("datatype".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "datatype type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "datatype notnull"));
                    String def = resultSet.getString("dflt_value");
                    Assert.assertTrue(("integer".equals(def) || "'integer'".equals(def) ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "datatype default"));
                    passFlag |= 4;
                    continue;
                }
                if ("scale".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "scale type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "scale notnull"));
                    Assert.assertTrue(((double)resultSet.getFloat("dflt_value") == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "scale default"));
                    passFlag |= 8;
                    continue;
                }
                if ("offset".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "offset type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "offset notnull"));
                    Assert.assertTrue((resultSet.getFloat("dflt_value") == 0.0f ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "offset default"));
                    passFlag |= 0x10;
                    continue;
                }
                if ("precision".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "precision type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "precision type"));
                    Assert.assertTrue(((double)resultSet.getFloat("dflt_value") == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "precision default"));
                    passFlag |= 0x20;
                    continue;
                }
                if (!"data_null".equals(name)) continue;
                Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "data_null type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("CoverageAncillaryColumnsInvalid", "data_null notnull"));
                passFlag |= 0x40;
            }
            Assert.assertTrue(((passFlag & 0x7F) == 127 ? 1 : 0) != 0, (String)"CoverageAncillaryColumnsInvalid");
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 2")
    public void tileAncillaryTableDefinition() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_2d_gridded_tile_ancillary');");){
            long passFlag = 0L;
            long flagMask = 511L;
            while (resultSet.next()) {
                this.checkPrimaryKey("gpkg_2d_gridded_tile_ancillary", "id", true);
                String name = resultSet.getString("name");
                if ("id".equals(name)) {
                    passFlag |= 1L;
                    continue;
                }
                if ("tpudt_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_name type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_name notnull"));
                    passFlag |= 2L;
                    continue;
                }
                if ("tpudt_id".equals(name)) {
                    Assert.assertTrue((boolean)"INTEGER".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_id type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "tpudt_id notnull"));
                    passFlag |= 4L;
                    continue;
                }
                if ("scale".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "scale type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "scale notnull"));
                    Assert.assertTrue(((double)resultSet.getFloat("dflt_value") == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "scale default"));
                    passFlag |= 8L;
                    continue;
                }
                if ("offset".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "offset type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "offset notnull"));
                    Assert.assertTrue((resultSet.getFloat("dflt_value") == 0.0f ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "offset default"));
                    passFlag |= 0x10L;
                    continue;
                }
                if ("min".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "precision type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "precision type"));
                    passFlag |= 0x20L;
                    continue;
                }
                if ("max".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "data_null type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "data_null notnull"));
                    passFlag |= 0x40L;
                    continue;
                }
                if ("mean".equals(name)) {
                    Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "mean type"));
                    Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "mean type"));
                    passFlag |= 0x80L;
                    continue;
                }
                if (!"std_dev".equals(name)) continue;
                Assert.assertTrue((boolean)"REAL".equals(resultSet.getString("type")), (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "std_dev type"));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", "std_dev notnull"));
                passFlag |= 0x100L;
            }
            Assert.assertTrue(((passFlag & 0x1FFL) == 511L ? 1 : 0) != 0, (String)ErrorMessage.format("TileAncillaryColumnsInvalid", String.format("Missing column flag %d", passFlag)));
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 3")
    public void requiredSRSRows() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet srsDefaultValue = statement.executeQuery("SELECT COUNT(*) FROM gpkg_spatial_ref_sys WHERE organization_coordsys_id = 4979 AND (organization = 'EPSG' OR organization = 'epsg');");){
            Assert.assertTrue((srsDefaultValue.getInt(1) > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("NoElevationSrs", new Object[0]));
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 4")
    public void requiredSRSReferences() throws SQLException {
        for (String tableName : this.elevationTableNames) {
            Statement statement1 = this.databaseConnection.createStatement();
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT srs_id FROM gpkg_tile_matrix_set WHERE table_name = '%s'", tableName));
                try {
                    resultSet1.next();
                    String srsID = resultSet1.getString(1);
                    Statement statement2 = this.databaseConnection.createStatement();
                    try {
                        ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT COUNT(*) FROM gpkg_spatial_ref_sys WHERE srs_id = '%s'", srsID));
                        try {
                            Assert.assertTrue((resultSet2.getInt(1) == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("BadMatrixSetSrsReference", srsID));
                        }
                        finally {
                            if (resultSet2 == null) continue;
                            resultSet2.close();
                        }
                    }
                    finally {
                        if (statement2 == null) continue;
                        statement2.close();
                    }
                }
                finally {
                    if (resultSet1 == null) continue;
                    resultSet1.close();
                }
            }
            finally {
                if (statement1 == null) continue;
                statement1.close();
            }
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 6")
    public void extensionTableRows() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, extension_name, definition, scope from gpkg_extensions");){
            long passFlag = 0L;
            long flagMask = 3L;
            while (resultSet.next()) {
                String name = resultSet.getString("table_name");
                if ("gpkg_2d_gridded_coverage_ancillary".equals(name)) {
                    if (resultSet.getObject("column_name") != null || !"gpkg_2d_gridded_coverage".equals(resultSet.getString("extension_name")) || !"http://docs.opengeospatial.org/is/17-066r1/17-066r1.html".equals(resultSet.getString("definition")) || !"read-write".equals(resultSet.getString("scope"))) continue;
                    passFlag |= 1L;
                    continue;
                }
                if (!"gpkg_2d_gridded_tile_ancillary".equals(name) || resultSet.getObject("column_name") != null || !"gpkg_2d_gridded_coverage".equals(resultSet.getString("extension_name")) || !"http://docs.opengeospatial.org/is/17-066r1/17-066r1.html".equals(resultSet.getString("definition")) || !"read-write".equals(resultSet.getString("scope"))) continue;
                passFlag |= 2L;
            }
            Assert.assertTrue(((passFlag & 3L) == 3L ? 1 : 0) != 0, (String)ErrorMessage.format("ElevationExtensionRowsMissing", String.format("Missing column flag %d", passFlag)));
        }
        for (String tableName : this.elevationTableNames) {
            Statement statement1 = this.databaseConnection.createStatement();
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT column_name, definition, scope from gpkg_extensions WHERE extension_name = 'gpkg_2d_gridded_coverage' AND table_name = '%s'", tableName));
                try {
                    Assert.assertTrue((resultSet1.next() && "tile_data".equals(resultSet1.getObject("column_name")) && "gpkg_2d_gridded_coverage".equals(resultSet1.getString("extension_name")) && "http://docs.opengeospatial.org/is/17-066r1/17-066r1.html".equals(resultSet1.getString("definition")) && "read-write".equals(resultSet1.getString("scope")) ? 1 : 0) != 0, (String)"ElevationExtensionRowsMissing");
                }
                finally {
                    if (resultSet1 == null) continue;
                    resultSet1.close();
                }
            }
            finally {
                if (statement1 == null) continue;
                statement1.close();
            }
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 7")
    public void coverageAncillaryValues() throws SQLException {
        for (String tableName : this.elevationTableNames) {
            Statement statement1 = this.databaseConnection.createStatement();
            try {
                ResultSet resultSet1 = statement1.executeQuery(String.format("SELECT COUNT(*) FROM gpkg_2d_gridded_coverage_ancillary WHERE tile_matrix_set_name = '%s'", tableName));
                try {
                    resultSet1.next();
                    Assert.assertTrue((resultSet1.getInt(1) == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("MissingReference", "gpkg_2d_gridded_coverage_ancillary", "tile_matrix_set_name", tableName));
                }
                finally {
                    if (resultSet1 == null) continue;
                    resultSet1.close();
                }
            }
            finally {
                if (statement1 == null) continue;
                statement1.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 17-066r1: Requirement 8")
    public void coverageAncillarySetName() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT tile_matrix_set_name FROM 'gpkg_2d_gridded_coverage_ancillary';");){
            while (resultSet.next()) {
                String tileMatrixSetName = resultSet.getString(1);
                Statement statement2 = this.databaseConnection.createStatement();
                try {
                    ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT count(*) FROM gpkg_tile_matrix_set WHERE table_name = '%s';", tileMatrixSetName));
                    try {
                        Assert.assertTrue((resultSet2.getInt(1) == 1 ? 1 : 0) != 0, (String)"UnreferencedCoverageTileMatrixSetTable");
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        resultSet2.close();
                    }
                }
                finally {
                    if (statement2 == null) continue;
                    statement2.close();
                }
            }
            return;
        }
    }

    @Test(description="See OGC 17-066r1: Requirement 9")
    public void coverageAncillaryDatatype() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT tile_matrix_set_name, datatype, scale, offset FROM 'gpkg_2d_gridded_coverage_ancillary';");){
            while (resultSet.next()) {
                String setName = resultSet.getString("tile_matrix_set_name");
                if (!this.elevationTableNames.contains(setName)) continue;
                String datatype = resultSet.getString("datatype");
                Assert.assertTrue(("integer".equals(datatype) || "float".equals(datatype) ? 1 : 0) != 0, (String)"CoverageAncillaryDatatypeInvalid");
                if (!"float".equals(datatype)) continue;
                double scale = resultSet.getDouble("scale");
                double offset = resultSet.getDouble("offset");
                Assert.assertTrue((scale == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_coverage_ancillary", "datatype", "float", "scale", "1.0", Double.toString(scale), "tile_matrix_set_name", setName));
                Assert.assertTrue((offset == 0.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_coverage_ancillary", "datatype", "float", "offset", "0.0", Double.toString(offset), "tile_matrix_set_name", setName));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test(description="See OGC 17-066r1: Requirements 10, 12")
    public void tileAncillaryTableRef() throws SQLException {
        for (String tableName : this.elevationTableNames) {
            statement1 = this.databaseConnection.createStatement();
            try {
                resultSet1 = statement1.executeQuery(String.format("SELECT id FROM %s", new Object[]{tableName}));
lbl5:
                // 3 sources

                try {
                    while (resultSet1.next()) {
                        statement2 = this.databaseConnection.createStatement();
                        try {
                            resultSet2 = statement2.executeQuery("SELECT %s.id as tid, gpkg_2d_gridded_tile_ancillary.tpudt_id as taid from %s LEFT OUTER JOIN gpkg_2d_gridded_tile_ancillary ON %s.id = gpkg_2d_gridded_tile_ancillary.tpudt_id AND gpkg_2d_gridded_tile_ancillary.tpudt_name = '%s'".replace("%s", tableName));
                            try {
                                while (resultSet2.next()) {
                                    id = resultSet2.getString(1);
                                    resultSet2.getString(2);
                                    Assert.assertTrue((boolean)(resultSet2.wasNull() == false), (String)ErrorMessage.format("TileAncillaryReferences", new Object[]{tableName, id}));
                                }
                            }
                            finally {
                                if (resultSet2 == null) ** GOTO lbl5
                                resultSet2.close();
                            }
                        }
                        finally {
                            if (statement2 == null) ** GOTO lbl5
                            statement2.close();
                        }
                    }
                }
                finally {
                    if (resultSet1 == null) continue;
                    resultSet1.close();
                }
            }
            finally {
                if (statement1 == null) continue;
                statement1.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 17-066r1: Requirement 11")
    public void tileAncillaryTableVal() throws SQLException {
        try (Statement statement1 = this.databaseConnection.createStatement();
             ResultSet resultSet1 = statement1.executeQuery("SELECT tpudt_name, scale, offset FROM gpkg_2d_gridded_tile_ancillary;");){
            while (resultSet1.next()) {
                String tableName = resultSet1.getString("tpudt_name");
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", tableName));){
                    Assert.assertTrue((boolean)resultSet2.next(), (String)ErrorMessage.format("TileAncillaryTableRefInvalid", tableName));
                }
                Statement statement3 = this.databaseConnection.createStatement();
                try {
                    ResultSet resultSet3 = statement3.executeQuery(String.format("SELECT datatype from gpkg_2d_gridded_coverage_ancillary WHERE tile_matrix_set_name = '%s'", tableName));
                    try {
                        Assert.assertTrue((boolean)resultSet3.next(), (String)ErrorMessage.format("TileAncillaryTableRefInvalid", tableName));
                        String datatype = resultSet3.getString("datatype");
                        if (!"float".equals(datatype)) continue;
                        double scale = resultSet1.getDouble("scale");
                        double offset = resultSet1.getDouble("offset");
                        Assert.assertTrue((scale == 1.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_tile_ancillary", "datatype", "float", "scale", "1.0", Double.toString(scale), "tpudt_name", tableName));
                        Assert.assertTrue((offset == 0.0 ? 1 : 0) != 0, (String)ErrorMessage.format("IllegalValue", "gpkg_2d_gridded_tile_ancillary", "datatype", "float", "offset", "0.0", Double.toString(offset), "tpudt_name", tableName));
                    }
                    finally {
                        if (resultSet3 == null) continue;
                        resultSet3.close();
                    }
                }
                finally {
                    if (statement3 == null) continue;
                    statement3.close();
                }
            }
            return;
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 13/14")
    public void imageFormat() throws SQLException, IOException {
        for (String tableName : this.elevationTableNames) {
            LinkedList<Integer> failedTileIds = new LinkedList<Integer>();
            try (Statement statement = this.databaseConnection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT t.datatype AS datatype, u.id AS id, u.tile_data AS tile_data FROM gpkg_2d_gridded_coverage_ancillary t, %s u WHERE t.tile_matrix_set_name = '%s';".replace("%s", tableName));){
                while (resultSet.next()) {
                    String datatype = resultSet.getString("datatype");
                    int id = resultSet.getInt("id");
                    try (MemoryCacheImageInputStream cacheImage = new MemoryCacheImageInputStream(new ByteArrayInputStream(resultSet.getBytes("tile_data")));){
                        if ("float".equals(datatype)) {
                            if (TiledGriddedCoverageTests.canReadImage(tiffImageReaders, cacheImage)) continue;
                            failedTileIds.add(id);
                            continue;
                        }
                        if (!"integer".equals(datatype) || TiledGriddedCoverageTests.canReadImage(pngImageReaders, cacheImage)) continue;
                        failedTileIds.add(id);
                    }
                }
            }
            Assert.assertTrue((boolean)failedTileIds.isEmpty(), (String)ErrorMessage.format("InvalidImageFormat", tableName, failedTileIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }
}

