/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.extensions.relatedtables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.extensions.relatedtables.RTEBase;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RTETests
extends RTEBase {
    @Test(description="See OGC 18-000: Requirement 1")
    public void extensionsTableEntries() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM gpkg_extensions WHERE table_name = 'gpkgext_relations';");){
            Assert.assertTrue((boolean)resultSet.next(), (String)ErrorMessage.format("MissingReference", "gpkg_extensions", "table_name", "gpkgext_relations"));
        }
        Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, "gpkgext_relations"), (String)ErrorMessage.format("MissingTable", "gpkgext_relations"));
    }

    @Test(description="See OGC 18-000: Requirement 2, 3")
    public void relationsTableEntries() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT table_name, column_name, scope FROM gpkg_extensions WHERE (extension_name IN ('related_tables', 'gpkg_related_tables') AND table_name != 'gpkgext_relations');");){
            boolean hasResults = false;
            while (resultSet.next()) {
                hasResults = true;
                String tableName = resultSet.getString("table_name");
                Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, tableName), (String)ErrorMessage.format("MissingTable", tableName));
                Assert.assertNull((Object)resultSet.getObject("column_name"), (String)ErrorMessage.format("UnexpectedValue", "(not null)", "column_name", "gpkg_extensions"));
                String scope = resultSet.getString("scope");
                Assert.assertEquals((String)scope, (String)"read-write", (String)ErrorMessage.format("UnexpectedValue", scope, "scope", "gpkg_extensions"));
            }
            Assert.assertTrue((boolean)hasResults, (String)ErrorMessage.format("MissingReference", "gpkg_extensions", "table_name", "a mapping table"));
        }
    }

    @Test(description="See OGC 18-000: Requirement 4")
    public void relationsTableStructure() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkgext_relations');");){
            int passFlag = 0;
            int flagMask = 127;
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("id".equals(name)) {
                    Assert.assertEquals((String)resultSet.getString("type"), (String)"INTEGER", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "id type"));
                    Assert.assertEquals((int)resultSet.getInt("notnull"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "id notnull"));
                    Assert.assertEquals((int)resultSet.getInt("pk"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "id pk"));
                    passFlag |= 1;
                    continue;
                }
                if ("base_table_name".equals(name)) {
                    Assert.assertEquals((String)resultSet.getString("type"), (String)"TEXT", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "base_table_name type"));
                    Assert.assertEquals((int)resultSet.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "base_table_name notnull"));
                    Assert.assertEquals((int)resultSet.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "base_table_name pk"));
                    passFlag |= 2;
                    continue;
                }
                if ("base_primary_column".equals(name)) {
                    Assert.assertEquals((String)resultSet.getString("type"), (String)"TEXT", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "base_primary_column type"));
                    Assert.assertEquals((int)resultSet.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "base_primary_column notnull"));
                    Assert.assertEquals((int)resultSet.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "base_primary_column pk"));
                    passFlag |= 4;
                    continue;
                }
                if ("related_table_name".equals(name)) {
                    Assert.assertEquals((String)resultSet.getString("type"), (String)"TEXT", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "related_table_name type"));
                    Assert.assertEquals((int)resultSet.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "related_table_name notnull"));
                    Assert.assertEquals((int)resultSet.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "related_table_name pk"));
                    passFlag |= 8;
                    continue;
                }
                if ("related_primary_column".equals(name)) {
                    Assert.assertEquals((String)resultSet.getString("type"), (String)"TEXT", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "related_primary_column type"));
                    Assert.assertEquals((int)resultSet.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "related_primary_column notnull"));
                    Assert.assertEquals((int)resultSet.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "related_primary_column pk"));
                    passFlag |= 0x10;
                    continue;
                }
                if ("relation_name".equals(name)) {
                    Assert.assertEquals((String)resultSet.getString("type"), (String)"TEXT", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "relation_name type"));
                    Assert.assertEquals((int)resultSet.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "relation_name notnull"));
                    Assert.assertEquals((int)resultSet.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "relation_name pk"));
                    passFlag |= 0x20;
                    continue;
                }
                if (!"mapping_table_name".equals(name)) continue;
                Assert.assertEquals((String)resultSet.getString("type"), (String)"TEXT", (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "mapping_table_name type"));
                Assert.assertEquals((int)resultSet.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "mapping_table_name notnull"));
                Assert.assertEquals((int)resultSet.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", "mapping_table_name pk"));
                passFlag |= 0x40;
            }
            Assert.assertTrue(((passFlag & 0x7F) == 127 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", "gpkgext_relations", String.format("missing column(s): code(%s)", passFlag)));
        }
    }

    @Test(description="See OGC 18-000: Requirement 5, 6, 7")
    public void relationsTableValues() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT base_table_name, related_table_name, mapping_table_name FROM gpkgext_relations;");){
            boolean hasResults = false;
            while (resultSet.next()) {
                hasResults = true;
                String baseTableName = resultSet.getString("base_table_name");
                Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, baseTableName), (String)ErrorMessage.format("MissingTable", baseTableName));
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT table_name FROM gpkg_contents WHERE table_name = '%s'", baseTableName));){
                    Assert.assertTrue((boolean)resultSet2.next(), (String)ErrorMessage.format("MissingReference", "gpkg_contents", "table_name", baseTableName));
                }
                String relatedTableName = resultSet.getString("related_table_name");
                Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, relatedTableName), (String)ErrorMessage.format("MissingTable", relatedTableName));
                try (Statement statement2 = this.databaseConnection.createStatement();
                     ResultSet resultSet3 = statement2.executeQuery(String.format("SELECT table_name FROM gpkg_contents WHERE table_name = '%s'", relatedTableName));){
                    Assert.assertTrue((boolean)resultSet3.next(), (String)ErrorMessage.format("MissingReference", "gpkg_contents", "table_name", relatedTableName));
                }
                String mappingTableName = resultSet.getString("mapping_table_name");
                Assert.assertTrue((boolean)DatabaseUtility.doesTableOrViewExist(this.databaseConnection, mappingTableName), (String)ErrorMessage.format("MissingTable", mappingTableName));
            }
            Assert.assertTrue((boolean)hasResults, (String)ErrorMessage.format("MissingRow", "gpkgext_relations"));
        }
    }

    @Test(description="See OGC 18-000: Requirement 8")
    public void relationName() throws SQLException {
        String query = "SELECT base_table_name, relation_name FROM gpkgext_relations WHERE (relation_name NOT IN ('features', 'simple_attributes', 'media', 'attributes', 'tiles') AND relation_name NOT LIKE 'x-%\\_%' ESCAPE '\\');";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT base_table_name, relation_name FROM gpkgext_relations WHERE (relation_name NOT IN ('features', 'simple_attributes', 'media', 'attributes', 'tiles') AND relation_name NOT LIKE 'x-%\\_%' ESCAPE '\\');");){
            if (resultSet.next()) {
                Assert.fail((String)ErrorMessage.format("UnexpectedValue", resultSet.getString("relation_name"), "relation_name", "gpkgext_relations"));
            }
        }
    }

    @Test(description="See OGC 18-000: Requirement 9")
    public void udmtTableStructure() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT mapping_table_name FROM gpkgext_relations;");){
            boolean hasResults = false;
            while (resultSet.next()) {
                hasResults = true;
                int passFlag = 0;
                int flagMask = 3;
                String mappingTableName = resultSet.getString("mapping_table_name");
                Statement statement2 = this.databaseConnection.createStatement();
                try {
                    ResultSet resultSet2 = statement2.executeQuery(String.format("PRAGMA table_info(%s)", mappingTableName));
                    try {
                        while (resultSet2.next()) {
                            String name = resultSet2.getString("name");
                            if ("base_id".equals(name)) {
                                Assert.assertEquals((String)resultSet2.getString("type"), (String)"INTEGER", (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, "base_id type"));
                                Assert.assertEquals((int)resultSet2.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, "base_id notnull"));
                                Assert.assertEquals((int)resultSet2.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, "base_id pk"));
                                passFlag |= 1;
                                continue;
                            }
                            if (!"related_id".equals(name)) continue;
                            Assert.assertEquals((String)resultSet2.getString("type"), (String)"INTEGER", (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, "related_id type"));
                            Assert.assertEquals((int)resultSet2.getInt("notnull"), (int)1, (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, "related_id notnull"));
                            Assert.assertEquals((int)resultSet2.getInt("pk"), (int)0, (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, "related_id pk"));
                            passFlag |= 2;
                        }
                        Assert.assertTrue(((passFlag & 3) == 3 ? 1 : 0) != 0, (String)ErrorMessage.format("TableDefinitionInvalid", mappingTableName, String.format("missing column(s): code(%s)", passFlag)));
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        resultSet2.close();
                    }
                }
                finally {
                    if (statement2 == null) continue;
                    statement2.close();
                }
            }
            Assert.assertTrue((boolean)hasResults, (String)ErrorMessage.format("MissingRow", "gpkgext_relations"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 18-000: Requirement 10")
    public void udmtBaseIDs() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT base_table_name, base_primary_column, mapping_table_name FROM gpkgext_relations;");){
            while (resultSet.next()) {
                String baseTableName = resultSet.getString("base_table_name");
                String basePrimaryColumn = resultSet.getString("base_primary_column");
                String mappingTableName = resultSet.getString("mapping_table_name");
                Statement statement2 = this.databaseConnection.createStatement();
                try {
                    ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT mapping_id FROM (SELECT a.base_id AS mapping_id, b.%s AS base_id FROM %s a LEFT OUTER JOIN %s b ON a.base_id = b.%s) WHERE base_id IS NULL;", basePrimaryColumn, mappingTableName, baseTableName, basePrimaryColumn));
                    try {
                        if (!resultSet2.next()) continue;
                        Assert.fail((String)ErrorMessage.format("MissingReference", baseTableName, basePrimaryColumn, String.format("%s from the base_id column of %s", resultSet2.getInt("mapping_id"), mappingTableName)));
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        resultSet2.close();
                    }
                }
                finally {
                    if (statement2 == null) continue;
                    statement2.close();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(description="See OGC 18-000: Requirement 11")
    public void udmtRelatedIDs() throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT related_table_name, related_primary_column, mapping_table_name FROM gpkgext_relations;");){
            while (resultSet.next()) {
                String relatedTableName = resultSet.getString("related_table_name");
                String relatedPrimaryColumn = resultSet.getString("related_primary_column");
                String mappingTableName = resultSet.getString("mapping_table_name");
                Statement statement2 = this.databaseConnection.createStatement();
                try {
                    ResultSet resultSet2 = statement2.executeQuery(String.format("SELECT mapping_id FROM (SELECT a.related_id AS mapping_id, b.%s AS related_id FROM %s a LEFT OUTER JOIN %s b ON a.related_id = b.%s) WHERE related_id IS NULL;", relatedPrimaryColumn, mappingTableName, relatedTableName, relatedPrimaryColumn));
                    try {
                        if (!resultSet2.next()) continue;
                        Assert.fail((String)ErrorMessage.format("MissingReference", relatedTableName, relatedPrimaryColumn, String.format("%s from the related_id column of %s", resultSet2.getInt("mapping_id"), mappingTableName)));
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        resultSet2.close();
                    }
                }
                finally {
                    if (statement2 == null) continue;
                    statement2.close();
                }
            }
            return;
        }
    }
}

