/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.cat;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.cat.CodeListAdapter;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;
import org.opengis.util.ControlledVocabulary;

@XmlType(name="CodeList", propOrder={"codeList", "codeListValue", "codeSpace"})
public final class CodeListUID {
    public static final String METADATA_ROOT = "http://standards.iso.org/iso/19115/";
    public static final String METADATA_ROOT_LEGACY = "http://www.isotc211.org/2005/";
    public static final String CODELISTS_PATH = "resources/Codelist/cat/codelists.xml";
    public static final String CODELISTS_PATH_LEGACY = "resources/Codelist/gmxCodelists.xml";
    public static final String UOM_PATH = "resources/uom/gmxUom.xml";
    @XmlAttribute(required=true)
    public String codeList;
    @XmlAttribute(required=true)
    public String codeListValue;
    @XmlAttribute
    public String codeSpace;
    @XmlValue
    public String value;

    private static String schema(Context context, String identifier) {
        String path;
        String root;
        String prefix;
        if (Context.isFlagSet(context, 32)) {
            prefix = "gmd";
            root = METADATA_ROOT_LEGACY;
            path = CODELISTS_PATH_LEGACY;
        } else {
            prefix = "cat";
            root = METADATA_ROOT;
            path = CODELISTS_PATH;
        }
        return Context.schema(context, prefix, root).append(path).append('#').append(identifier).toString();
    }

    public CodeListUID() {
    }

    public CodeListUID(Context context, String codeList, String codeListValue, String codeSpace, String value) {
        this.codeList = CodeListUID.schema(context, codeList);
        this.codeListValue = codeListValue;
        this.codeSpace = codeSpace;
        this.value = value;
    }

    public CodeListUID(Context context, ControlledVocabulary code) {
        String classID = Types.getListName(code);
        String fieldID = Types.getCodeName(code);
        this.codeList = CodeListUID.schema(context, classID);
        Locale locale = context.getLocale();
        if (locale != null) {
            String key = classID + "." + fieldID;
            try {
                this.value = ResourceBundle.getBundle("org.opengis.metadata.CodeLists", locale, CodeList.class.getClassLoader()).getString(key);
            }
            catch (MissingResourceException e) {
                Context.warningOccured(context, CodeListAdapter.class, "marshal", e, false);
            }
        }
        if (this.value != null) {
            this.codeSpace = Context.converter(context).toLanguageCode(context, locale);
        } else {
            this.value = Types.getCodeLabel(code);
        }
        this.codeListValue = fieldID;
    }

    public String toString() {
        String id = this.codeListValue;
        if (id == null) {
            id = this.value;
        }
        return id;
    }
}

