/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.util.Date;

public final class TypeMapper {
    private static final TypeMapper[] TYPES = new TypeMapper[]{new TypeMapper(Boolean.class, 16, "BOOLEAN"), new TypeMapper(Date.class, 93, "TIMESTAMP"), new TypeMapper(Double.class, 8, "DOUBLE PRECISION"), new TypeMapper(Float.class, 7, "REAL"), new TypeMapper(Long.class, -5, "BIGINT"), new TypeMapper(Integer.class, 4, "INTEGER"), new TypeMapper(Short.class, 5, "SMALLINT"), new TypeMapper(Byte.class, -6, "SMALLINT"), new TypeMapper(Number.class, 3, "DECIMAL")};
    private final Class<?> classe;
    private final int type;
    private final String keyword;

    private TypeMapper(Class<?> classe, int type, String keyword) {
        this.classe = classe;
        this.type = type;
        this.keyword = keyword;
    }

    public static String keywordFor(Class<?> classe) {
        if (classe != null) {
            for (TypeMapper type : TYPES) {
                if (!type.classe.isAssignableFrom(classe)) continue;
                return type.keyword;
            }
        }
        return null;
    }

    public static Class<?> toJavaType(int type) {
        for (TypeMapper t : TYPES) {
            if (t.type != type) continue;
            return t.classe;
        }
        return null;
    }
}

