/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.Containers;
import org.opengis.feature.AttributeType;
import org.opengis.util.MemberName;
import org.opengis.util.RecordType;
import org.opengis.util.Type;

@XmlTransient
abstract class RecordDefinition {
    private transient Map<MemberName, Integer> fieldIndices;
    private transient MemberName[] fieldNames;
    private transient Class<?>[] valueClasses;
    private transient Class<?> baseValueClass;

    RecordDefinition() {
    }

    abstract RecordType getRecordType();

    final Type[] computeTransientFields(Map<? extends MemberName, ? extends Type> fieldTypes) {
        int size = fieldTypes.size();
        this.fieldNames = new MemberName[size];
        this.fieldIndices = new LinkedHashMap<MemberName, Integer>(Containers.hashMapCapacity(size));
        Type[] types = new Type[size];
        int i = 0;
        for (Map.Entry<? extends MemberName, ? extends Type> entry : fieldTypes.entrySet()) {
            MemberName name;
            Class c;
            Type type = entry.getValue();
            if (type instanceof AttributeType && (c = ((AttributeType)type).getValueClass()) != Object.class) {
                if (this.valueClasses == null) {
                    this.valueClasses = new Class[size];
                }
                this.valueClasses[i] = c;
                this.baseValueClass = Classes.findCommonClass(this.baseValueClass, c);
            }
            this.fieldNames[i] = name = entry.getKey();
            this.fieldIndices.put(name, i);
            types[i] = type;
            ++i;
        }
        this.fieldIndices = CollectionsExt.unmodifiableOrCopy(this.fieldIndices);
        this.baseValueClass = this.baseValueClass != null ? Numbers.wrapperToPrimitive(this.baseValueClass) : Object.class;
        return types;
    }

    final Class<?> baseValueClass() {
        return this.baseValueClass;
    }

    final Map<MemberName, Integer> fieldIndices() {
        return this.fieldIndices;
    }

    final int size() {
        return this.fieldNames != null ? this.fieldNames.length : 0;
    }

    final Integer indexOf(MemberName fieldName) {
        return this.fieldIndices.get(fieldName);
    }

    final MemberName getName(int index) {
        return this.fieldNames[index];
    }

    final Class<?> getValueClass(int index) {
        return this.valueClasses != null ? this.valueClasses[index] : null;
    }

    public String toString() {
        return this.toString("RecordType", null);
    }

    final String toString(String head, Object values) {
        String margin;
        int i;
        StringBuilder buffer = new StringBuilder(250);
        String lineSeparator = System.lineSeparator();
        String[] names = new String[this.size()];
        int width = 0;
        for (i = 0; i < names.length; ++i) {
            names[i] = this.fieldNames[i].toString();
            width = Math.max(width, names[i].length());
        }
        if (head == null) {
            width = 0;
            margin = "";
        } else {
            buffer.append(head).append("[\u201c").append(this.getRecordType().getTypeName()).append("\u201d] {").append(lineSeparator);
            margin = "    ";
        }
        for (i = 0; i < names.length; ++i) {
            Object value;
            String name = names[i];
            buffer.append(margin).append(name);
            Object object = value = values != null ? Array.get(values, i) : this.fieldNames[i].getAttributeType();
            if (value != null) {
                buffer.append(CharSequences.spaces(width - name.length())).append(" : ").append(value);
            }
            buffer.append(lineSeparator);
        }
        if (head != null) {
            buffer.append('}').append(lineSeparator);
        }
        return buffer.toString();
    }

    static final class Adapter
    extends RecordDefinition
    implements Serializable {
        private static final long serialVersionUID = 3739362257927222288L;
        private final RecordType recordType;

        Adapter(RecordType recordType) {
            this.recordType = recordType;
            this.computeTransientFields(recordType.getFieldTypes());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.computeTransientFields(this.recordType.getFieldTypes());
        }

        @Override
        RecordType getRecordType() {
            return this.recordType;
        }
    }
}

