/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.GeodeticCalculator;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.cite.geomatics.gml.CurveCoordinateListFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeodesyUtils {
    private static final Logger LOGR = Logger.getLogger(GeodesyUtils.class.getPackage().getName());
    public static final String EPSG_4326 = "urn:ogc:def:crs:EPSG::4326";
    public static final String OGC_CRS84 = "urn:ogc:def:crs:OGC:1.3:CRS84";

    public static ImmutableEnvelope getDomainOfValidity(String crsRef) throws FactoryException {
        Object crs = null;
        crs = crsRef.equals(OGC_CRS84) ? CommonCRS.defaultGeographic() : CRS.forCode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(crsRef));
        Envelope areaOfUse = CRS.getDomainOfValidity((CoordinateReferenceSystem)crs);
        return new ImmutableEnvelope(areaOfUse);
    }

    public static String getCRSIdentifier(CoordinateReferenceSystem crs) {
        Set identifiers = crs.getIdentifiers();
        if (identifiers.isEmpty()) {
            if (crs.getName().getCode().startsWith("WGS84")) {
                return OGC_CRS84;
            }
            return "";
        }
        StringBuilder crsId = new StringBuilder("urn:ogc:def:crs:");
        Identifier id = (Identifier)identifiers.iterator().next();
        crsId.append(id.getCodeSpace()).append(":");
        if (!id.getCodeSpace().equalsIgnoreCase("EPSG")) {
            crsId.append(id.getVersion());
        }
        crsId.append(':');
        crsId.append(id.getCode());
        return crsId.toString();
    }

    public static DirectPosition calculateDestination(Position startingPos, double azimuth, double distance) {
        CoordinateReferenceSystem crs = startingPos.getDirectPosition().getCoordinateReferenceSystem();
        GeodeticCalculator calculator = GeodeticCalculator.create((CoordinateReferenceSystem)crs);
        DirectPosition destPos = null;
        if (azimuth > 180.0) {
            azimuth -= 360.0;
        } else if (azimuth < -180.0) {
            azimuth += 360.0;
        }
        try {
            calculator.setStartPoint(startingPos);
            calculator.setStartingAzimuth(azimuth);
            calculator.setGeodesicDistance(distance);
            destPos = calculator.getEndPoint();
        }
        catch (IllegalArgumentException te) {
            LOGR.fine(te.getMessage());
        }
        return destPos;
    }

    public static Coordinate[] transformRingToRightHandedCS(AbstractRing gmlRing) {
        MathTransform crsTransform;
        String srsName = gmlRing.getSrsName();
        if (null == srsName || srsName.isEmpty()) {
            return null;
        }
        CurveCoordinateListFactory curveCoordFactory = new CurveCoordinateListFactory();
        List<Coordinate> curveCoords = curveCoordFactory.createCoordinateList((AbstractGeometry)gmlRing);
        try {
            CoordinateReferenceSystem sourceCRS = CRS.forCode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(srsName));
            CoordinateReferenceSystem targetCRS = CRS.forCode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(srsName));
            targetCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)targetCRS).forConvention(AxesConvention.RIGHT_HANDED);
            crsTransform = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null).getMathTransform();
        }
        catch (FactoryException fx) {
            throw new RuntimeException("Failed to create coordinate transformer.", fx);
        }
        for (Coordinate coord : curveCoords) {
            try {
                JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)crsTransform);
            }
            catch (TransformException tx) {
                throw new RuntimeException("Failed to transform coordinate: " + coord, tx);
            }
        }
        GeodesyUtils.removeConsecutiveDuplicates(curveCoords, 1.0);
        return curveCoords.toArray(new Coordinate[curveCoords.size()]);
    }

    public static Coordinate[] transformRingToRightHandedCSKeepAllCoords(AbstractRing gmlRing) {
        MathTransform crsTransform;
        String srsName = gmlRing.getSrsName();
        if (null == srsName || srsName.isEmpty()) {
            return null;
        }
        CurveCoordinateListFactory curveCoordFactory = new CurveCoordinateListFactory();
        List<Coordinate> curveCoords = curveCoordFactory.createCoordinateList((AbstractGeometry)gmlRing);
        try {
            CoordinateReferenceSystem sourceCRS = CRS.forCode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(srsName));
            CoordinateReferenceSystem targetCRS = CRS.forCode((String)GeodesyUtils.getAbbreviatedCRSIdentifier(srsName));
            targetCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)targetCRS).forConvention(AxesConvention.RIGHT_HANDED);
            crsTransform = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null).getMathTransform();
        }
        catch (FactoryException fx) {
            throw new RuntimeException("Failed to create coordinate transformer.", fx);
        }
        for (Coordinate coord : curveCoords) {
            try {
                JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)crsTransform);
            }
            catch (TransformException tx) {
                throw new RuntimeException("Failed to transform coordinate: " + coord, tx);
            }
        }
        return curveCoords.toArray(new Coordinate[curveCoords.size()]);
    }

    public static String getAbbreviatedCRSIdentifier(String srsName) {
        String separator;
        StringBuilder crsId = new StringBuilder();
        int crsIndex = srsName.indexOf("crs");
        if (srsName.startsWith("http://www.opengis.net")) {
            separator = "/";
        } else if (srsName.startsWith("urn:ogc")) {
            separator = ":";
        } else {
            throw new IllegalArgumentException("Invalid CRS reference (see OGC 09-048r3): " + srsName);
        }
        String[] parts = srsName.substring(crsIndex + 4).split(separator);
        if (parts.length == 3) {
            crsId.append(parts[0]).append(':').append(parts[2]);
        }
        return crsId.toString();
    }

    public static String convertSRSNameToURN(String srsName) {
        if (!srsName.startsWith("http")) {
            return srsName;
        }
        StringBuilder urn = new StringBuilder("urn:ogc:def:crs:");
        String[] srsNameParts = srsName.split("/");
        int numParts = srsNameParts.length;
        urn.append(srsNameParts[numParts - 3]).append(':');
        String ver = srsNameParts[numParts - 2];
        if (!ver.isEmpty() && !ver.equals("0")) {
            urn.append(ver);
        }
        urn.append(':').append(srsNameParts[numParts - 1]);
        return urn.toString();
    }

    public static void removeConsecutiveDuplicates(List<Coordinate> coordList, double tolerancePPM) {
        if (coordList.size() < 2) {
            return;
        }
        double tolerance = tolerancePPM * 1.0E-6;
        ListIterator<Coordinate> itr = coordList.listIterator();
        Coordinate coord = itr.next();
        while (itr.hasNext()) {
            Coordinate nextCoord = itr.next();
            double xDelta = Math.abs(nextCoord.x / coord.x - 1.0);
            double yDelta = Math.abs(nextCoord.y / coord.y - 1.0);
            if (xDelta <= tolerance && yDelta <= tolerance) {
                if (!itr.hasNext()) {
                    coordList.remove(coordList.size() - 2);
                    break;
                }
                itr.remove();
                continue;
            }
            coord = nextCoord;
        }
    }
}

