/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.NamedIdentifier;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

@XmlType(name="CodeType")
public final class Code {
    @XmlValue
    String code;
    @XmlAttribute
    String codeSpace;

    Code() {
    }

    Code(Identifier identifier) {
        this.code = identifier.getCode();
        this.codeSpace = identifier.getCodeSpace();
        String version = identifier.getVersion();
        if (version != null) {
            StringBuilder buffer = new StringBuilder();
            if (this.codeSpace != null) {
                buffer.append(this.codeSpace);
            }
            this.codeSpace = buffer.append(':').append(version).toString();
        }
    }

    public Identifier getIdentifier() {
        String c = this.code;
        if (c == null) {
            return null;
        }
        Citation authority = null;
        String version = null;
        String cs = this.codeSpace;
        DefinitionURI parsed = DefinitionURI.parse(c);
        if (parsed != null && parsed.code != null) {
            authority = Identifiers.isEPSG(cs, parsed.authority) ? Citations.EPSG : Citations.fromName(cs);
            cs = parsed.authority;
            version = parsed.version;
            c = parsed.code;
        } else if (cs != null) {
            int s = cs.lastIndexOf(58);
            if (s >= 0) {
                version = cs.substring(s + 1);
                cs = cs.substring(0, s);
            }
            authority = Citations.fromName(cs);
        }
        return new NamedIdentifier(authority, cs, (CharSequence)c, version, null);
    }

    public static Code forIdentifiedObject(Class<?> type, Iterable<? extends Identifier> identifiers) {
        if (identifiers != null) {
            boolean isHTTP = false;
            boolean isEPSG = false;
            Identifier fallback = null;
            for (Identifier identifier : identifiers) {
                String code = identifier.getCode();
                if (code == null) continue;
                if (code.regionMatches(true, 0, "urn:", 0, 4)) {
                    return new Code(identifier);
                }
                if (isHTTP) continue;
                isHTTP = code.regionMatches(true, 0, "http:", 0, 5);
                if (isHTTP) {
                    fallback = identifier;
                    continue;
                }
                if (isEPSG || !(isEPSG = "EPSG".equalsIgnoreCase(identifier.getCodeSpace())) && fallback != null) continue;
                fallback = identifier;
            }
            if (fallback != null) {
                String urn;
                if (!isHTTP && (urn = NameMeaning.toURN(type, fallback.getCodeSpace(), fallback.getVersion(), fallback.getCode())) != null) {
                    Code code = new Code();
                    Citation authority = fallback.getAuthority();
                    if (isEPSG) {
                        code.codeSpace = "IOGP";
                        if (authority != null) {
                            for (Identifier id : authority.getIdentifiers()) {
                                String cs;
                                if (!"EPSG".equalsIgnoreCase(id.getCode()) || (cs = id.getCodeSpace()) == null) continue;
                                code.codeSpace = cs;
                                break;
                            }
                        }
                    } else {
                        code.codeSpace = Citations.toCodeSpace(authority);
                    }
                    code.code = urn;
                    return code;
                }
                return new Code(fallback);
            }
        }
        return null;
    }
}

