/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.util.CodeList;

final class DirectionAlongMeridian
extends FormattableObject
implements Comparable<DirectionAlongMeridian> {
    private static final Pattern EPSG = Pattern.compile("(\\p{Graph}+)\\s+along\\s+([\\-\\p{Digit}\\.]+)(?:\\s+deg|\\s*\u00b0)\\s*(\\p{Graph}+)?", 2);
    private static final AxisDirection[] NORTH_SOUTH = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.SOUTH};
    private static final AxisDirection[] EAST_WEST = new AxisDirection[]{AxisDirection.EAST, AxisDirection.WEST};
    private transient AxisDirection direction;
    public final AxisDirection baseDirection;
    public final double meridian;

    DirectionAlongMeridian(AxisDirection baseDirection, double meridian) {
        ArgumentChecks.ensureNonNull("baseDirection", baseDirection);
        if (!AxisDirection.NORTH.equals(baseDirection) && !AxisDirection.SOUTH.equals(baseDirection)) {
            throw new IllegalArgumentException(Errors.format((short)45, "baseDirection", baseDirection));
        }
        ArgumentChecks.ensureBetween("meridian", -180.0, 180.0, meridian);
        this.baseDirection = baseDirection;
        this.meridian = meridian;
    }

    public static boolean matches(String direction) {
        return direction != null && EPSG.matcher(direction).matches();
    }

    public static DirectionAlongMeridian parse(AxisDirection direction) {
        DirectionAlongMeridian candidate;
        try {
            candidate = DirectionAlongMeridian.parse(direction.name());
        }
        catch (IllegalArgumentException e) {
            Logging.recoverableException(AbstractCS.LOGGER, DirectionAlongMeridian.class, "parse", e);
            return null;
        }
        if (candidate != null) {
            candidate.direction = direction;
        }
        return candidate;
    }

    public static DirectionAlongMeridian parse(String name) throws IllegalArgumentException {
        Matcher m = EPSG.matcher(name);
        if (!m.matches()) {
            return null;
        }
        AxisDirection baseDirection = AxisDirections.find(m.group(1), NORTH_SOUTH);
        if (baseDirection == null) {
            return null;
        }
        double meridian = Double.parseDouble(m.group(2));
        String group = m.group(3);
        if (group != null) {
            AxisDirection sgn = AxisDirections.find(group, EAST_WEST);
            if (sgn == null) {
                return null;
            }
            if (sgn != AxisDirections.absolute(sgn)) {
                meridian = -meridian;
            }
        }
        return new DirectionAlongMeridian(baseDirection, meridian);
    }

    public AxisDirection getDirection() {
        if (this.direction == null) {
            String name = this.toString();
            this.direction = AxisDirections.valueOf(name);
            if (this.direction == null) {
                this.direction = Types.forCodeName(AxisDirection.class, name, true);
            }
        }
        return this.direction;
    }

    public double angle(DirectionAlongMeridian other) {
        if (!this.baseDirection.equals(other.baseDirection)) {
            return Double.NaN;
        }
        double angle = Longitude.normalize(this.meridian - other.meridian);
        if (AxisDirections.isOpposite(this.baseDirection)) {
            angle = -angle;
        }
        return angle;
    }

    @Override
    public int compareTo(DirectionAlongMeridian that) {
        int c = this.baseDirection.compareTo((CodeList)that.baseDirection);
        if (c != 0) {
            return c;
        }
        double angle = this.angle(that);
        if (angle < 0.0) {
            return 1;
        }
        if (angle > 0.0) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectionAlongMeridian) {
            DirectionAlongMeridian that = (DirectionAlongMeridian)object;
            return this.baseDirection.equals(that.baseDirection) && Numerics.equals(this.meridian, that.meridian);
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.meridian) + this.baseDirection.hashCode();
    }

    @Override
    public String toString() {
        int c;
        String name = this.baseDirection.name();
        int length = name.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = name.codePointAt(i);
            buffer.appendCodePoint(i == 0 ? Character.toUpperCase(c) : Character.toLowerCase(c));
        }
        buffer.append(" along ");
        double md = Math.abs(this.meridian);
        int mi = (int)md;
        if (md == (double)mi) {
            buffer.append(mi);
        } else {
            buffer.append(md);
        }
        buffer.append('\u00b0');
        if (md != 0.0 && md != 180.0) {
            buffer.append(this.meridian < 0.0 ? (char)'W' : 'E');
        }
        name = buffer.toString();
        assert (DirectionAlongMeridian.matches(name)) : name;
        return name;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.meridian);
        formatter.append(Units.DEGREE);
        return "Meridian";
    }
}

