/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;

final class Normalizer
implements Comparable<Normalizer> {
    private static final String[] EXCLUDES = new String[]{"identifiers"};
    private static final int SHIFT = 3;
    private static final Map<AxisDirection, Integer> ORDER = new HashMap<AxisDirection, Integer>();
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;
    private final int unitOrder;

    private Normalizer(CoordinateSystemAxis axis, int angularUnitOrder) {
        this.axis = axis;
        this.unitOrder = Units.isAngular(axis.getUnit()) ? angularUnitOrder : 0;
        AxisDirection dir = axis.getDirection();
        this.meridian = AxisDirections.isUserDefined(dir) ? DirectionAlongMeridian.parse(dir) : null;
    }

    private static int order(AxisDirection dir) {
        Integer p = ORDER.get(dir);
        return p != null ? p : dir.ordinal() << 3;
    }

    @Override
    public int compareTo(Normalizer that) {
        int d = this.unitOrder - that.unitOrder;
        if (d == 0) {
            AxisDirection d1 = this.axis.getDirection();
            AxisDirection d2 = that.axis.getDirection();
            d = AxisDirections.angleForCompass(d2, d1);
            if (d == Integer.MIN_VALUE && (d = AxisDirections.angleForVehicle(d2, d1)) == Integer.MIN_VALUE) {
                d = this.meridian != null ? (that.meridian != null ? this.meridian.compareTo(that.meridian) : -1) : (that.meridian != null ? 1 : Normalizer.order(d1) - Normalizer.order(d2));
            }
        }
        return d;
    }

    static boolean sort(CoordinateSystemAxis[] axes, int angularUnitOrder) {
        Object[] wrappers = new Normalizer[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            wrappers[i] = new Normalizer(axes[i], angularUnitOrder);
        }
        Arrays.sort(wrappers);
        boolean changed = false;
        for (int i = 0; i < axes.length; ++i) {
            CoordinateSystemAxis a = ((Normalizer)wrappers[i]).axis;
            changed |= axes[i] != a;
            axes[i] = a;
        }
        return changed;
    }

    static CoordinateSystemAxis normalize(CoordinateSystemAxis axis, AxisFilter changes) {
        Unit unit = axis.getUnit();
        AxisDirection direction = axis.getDirection();
        Unit<?> newUnit = changes.getUnitReplacement(axis, unit);
        AxisDirection newDir = changes.getDirectionReplacement(axis, direction);
        boolean sameDirection = newDir.equals(direction);
        if (sameDirection && newUnit.equals((Object)unit)) {
            return axis;
        }
        String abbreviation = axis.getAbbreviation();
        String newAbbr = sameDirection ? abbreviation : AxisDirections.suggestAbbreviation(axis.getName().getCode(), newDir, newUnit);
        HashMap<String, Object> properties = new HashMap<String, Object>(8);
        if (newAbbr.equals(abbreviation)) {
            properties.putAll(IdentifiedObjects.getProperties((IdentifiedObject)axis, EXCLUDES));
        } else {
            properties.put("name", NilReferencingObject.UNNAMED);
        }
        if (sameDirection || newDir.equals(AxisDirections.opposite(direction))) {
            UnitConverter c;
            try {
                c = unit.getConverterToAny(newUnit);
            }
            catch (IncommensurableException e) {
                throw new IllegalStateException(Resources.format((short)26, "axis", unit), e);
            }
            double minimum = c.convert(axis.getMinimumValue());
            double maximum = c.convert(axis.getMaximumValue());
            if (!sameDirection) {
                double tmp = minimum;
                minimum = -maximum;
                maximum = -tmp;
            }
            properties.put("minimumValue", minimum);
            properties.put("maximumValue", maximum);
            properties.put("rangeMeaning", axis.getRangeMeaning());
        }
        return new DefaultCoordinateSystemAxis(properties, newAbbr, newDir, newUnit);
    }

    static AbstractCS normalize(CoordinateSystem cs, AxisFilter changes, boolean reorder) {
        int i;
        int dimension = cs.getDimension();
        CoordinateSystemAxis[] oldAxes = new CoordinateSystemAxis[dimension];
        int n = 0;
        for (int i2 = 0; i2 < dimension; ++i2) {
            CoordinateSystemAxis axis = cs.getAxis(i2);
            if (changes != null && !changes.accept(axis)) continue;
            oldAxes[n++] = axis;
        }
        Object[] newAxes = Arrays.copyOf(oldAxes, n);
        boolean changed = false;
        if (changes != null) {
            for (i = 0; i < n; ++i) {
                newAxes[i] = Normalizer.normalize(newAxes[i], changes);
                changed |= newAxes[i] != oldAxes[i];
            }
        }
        if (reorder) {
            int angularUnitOrder = 0;
            if (cs instanceof EllipsoidalCS || cs instanceof SphericalCS) {
                angularUnitOrder = -1;
            } else if (cs instanceof CylindricalCS || cs instanceof PolarCS) {
                angularUnitOrder = 1;
            }
            changed |= Normalizer.sort((CoordinateSystemAxis[])newAxes, angularUnitOrder);
            if (angularUnitOrder == 1) {
                if (newAxes.length == 3 && Normalizer.isLengthAndAngle((CoordinateSystemAxis[])newAxes, 1)) {
                    ArraysExt.swap(newAxes, 1, 2);
                }
                if (AxisDirections.CLOCKWISE.equals(newAxes[1].getDirection()) && Normalizer.isLengthAndAngle((CoordinateSystemAxis[])newAxes, 0)) {
                    ArraysExt.swap(newAxes, 0, 1);
                }
            }
        }
        if (!changed && n == dimension) {
            return null;
        }
        for (i = 0; i < n; ++i) {
            CoordinateSystemAxis axis = newAxes[i];
            if (axis.getIdentifiers().isEmpty()) continue;
            for (int j = 0; j < n; ++j) {
                if (j == i || axis != oldAxes[j]) continue;
                newAxes[i] = Normalizer.forRange(axis, axis.getMinimumValue(), axis.getMaximumValue());
            }
        }
        AbstractCS impl = Normalizer.castOrCopy(cs);
        StringBuilder buffer = (StringBuilder)CharSequences.camelCaseToSentence(impl.getInterface().getSimpleName());
        return impl.createForAxes(Map.of("name", AxisDirections.appendTo(buffer, (CoordinateSystemAxis[])newAxes)), (CoordinateSystemAxis[])newAxes);
    }

    private static boolean isLengthAndAngle(CoordinateSystemAxis[] axes, int p) {
        return Units.isLinear(axes[p].getUnit()) && Units.isAngular(axes[p + 1].getUnit());
    }

    private static AbstractCS shiftAxisRange(CoordinateSystem cs) {
        boolean changed = false;
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[cs.getDimension()];
        for (int i = 0; i < axes.length; ++i) {
            double min;
            CoordinateSystemAxis axis = cs.getAxis(i);
            if (RangeMeaning.WRAPAROUND.equals(axis.getRangeMeaning()) && (min = axis.getMinimumValue()) < 0.0) {
                double max = axis.getMaximumValue();
                double offset = (max - min) / 2.0;
                if ((min -= (offset *= Math.floor(min / offset + 1.0E-13))) < (max -= offset)) {
                    axis = Normalizer.forRange(axis, min, max);
                    changed = true;
                }
            }
            axes[i] = axis;
        }
        if (!changed) {
            return null;
        }
        return Normalizer.castOrCopy(cs).createForAxes(IdentifiedObjects.getProperties((IdentifiedObject)cs, EXCLUDES), axes);
    }

    private static CoordinateSystemAxis forRange(CoordinateSystemAxis axis, double min, double max) {
        HashMap<String, Object> properties = new HashMap<String, Object>(8);
        properties.putAll(IdentifiedObjects.getProperties((IdentifiedObject)axis, EXCLUDES));
        properties.put("minimumValue", min);
        properties.put("maximumValue", max);
        properties.put("rangeMeaning", axis.getRangeMeaning());
        return new DefaultCoordinateSystemAxis(properties, axis.getAbbreviation(), axis.getDirection(), axis.getUnit());
    }

    private static AbstractCS castOrCopy(CoordinateSystem cs) {
        return cs instanceof AbstractCS ? (AbstractCS)cs : AbstractCS.castOrCopy(cs);
    }

    static AbstractCS forConvention(CoordinateSystem cs, AxesConvention convention) {
        switch (convention) {
            case NORMALIZED: 
            case DISPLAY_ORIENTED: {
                return Normalizer.normalize(cs, convention, true);
            }
            case RIGHT_HANDED: {
                return Normalizer.normalize(cs, null, true);
            }
            case POSITIVE_RANGE: {
                return Normalizer.shiftAxisRange(cs);
            }
        }
        throw new AssertionError(convention);
    }

    static {
        int code = AxisDirection.NORTH.ordinal() + 15 << 3;
        for (AxisDirection d : new AxisDirection[]{AxisDirections.FORWARD, AxisDirections.STARBOARD, AxisDirections.COUNTER_CLOCKWISE, AxisDirections.CLOCKWISE, AxisDirections.AWAY_FROM}) {
            ORDER.put(d, ++code);
        }
    }
}

