/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.SignReversalComment;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

@XmlTransient
final class InverseOperationMethod
extends DefaultOperationMethod {
    private static final long serialVersionUID = 6395008927817202180L;
    private final OperationMethod inverse;

    private InverseOperationMethod(Map<String, ?> properties, OperationMethod method) {
        super(properties, method.getTargetDimensions(), method.getSourceDimensions(), method.getParameters());
        this.inverse = method;
    }

    static OperationMethod create(OperationMethod method, DefaultCoordinateOperationFactory factorySIS) throws FactoryException {
        GeneralParameterDescriptor descriptor;
        AbstractProvider inverse;
        if (method instanceof InverseOperationMethod) {
            return ((InverseOperationMethod)method).inverse;
        }
        if (!(method instanceof AbstractProvider)) {
            try {
                method = factorySIS.getOperationMethod(method.getName().getCode());
            }
            catch (NoSuchIdentifierException e) {
                CoordinateOperationRegistry.recoverableException("inverse", (Exception)((Object)e));
            }
        }
        if (method instanceof AbstractProvider && (inverse = ((AbstractProvider)method).inverse()) != null) {
            return inverse;
        }
        boolean useSameParameters = false;
        Iterator iterator = method.getParameters().descriptors().iterator();
        while (iterator.hasNext() && (useSameParameters = (descriptor = (GeneralParameterDescriptor)iterator.next()).getRemarks() instanceof SignReversalComment)) {
        }
        if (useSameParameters) {
            return method;
        }
        Identifier name = method.getName();
        name = new ImmutableIdentifier(null, null, "Inverse of " + name.getCode());
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        properties.put("name", name);
        properties.put("formula", method.getFormula());
        properties.put("remarks", method.getRemarks());
        if (method instanceof Deprecable) {
            properties.put("deprecated", ((Deprecable)method).isDeprecated());
        }
        return new InverseOperationMethod(properties, method);
    }

    static void properties(SingleOperation source, Map<String, Object> target) {
        target.put("domainOfValidity", source.getDomainOfValidity());
        Collection accuracy = source.getCoordinateOperationAccuracy();
        if (!Containers.isNullOrEmpty(accuracy)) {
            target.put("coordinateOperationAccuracy", accuracy.toArray(PositionalAccuracy[]::new));
        }
        ParameterValueGroup parameters = source.getParameterValues();
        ParameterValueGroup copy = parameters.getDescriptor().createValue();
        for (GeneralParameterValue gp : parameters.values()) {
            ParameterDescriptor descriptor;
            InternationalString remarks;
            ParameterValue src;
            Object value;
            if (gp instanceof ParameterValue && (value = (src = (ParameterValue)gp).getValue()) instanceof Number && (remarks = (descriptor = src.getDescriptor()).getRemarks()) != SignReversalComment.SAME) {
                if (remarks != SignReversalComment.OPPOSITE) {
                    return;
                }
                ParameterValue tgt = copy.parameter(descriptor.getName().getCode());
                Unit unit = src.getUnit();
                if (unit != null) {
                    tgt.setValue(-src.doubleValue(), unit);
                    continue;
                }
                if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                    tgt.setValue(-src.intValue());
                    continue;
                }
                tgt.setValue(-src.doubleValue());
                continue;
            }
            copy.values().add(gp);
        }
        target.put("parameters", copy);
    }
}

