/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.CartesianToPolar;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class PolarToCartesian
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 8026743046661603837L;
    static final PolarToCartesian INSTANCE = new PolarToCartesian();

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private PolarToCartesian() {
        super("Polar to Cartesian", "Cylindrical to Cartesian", 2);
        this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).convertBefore(1, DoubleDouble.DEGREES_TO_RADIANS, null);
    }

    @Override
    public MathTransform inverse() {
        return CartesianToPolar.INSTANCE;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        double r = srcPts[srcOff];
        double \u03b8 = srcPts[srcOff + 1];
        double cos\u03b8 = Math.cos(\u03b8);
        double sin\u03b8 = Math.sin(\u03b8);
        if (dstPts != null) {
            dstPts[dstOff] = r * cos\u03b8;
            dstPts[dstOff + 1] = r * sin\u03b8;
        }
        if (!derivate) {
            return null;
        }
        return new Matrix2(cos\u03b8, -r * sin\u03b8, sin\u03b8, r * cos\u03b8);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 2, dstOff, 2, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += 2 * (numPts - 1);
                    dstOff += 2 * (numPts - 1);
                    srcInc = -4;
                    dstInc = -4;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 2);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double r = srcPts[srcOff++];
            double \u03b8 = srcPts[srcOff++];
            dstPts[dstOff++] = r * Math.cos(\u03b8);
            dstPts[dstOff++] = r * Math.sin(\u03b8);
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }
}

