/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sis.coverage.grid.GridExtent;

public class HyperCubeIterator
implements Iterator<HyperCube> {
    private final int[] maxSize;
    private final int nbDim;
    private final long[] corner;
    private final long[] mins;
    private final long[] maxs;
    private HyperCube next = null;

    public HyperCubeIterator(long[] mins, long[] maxs, int[] maxSize) {
        this.maxSize = maxSize;
        this.nbDim = mins.length;
        this.mins = mins;
        this.maxs = maxs;
        this.corner = new long[this.nbDim];
        System.arraycopy(mins, 0, this.corner, 0, this.nbDim);
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.next != null;
    }

    @Override
    public HyperCube next() {
        this.findNext();
        if (this.next == null) {
            throw new NoSuchElementException("No more elements.");
        }
        HyperCube t = this.next;
        this.next = null;
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void findNext() {
        if (this.next != null) {
            return;
        }
        if (this.corner[this.nbDim - 1] >= this.maxs[this.nbDim - 1]) {
            return;
        }
        long[] lower = new long[this.nbDim];
        long[] upper = new long[this.nbDim];
        for (int i = 0; i < this.nbDim; ++i) {
            lower[i] = this.corner[i];
            upper[i] = this.corner[i] + (long)this.maxSize[i];
            if (upper[i] < this.maxs[i]) continue;
            upper[i] = this.maxs[i];
        }
        for (int k = 0; k < this.nbDim; ++k) {
            int n = k;
            this.corner[n] = this.corner[n] + (long)this.maxSize[k];
            if (k >= this.nbDim - 1 || this.corner[k] < this.maxs[k]) break;
            this.corner[k] = this.mins[k];
        }
        this.next = new HyperCube(lower, upper);
    }

    public static HyperCubeIterator create(GridExtent gridEnv, int[] maxSize) {
        int nbDim = gridEnv.getDimension();
        long[] mins = new long[nbDim];
        long[] maxs = new long[nbDim];
        for (int i = 0; i < nbDim; ++i) {
            mins[i] = gridEnv.getLow(i);
            maxs[i] = gridEnv.getHigh(i) + 1L;
        }
        return new HyperCubeIterator(mins, maxs, maxSize);
    }

    public static class HyperCube {
        private final long[] lower;
        private final long[] upper;

        public HyperCube(long[] lower, long[] upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public long[] getLower() {
            return this.lower;
        }

        public long[] getUpper() {
            return this.upper;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HyperCube other = (HyperCube)obj;
            if (!Arrays.equals(this.lower, other.lower)) {
                return false;
            }
            return Arrays.equals(this.upper, other.upper);
        }

        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + Arrays.hashCode(this.lower);
            hash = 61 * hash + Arrays.hashCode(this.upper);
            return hash;
        }

        public String toString() {
            return "HyperCube " + Arrays.toString(this.lower) + " " + Arrays.toString(this.upper);
        }
    }
}

