/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.transform;

import java.util.Arrays;
import org.geotoolkit.geometry.jts.transform.CoordinateSequenceTransformer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoordinateSequenceMathTransformer
implements CoordinateSequenceTransformer {
    static final CoordinateSequenceFactory DEFAULT_CS_FACTORY = CoordinateArraySequenceFactory.instance();
    private final transient double[] buffer = new double[96];
    private final CoordinateSequenceFactory csf;
    private MathTransform transform = null;

    public CoordinateSequenceMathTransformer(MathTransform transform) {
        this(null, transform);
    }

    public CoordinateSequenceMathTransformer(CoordinateSequenceFactory csf, MathTransform transform) {
        this.csf = csf == null ? DEFAULT_CS_FACTORY : csf;
        this.transform = transform;
    }

    public synchronized void setTransform(MathTransform transform) {
        this.transform = transform;
    }

    public synchronized MathTransform getTransform() {
        return this.transform;
    }

    @Override
    public synchronized CoordinateSequence transform(CoordinateSequence sequence, int minpoints) throws TransformException {
        int sourceDim = this.transform.getSourceDimensions();
        int targetDim = this.transform.getTargetDimensions();
        int size = sequence.size();
        Coordinate[] tcs = new Coordinate[size];
        int bufferCapacity = this.buffer.length / Math.max(sourceDim, targetDim);
        int remainingBeforeFlush = Math.min(bufferCapacity, size);
        int ib = 0;
        int it = 0;
        for (int i = 0; i < size; ++i) {
            switch (sourceDim) {
                default: {
                    Arrays.fill(this.buffer, ib + 3, ib + sourceDim, Double.NaN);
                }
                case 3: {
                    this.buffer[ib + 2] = sequence.getOrdinate(i, 2);
                }
                case 2: {
                    this.buffer[ib + 1] = sequence.getY(i);
                }
                case 1: {
                    this.buffer[ib] = sequence.getX(i);
                }
                case 0: 
            }
            ib += sourceDim;
            if (--remainingBeforeFlush != 0) continue;
            assert (ib % sourceDim == 0);
            int n = ib / sourceDim;
            this.transform.transform(this.buffer, 0, this.buffer, 0, n);
            ib = 0;
            block13: for (int j = 0; j < n; ++j) {
                switch (targetDim) {
                    default: {
                        throw new MismatchedDimensionException();
                    }
                    case 3: {
                        tcs[it++] = new Coordinate(this.buffer[ib++], this.buffer[ib++], this.buffer[ib++]);
                        continue block13;
                    }
                    case 2: {
                        tcs[it++] = new Coordinate(this.buffer[ib++], this.buffer[ib++]);
                        continue block13;
                    }
                    case 1: {
                        tcs[it++] = new Coordinate(this.buffer[ib++], Double.NaN);
                        continue block13;
                    }
                    case 0: {
                        tcs[it++] = new Coordinate(Double.NaN, Double.NaN);
                    }
                }
            }
            assert (ib == n * targetDim);
            ib = 0;
            remainingBeforeFlush = Math.min(bufferCapacity, size - (i + 1));
        }
        assert (it == tcs.length) : tcs.length - it;
        return this.csf.create(tcs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CoordinateSequenceTransformer : Mathtransform : ");
        sb.append(this.transform);
        return sb.toString();
    }
}

