/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

public class Histogram {
    private final long[] buckets;
    private final double start;
    private final double end;
    private long sum = -1L;

    public Histogram(long[] buckets, double start, double end) {
        this.buckets = buckets;
        this.start = start;
        this.end = end;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public long[] getBuckets() {
        return this.buckets;
    }

    public long getSum() {
        if (this.sum != -1L) {
            return this.sum;
        }
        long s = 0L;
        for (long l : this.buckets) {
            s += l;
        }
        this.sum = s;
        return this.sum;
    }

    public double getBucketSize() {
        return (this.end - this.start) / (double)this.buckets.length;
    }

    public double[] getBucketRange(int index) {
        double span = this.getBucketSize();
        return new double[]{this.start + (double)index * span, this.start + (double)(index + 1) * span};
    }

    public double getValueAt(double ratio) {
        if (ratio <= 0.0) {
            return this.start;
        }
        if (ratio >= 1.0) {
            return this.end;
        }
        long sum = this.getSum();
        double remain = (double)sum * ratio;
        for (int i = 0; i < this.buckets.length; ++i) {
            if ((double)this.buckets[i] > remain) {
                double span = this.getBucketSize();
                double bucketStart = this.start + (double)i * span;
                double bucketEnd = this.start + (double)(i + 1) * span;
                ratio = 1.0 - ((double)this.buckets[i] - remain) / (double)this.buckets[i];
                return bucketStart + (bucketEnd - bucketStart) * ratio;
            }
            remain -= (double)this.buckets[i];
        }
        return this.end;
    }
}

