/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Mercator;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.nio.IOUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.transform.LinearInterpolator1D;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class ReferencingUtilities {
    public static final double EARTH_RADIUS = 6371007.0;

    private ReferencingUtilities() {
    }

    public static DirectPosition[] findWrapAround(CoordinateReferenceSystem crs) throws TransformException {
        ProjectedCRS projectedCRS;
        MathTransform trs;
        if (crs instanceof GeographicCRS) {
            EllipsoidalCS cs = ((GeographicCRS)crs).getCoordinateSystem();
            int n = cs.getDimension();
            for (int i = 0; i < n; ++i) {
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (!RangeMeaning.WRAPAROUND.equals(axis.getRangeMeaning())) continue;
                GeneralDirectPosition start = new GeneralDirectPosition(crs);
                start.setOrdinate(i, axis.getMinimumValue());
                DirectPosition2D end = new DirectPosition2D(crs);
                end.setOrdinate(i, axis.getMaximumValue());
                return new DirectPosition[]{start, end};
            }
        } else if (crs instanceof ProjectedCRS && ReferencingUtilities.isWrapAroundCompatible(trs = (projectedCRS = (ProjectedCRS)crs).getConversionFromBase().getMathTransform())) {
            GeographicCRS baseCrs = projectedCRS.getBaseCRS();
            DirectPosition[] info = ReferencingUtilities.findWrapAround((CoordinateReferenceSystem)baseCrs);
            info[0] = trs.transform(info[0], null);
            info[1] = trs.transform(info[1], null);
            return info;
        }
        return null;
    }

    private static boolean isWrapAroundCompatible(MathTransform trs) {
        for (MathTransform step : MathTransforms.getSteps((MathTransform)trs)) {
            if (step instanceof LinearTransform || step instanceof Mercator) continue;
            return false;
        }
        return true;
    }

    public static double[] convertResolution(Envelope srcEnvelope, double[] oldResolution, CoordinateReferenceSystem targetCrs, double ... newResolution) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"srcEnvelope", (Object)srcEnvelope);
        ArgumentChecks.ensureNonNull((String)"oldResolution", (Object)oldResolution);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)targetCrs);
        if (newResolution == null || newResolution.length == 0) {
            newResolution = new double[targetCrs.getCoordinateSystem().getDimension()];
            Arrays.fill(newResolution, 1.0);
        } else if (targetCrs.getCoordinateSystem().getDimension() != newResolution.length) {
            throw new MismatchedDimensionException("Destination resolution array length should be equals than target CRS dimension number.Destination resolution array length = " + newResolution.length + ", CRS dimension number = " + targetCrs.getCoordinateSystem().getDimension());
        }
        CoordinateReferenceSystem srcCRS = srcEnvelope.getCoordinateReferenceSystem();
        if (oldResolution.length != 2) {
            throw new IllegalArgumentException("Resolution array length should be equals to 2. Founded array length : " + oldResolution.length);
        }
        int targetMinOrdi = CRSUtilities.firstHorizontalAxis(targetCrs);
        if (Utilities.equalsIgnoreMetadata((Object)srcCRS, (Object)targetCrs)) {
            assert (targetMinOrdi + oldResolution.length <= newResolution.length) : "First horizontal index from target CRS + old resolution array length should be lesser than new resolution array length.";
            System.arraycopy(oldResolution, 0, newResolution, targetMinOrdi, oldResolution.length);
        } else {
            int srcMinOrdi = CRSUtilities.firstHorizontalAxis(srcCRS);
            CoordinateReferenceSystem srcCRS2D = CRSUtilities.getCRS2D(srcCRS);
            CoordinateReferenceSystem targetCRS2D = CRSUtilities.getCRS2D(targetCrs);
            GeneralDirectPosition center = new GeneralDirectPosition(srcCRS2D);
            center.setOrdinate(0, srcEnvelope.getMedian(srcMinOrdi));
            center.setOrdinate(1, srcEnvelope.getMedian(srcMinOrdi + 1));
            try {
                MathTransform trs = org.apache.sis.referencing.CRS.findOperation((CoordinateReferenceSystem)srcCRS2D, (CoordinateReferenceSystem)targetCRS2D, null).getMathTransform();
                Matrix derivative = trs.derivative((DirectPosition)center);
                double[] res2d = MatrixSIS.castOrCopy((Matrix)derivative).multiply(oldResolution);
                newResolution[0] = res2d[0];
                newResolution[1] = res2d[1];
            }
            catch (ProjectionException | FactoryException ex) {
                int displayWidth = (int)StrictMath.ceil(srcEnvelope.getSpan(srcMinOrdi) / oldResolution[0]);
                int displayHeight = (int)StrictMath.ceil(srcEnvelope.getSpan(srcMinOrdi + 1) / oldResolution[1]);
                GeneralEnvelope srcEnvelope2D = new GeneralEnvelope(srcCRS2D);
                srcEnvelope2D.setRange(0, srcEnvelope.getMinimum(srcMinOrdi), srcEnvelope.getMaximum(srcMinOrdi));
                srcEnvelope2D.setRange(1, srcEnvelope.getMinimum(srcMinOrdi + 1), srcEnvelope.getMaximum(srcMinOrdi + 1));
                Envelope targetEnvelope2D = Envelopes.transform((Envelope)srcEnvelope2D, (CoordinateReferenceSystem)targetCRS2D);
                newResolution[targetMinOrdi] = targetEnvelope2D.getSpan(0) / (double)displayWidth;
                newResolution[targetMinOrdi + 1] = targetEnvelope2D.getSpan(1) / (double)displayHeight;
            }
        }
        for (int i = 0; i < newResolution.length; ++i) {
            newResolution[i] = Math.abs(newResolution[i]);
            if (Double.isNaN(newResolution[i]) && (i == targetMinOrdi || i == targetMinOrdi + 1)) {
                newResolution[i] = newResolution[i == targetMinOrdi ? i + 1 : i - 1];
            }
            if (!Double.isNaN(newResolution[i])) continue;
            newResolution[i] = oldResolution[i];
        }
        return newResolution;
    }

    public static Envelope wrapNormalize(Envelope env, DirectPosition[] warp) {
        if (warp == null) {
            return env;
        }
        DirectPosition p0 = warp[0];
        DirectPosition p1 = warp[1];
        int n = p0.getDimension();
        for (int i = 0; i < n; ++i) {
            double maximum;
            double minimum = p0.getOrdinate(i);
            if (minimum == (maximum = p1.getOrdinate(i))) continue;
            double csSpan = maximum - minimum;
            double o1 = env.getMinimum(i);
            double o2 = env.getMaximum(i);
            GeneralEnvelope res = new GeneralEnvelope(env);
            if (Math.abs(o2 - o1) >= csSpan) {
                if (o1 != minimum || o2 != maximum) {
                    if (o1 % csSpan == 0.0 && o2 % csSpan == 0.0) {
                        res.setRange(i, 0.0, -0.0);
                    } else {
                        res.setRange(i, minimum, maximum);
                    }
                }
            } else if (o1 < minimum || o2 > maximum) {
                res.setRange(i, minimum, maximum);
            }
            return res;
        }
        return env;
    }

    public static Envelope transform(Envelope env, CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return Envelopes.transform((Envelope)env, (CoordinateReferenceSystem)targetCRS);
        }
        catch (TransformException transformException) {
            CoordinateReferenceSystem sourceCRS = env.getCoordinateReferenceSystem();
            GeneralEnvelope result = new GeneralEnvelope(targetCRS);
            List sourceParts = org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)sourceCRS);
            List targetParts = org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)targetCRS);
            int sourceAxeIndex = 0;
            for (CoordinateReferenceSystem sourcePart : sourceParts) {
                int sourcePartDimension = sourcePart.getCoordinateSystem().getDimension();
                int targetAxeIndex = 0;
                for (CoordinateReferenceSystem targetPart : targetParts) {
                    int targetPartDimension = targetPart.getCoordinateSystem().getDimension();
                    try {
                        MathTransform trs = org.apache.sis.referencing.CRS.findOperation((CoordinateReferenceSystem)sourcePart, (CoordinateReferenceSystem)targetPart, null).getMathTransform();
                        GeneralEnvelope partSource = new GeneralEnvelope(sourcePart);
                        for (int i = 0; i < sourcePartDimension; ++i) {
                            partSource.setRange(i, env.getMinimum(sourceAxeIndex + i), env.getMaximum(sourceAxeIndex + i));
                        }
                        GeneralEnvelope partResult = Envelopes.transform((MathTransform)trs, (Envelope)partSource);
                        for (int i = 0; i < targetPartDimension; ++i) {
                            result.setRange(targetAxeIndex + i, partResult.getMinimum(i), partResult.getMaximum(i));
                        }
                        break;
                    }
                    catch (FactoryException factoryException) {
                        targetAxeIndex += targetPartDimension;
                    }
                }
                sourceAxeIndex += sourcePartDimension;
            }
            return result;
        }
    }

    @Deprecated
    private static int[] findDimensionIndexes(CoordinateReferenceSystem crs) {
        CoordinateSystem cs = crs.getCoordinateSystem();
        assert (cs.getDimension() <= 4);
        int[] indexes = new int[4];
        int d = 0;
        for (SingleCRS crs2 : org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)crs)) {
            int dim = crs2.getCoordinateSystem().getDimension();
            if (crs2 instanceof GeographicCRS || crs2 instanceof ProjectedCRS) {
                for (int i = 0; i < dim; ++i) {
                    indexes[i] = d++;
                }
                continue;
            }
            if (crs2 instanceof VerticalCRS) {
                assert (dim == 1);
                indexes[2] = d++;
                continue;
            }
            if (crs2 instanceof TemporalCRS) {
                assert (dim == 1);
                indexes[3] = d++;
                continue;
            }
            throw new IllegalArgumentException("Unsupported CRS: " + crs2);
        }
        return indexes;
    }

    public static CoordinateReferenceSystem change2DComponent(CoordinateReferenceSystem originalCRS, CoordinateReferenceSystem crs2D) throws TransformException {
        CoordinateReferenceSystem targetCRS;
        if (crs2D.getCoordinateSystem().getDimension() != 2) {
            throw new IllegalArgumentException("Expected a 2D CRS");
        }
        if (originalCRS instanceof CompoundCRS) {
            CompoundCRS ccrs = (CompoundCRS)originalCRS;
            SingleCRS part2D = org.apache.sis.referencing.CRS.getHorizontalComponent((CoordinateReferenceSystem)originalCRS);
            ArrayList<CoordinateReferenceSystem> lst = new ArrayList<CoordinateReferenceSystem>();
            for (CoordinateReferenceSystem c : ccrs.getComponents()) {
                if (c.equals(part2D)) {
                    lst.add(crs2D);
                    continue;
                }
                lst.add(c);
            }
            try {
                targetCRS = org.apache.sis.referencing.CRS.compound((CoordinateReferenceSystem[])lst.toArray(new CoordinateReferenceSystem[lst.size()]));
            }
            catch (FactoryException ex) {
                throw new TransformException(ex.getMessage(), (Throwable)ex);
            }
        } else if (originalCRS.getCoordinateSystem().getDimension() == 2) {
            targetCRS = crs2D;
        } else {
            throw new UnsupportedOperationException("How do we change the 2D component of a CRS if it's not a CompoundCRS ?");
        }
        return targetCRS;
    }

    public static Envelope transform2DCRS(Envelope env, CoordinateReferenceSystem crs2D) throws TransformException {
        CoordinateReferenceSystem originalCRS = env.getCoordinateReferenceSystem();
        CoordinateReferenceSystem targetCRS = ReferencingUtilities.change2DComponent(originalCRS, crs2D);
        return Envelopes.transform((Envelope)env, (CoordinateReferenceSystem)targetCRS);
    }

    public static Envelope setLongitudeFirst(Envelope env) throws TransformException, FactoryException {
        if (env == null) {
            return env;
        }
        CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
        CoordinateReferenceSystem flipped = ReferencingUtilities.setLongitudeFirst(crs);
        return Envelopes.transform((Envelope)env, (CoordinateReferenceSystem)flipped);
    }

    @Deprecated
    public static CoordinateReferenceSystem setLongitudeFirst(CoordinateReferenceSystem crs) throws FactoryException {
        if (crs instanceof SingleCRS) {
            SingleCRS singlecrs = (SingleCRS)crs;
            CoordinateSystem cs = singlecrs.getCoordinateSystem();
            int dimension = cs.getDimension();
            if (dimension <= 1) {
                return crs;
            }
            int eastAxis = -1;
            for (int i = 0; i < dimension; ++i) {
                AxisDirection firstAxis = cs.getAxis(i).getDirection();
                if (firstAxis != AxisDirection.EAST && firstAxis != AxisDirection.WEST) continue;
                eastAxis = i;
                break;
            }
            if (eastAxis == 0) {
                return singlecrs;
            }
            String id = ReferencingUtilities.lookupIdentifier((IdentifiedObject)singlecrs, true);
            if (id != null) {
                return AbstractCRS.castOrCopy((CoordinateReferenceSystem)org.apache.sis.referencing.CRS.forCode((String)id)).forConvention(AxesConvention.RIGHT_HANDED);
            }
            throw new FactoryException("Failed to create flipped axis for crs : " + singlecrs);
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS compoundcrs = (CompoundCRS)crs;
            List components = compoundcrs.getComponents();
            int size = components.size();
            CoordinateReferenceSystem[] parts = new CoordinateReferenceSystem[size];
            boolean changed = false;
            for (int i = 0; i < size; ++i) {
                CoordinateReferenceSystem orig = (CoordinateReferenceSystem)components.get(i);
                parts[i] = ReferencingUtilities.setLongitudeFirst(orig);
                if (parts[i].equals(orig)) continue;
                changed = true;
            }
            if (changed) {
                return org.apache.sis.referencing.CRS.compound((CoordinateReferenceSystem[])parts);
            }
            return crs;
        }
        return crs;
    }

    public static AffineTransform toAffine(Dimension rect, Envelope env) {
        double minx = env.getMinimum(0);
        double maxy = env.getMaximum(1);
        double scaleX = env.getSpan(0) / (double)rect.width;
        double scaleY = -env.getSpan(1) / (double)rect.height;
        return new AffineTransform(scaleX, 0.0, 0.0, scaleY, minx, maxy);
    }

    @Deprecated
    public static MathTransform toTransform(MathTransform base, double[] ... values) {
        MathTransform result = MathTransforms.passThrough((int)0, (MathTransform)base, (int)values.length);
        int baseDim = base.getSourceDimensions();
        for (int i = 0; i < values.length; ++i) {
            double[] array = values[i];
            Object axistrs = array.length == 0 ? (MathTransform1D)MathTransforms.linear((double)1.0, (double)0.0) : (array.length == 1 ? (MathTransform1D)MathTransforms.linear((double)1.0, (double)array[0]) : LinearInterpolator1D.create(array));
            MathTransform mask = MathTransforms.passThrough((int)(baseDim + i), (MathTransform)axistrs, (int)(values.length - i - 1));
            result = MathTransforms.concatenate((MathTransform)result, (MathTransform)mask);
        }
        return result;
    }

    public static MathTransform toTransform(int firstBaseOrdinate, MathTransform subTransform, Map<Integer, double[]> axisValues, int expectedTargetDimension) {
        ReferencingUtilities.checkMTToTransform(firstBaseOrdinate, subTransform, axisValues, expectedTargetDimension);
        MathTransform result = MathTransforms.passThrough((int)firstBaseOrdinate, (MathTransform)subTransform, (int)(expectedTargetDimension - subTransform.getTargetDimensions() - firstBaseOrdinate));
        for (Integer dim : axisValues.keySet()) {
            double[] currentAxisValues = axisValues.get(dim);
            LinearInterpolator1D axistrs = currentAxisValues.length <= 1 ? (MathTransform1D)MathTransforms.linear((double)1.0, (double)(currentAxisValues.length == 0 ? 0.0 : currentAxisValues[0])) : LinearInterpolator1D.create(currentAxisValues);
            MathTransform mask = MathTransforms.passThrough((int)dim, (MathTransform)axistrs, (int)(expectedTargetDimension - dim - 1));
            result = MathTransforms.concatenate((MathTransform)result, (MathTransform)mask);
        }
        return result;
    }

    private static void checkMTToTransform(int firstBaseOrdinate, MathTransform subTransform, Map<Integer, double[]> axisValues, int expectedTargetDimension) {
        ArgumentChecks.ensureNonNull((String)"subTransform", (Object)subTransform);
        ArgumentChecks.ensureNonNull((String)"axisValues", axisValues);
        int subTransformDimensionNumber = subTransform.getTargetDimensions();
        if (expectedTargetDimension < subTransformDimensionNumber) {
            throw new MismatchedDimensionException("expectedTargetDimension should be upper than subtransform target dimension. Expected upper than : " + subTransformDimensionNumber + " found : " + expectedTargetDimension);
        }
        ArgumentChecks.ensureBetween((String)"firstBaseOrdinate", (int)0, (int)(expectedTargetDimension - subTransformDimensionNumber), (int)firstBaseOrdinate);
        if (expectedTargetDimension > 64) {
            throw new IllegalArgumentException("targetDimension > 64 not supported");
        }
        long isOrdinateChecked = (1 << subTransformDimensionNumber) - 1 << expectedTargetDimension - firstBaseOrdinate - subTransformDimensionNumber;
        for (Integer dim : axisValues.keySet()) {
            isOrdinateChecked |= (long)(1 << expectedTargetDimension - dim - 1);
        }
        if (isOrdinateChecked != (long)((1 << expectedTargetDimension) - 1)) {
            StringBuilder strB = new StringBuilder("The following dimension must be informed : ");
            for (int d = 0; d < expectedTargetDimension; ++d) {
                long currentDim = 1 << d;
                if ((isOrdinateChecked & currentDim) == currentDim) continue;
                strB.append(d);
                if (d == expectedTargetDimension - 1) continue;
                strB.append(",");
            }
            throw new IllegalArgumentException(strB.toString());
        }
    }

    public static Map<Integer, CoordinateReferenceSystem> indexedDecompose(CoordinateReferenceSystem crs) {
        TreeMap<Integer, CoordinateReferenceSystem> result = new TreeMap<Integer, CoordinateReferenceSystem>();
        int index = 0;
        List crsParts = org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)crs);
        for (int j = 0; j < crsParts.size(); ++j) {
            CoordinateReferenceSystem crsPart = (CoordinateReferenceSystem)crsParts.get(j);
            CoordinateSystem csPart = crsPart.getCoordinateSystem();
            result.put(index, crsPart);
            index += csPart.getDimension();
        }
        return result;
    }

    public static GeneralEnvelope transposeEnvelope(GeneralEnvelope source, GeneralEnvelope destination) {
        ArgumentChecks.ensureNonNull((String)"source envelope", (Object)source);
        ArgumentChecks.ensureNonNull((String)"destination envelope", (Object)destination);
        CoordinateReferenceSystem sourceCRS = source.getCoordinateReferenceSystem();
        CoordinateReferenceSystem destCRS = destination.getCoordinateReferenceSystem();
        if (Utilities.equalsApproximately((Object)sourceCRS, (Object)destCRS)) {
            destination = new GeneralEnvelope((Envelope)source);
        }
        List sourceComponents = org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)sourceCRS);
        List destComponents = org.apache.sis.referencing.CRS.getSingleComponents((CoordinateReferenceSystem)destCRS);
        ArrayList<CoordinateReferenceSystem> usedCRS = new ArrayList<CoordinateReferenceSystem>(destComponents.size());
        int srcLowerAxis = 0;
        int srcAxisCount = 0;
        block2: for (int srcCptCounter = 0; srcCptCounter < sourceComponents.size(); ++srcCptCounter) {
            GeneralEnvelope srcSubEnvelope;
            CoordinateReferenceSystem destCurrent;
            int destCptCounter;
            boolean searchHorizontal = false;
            boolean searchVertical = false;
            boolean searchTemporal = false;
            srcLowerAxis += srcAxisCount;
            int destLowerAxis = 0;
            int destAxisCount = 0;
            CoordinateReferenceSystem srcCurrent = (CoordinateReferenceSystem)sourceComponents.get(srcCptCounter);
            srcAxisCount = srcCurrent.getCoordinateSystem().getDimension();
            for (destCptCounter = 0; destCptCounter < destComponents.size(); ++destCptCounter) {
                destLowerAxis += destAxisCount;
                destCurrent = (CoordinateReferenceSystem)destComponents.get(destCptCounter);
                destAxisCount = destCurrent.getCoordinateSystem().getDimension();
                if (usedCRS.contains(destCurrent) || !Utilities.equalsApproximately((Object)srcCurrent, (Object)destCurrent)) continue;
                srcSubEnvelope = source.subEnvelope(srcLowerAxis, srcLowerAxis + srcAxisCount);
                destination.subEnvelope(destLowerAxis, destLowerAxis + srcSubEnvelope.getDimension()).setEnvelope((Envelope)srcSubEnvelope);
                usedCRS.add(destCurrent);
                continue block2;
            }
            destLowerAxis = 0;
            destAxisCount = 0;
            if (org.apache.sis.referencing.CRS.getHorizontalComponent((CoordinateReferenceSystem)srcCurrent) != null) {
                searchHorizontal = true;
            } else if (org.apache.sis.referencing.CRS.getVerticalComponent((CoordinateReferenceSystem)srcCurrent, (boolean)true) != null) {
                searchVertical = true;
            } else if (org.apache.sis.referencing.CRS.getTemporalComponent((CoordinateReferenceSystem)srcCurrent) != null) {
                searchTemporal = true;
            }
            for (destCptCounter = 0; destCptCounter < destComponents.size(); ++destCptCounter) {
                boolean compatible = false;
                destLowerAxis += destAxisCount;
                destCurrent = (CoordinateReferenceSystem)destComponents.get(destCptCounter);
                destAxisCount = destCurrent.getCoordinateSystem().getDimension();
                if (usedCRS.contains(destCurrent)) continue;
                if (searchHorizontal) {
                    if (org.apache.sis.referencing.CRS.getHorizontalComponent((CoordinateReferenceSystem)destCurrent) != null) {
                        compatible = true;
                    }
                } else if (searchVertical) {
                    if (org.apache.sis.referencing.CRS.getVerticalComponent((CoordinateReferenceSystem)destCurrent, (boolean)true) != null) {
                        compatible = true;
                    }
                } else if (searchTemporal) {
                    if (org.apache.sis.referencing.CRS.getTemporalComponent((CoordinateReferenceSystem)destCurrent) != null) {
                        compatible = true;
                    }
                } else {
                    CoordinateSystem sourceCS = srcCurrent.getCoordinateSystem();
                    CoordinateSystem destCS = destCurrent.getCoordinateSystem();
                    if (sourceCS.getDimension() == destCS.getDimension()) {
                        boolean sameAxis = true;
                        for (int axisCount = 0; axisCount < sourceCS.getDimension(); ++axisCount) {
                            if (AxisDirections.indexOfColinear((CoordinateSystem)destCS, (AxisDirection)sourceCS.getAxis(axisCount).getDirection()) >= 0) continue;
                            sameAxis = false;
                            break;
                        }
                        compatible = sameAxis;
                    }
                }
                if (!compatible) continue;
                srcSubEnvelope = source.subEnvelope(srcLowerAxis, srcLowerAxis + srcAxisCount);
                srcSubEnvelope.setCoordinateReferenceSystem(srcCurrent);
                try {
                    Envelope tmp = Envelopes.transform((Envelope)srcSubEnvelope, (CoordinateReferenceSystem)destCurrent);
                    destination.subEnvelope(destLowerAxis, destLowerAxis + tmp.getDimension()).setEnvelope(tmp);
                }
                catch (TransformException e) {
                    continue;
                }
                usedCRS.add(destCurrent);
                continue block2;
            }
        }
        return destination;
    }

    public static GeneralEnvelope intersectEnvelopes(Envelope layerEnvelope, Envelope filterEnvelope) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"source envelope", (Object)layerEnvelope);
        GeneralEnvelope resultEnvelope = new GeneralEnvelope(layerEnvelope);
        if (filterEnvelope == null) {
            return resultEnvelope;
        }
        CoordinateReferenceSystem inputCRS = layerEnvelope.getCoordinateReferenceSystem();
        CoordinateReferenceSystem filterCRS = filterEnvelope.getCoordinateReferenceSystem();
        if (resultEnvelope.getDimension() <= filterEnvelope.getDimension()) {
            resultEnvelope.intersect(Envelopes.transform((Envelope)filterEnvelope, (CoordinateReferenceSystem)inputCRS));
        } else if (inputCRS instanceof CompoundCRS) {
            ArrayList<Object> toFind = new ArrayList<Object>(3);
            TemporalCRS inputTemporal = org.apache.sis.referencing.CRS.getTemporalComponent((CoordinateReferenceSystem)inputCRS);
            TemporalCRS filterTemporal = org.apache.sis.referencing.CRS.getTemporalComponent((CoordinateReferenceSystem)filterCRS);
            SingleCRS inputHorizontal = org.apache.sis.referencing.CRS.getHorizontalComponent((CoordinateReferenceSystem)inputCRS);
            SingleCRS filterHorizontal = org.apache.sis.referencing.CRS.getHorizontalComponent((CoordinateReferenceSystem)filterCRS);
            VerticalCRS inputVertical = org.apache.sis.referencing.CRS.getVerticalComponent((CoordinateReferenceSystem)inputCRS, (boolean)true);
            VerticalCRS filterVertical = org.apache.sis.referencing.CRS.getVerticalComponent((CoordinateReferenceSystem)filterCRS, (boolean)true);
            if (inputHorizontal != null && filterHorizontal != null) {
                toFind.add(inputHorizontal);
            }
            if (inputTemporal != null && filterTemporal != null) {
                toFind.add(inputTemporal);
            }
            if (inputVertical != null && filterVertical != null) {
                toFind.add(inputVertical);
            }
            if (toFind.size() <= 0) {
                throw new TransformException("An error occured while applying filter : input layer CRS and filter CRS aren't compatible.");
            }
            Object tmpCRS = toFind.size() == 1 ? (CoordinateReferenceSystem)toFind.get(0) : CRS.getCompoundCRS((CompoundCRS)inputCRS, toFind.toArray(new SingleCRS[toFind.size()]));
            GeneralEnvelope tmpFilter = new GeneralEnvelope(Envelopes.transform((Envelope)filterEnvelope, (CoordinateReferenceSystem)tmpCRS));
            GeneralEnvelope tmpResult = new GeneralEnvelope(Envelopes.transform((Envelope)resultEnvelope, (CoordinateReferenceSystem)tmpCRS));
            tmpResult.intersect((Envelope)tmpFilter);
            int tmpOffset = 0;
            for (CoordinateReferenceSystem coordinateReferenceSystem : toFind) {
                int srcOffset = AxisDirections.indexOfColinear((CoordinateSystem)inputCRS.getCoordinateSystem(), (CoordinateSystem)coordinateReferenceSystem.getCoordinateSystem());
                if (srcOffset < 0) continue;
                int tmpDimNumber = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                GeneralEnvelope subTmp = tmpResult.subEnvelope(tmpOffset, tmpOffset + tmpDimNumber);
                resultEnvelope.subEnvelope(srcOffset, srcOffset + tmpResult.getDimension()).setEnvelope((Envelope)subTmp);
                break;
            }
        } else {
            throw new TransformException("An error occured while applying filter : input layer CRS and filter CRS aren't compatible.");
        }
        return resultEnvelope;
    }

    public static AffineTransform readTransform(Path f) throws IOException, NumberFormatException {
        String str = IOUtilities.toString(f);
        String[] parts = str.split("\n");
        double[] vals = new double[6];
        int idx = 0;
        for (String line : parts) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
            vals[idx] = Double.parseDouble(line);
            ++idx;
        }
        return new AffineTransform(vals);
    }

    private static Map<String, String> name(String name) {
        return Collections.singletonMap("name", name);
    }

    public static String lookupIdentifier(IdentifiedObject object, boolean fullScan) throws FactoryException {
        if (object == null) {
            return null;
        }
        IdentifiedObjectFinder f = IdentifiedObjects.newFinder(null);
        f.setSearchDomain(fullScan ? IdentifiedObjectFinder.Domain.ALL_DATASET : IdentifiedObjectFinder.Domain.DECLARATION);
        for (IdentifiedObject o : f.find(object)) {
            String i = IdentifiedObjects.toString((Identifier)IdentifiedObjects.getIdentifier((IdentifiedObject)o, null));
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public static boolean intersects(Envelope env1, Envelope env2) {
        CoordinateReferenceSystem crs1 = env1.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crs2 = env2.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crs = org.apache.sis.referencing.CRS.suggestCommonTarget(null, (CoordinateReferenceSystem[])new CoordinateReferenceSystem[]{crs1, crs2});
        if (crs != null) {
            try {
                Envelope penv1 = Envelopes.transform((Envelope)env1, (CoordinateReferenceSystem)crs);
                Envelope penv2 = Envelopes.transform((Envelope)env2, (CoordinateReferenceSystem)crs);
                return GeneralEnvelope.castOrCopy((Envelope)penv1).intersects(penv2);
            }
            catch (Exception penv1) {
                // empty catch block
            }
        }
        try {
            Envelope penv2 = Envelopes.transform((Envelope)env2, (CoordinateReferenceSystem)crs1);
            if (!GeneralEnvelope.castOrCopy((Envelope)penv2).isEmpty()) {
                return GeneralEnvelope.castOrCopy((Envelope)env1).intersects(penv2);
            }
        }
        catch (Exception penv2) {
            // empty catch block
        }
        try {
            Envelope penv1 = Envelopes.transform((Envelope)env1, (CoordinateReferenceSystem)crs2);
            if (!GeneralEnvelope.castOrCopy((Envelope)penv1).isEmpty()) {
                return GeneralEnvelope.castOrCopy((Envelope)penv1).intersects(env2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Optional<? extends GeographicBoundingBox> findGeographicBBox(Resource r) throws DataStoreException {
        return r.getMetadata().getIdentificationInfo().stream().flatMap(i -> i.getExtents().stream()).map(Extents::getGeographicBoundingBox).map(DefaultGeographicBoundingBox::new).reduce((b1, b2) -> {
            b1.add((GeographicBoundingBox)b2);
            return b1;
        });
    }

    public static double orthodromicDistance(double radius, double \u03bb1, double \u03c61, double \u03bb2, double \u03c62) {
        \u03c61 = Math.toRadians(\u03c61);
        \u03c62 = Math.toRadians(\u03c62);
        double dx = Math.toRadians(Math.abs(\u03bb2 - \u03bb1) % 360.0);
        double rho = Math.sin(\u03c61) * Math.sin(\u03c62) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.cos(dx);
        assert (Math.abs(rho) < 1.0000001) : rho;
        if (rho > 1.0) {
            rho = 1.0;
        }
        if (rho < -1.0) {
            rho = -1.0;
        }
        return Math.acos(rho) * radius;
    }
}

