/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.PolarStereographic;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.EquatorialStereographic;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class Stereographic
extends UnitaryProjection {
    private static final long serialVersionUID = 948619442800459872L;
    static final double EPSILON = 1.0E-6;
    final double \u03c60;
    final double sin\u03c60;
    final double cos\u03c60;
    private final double \u03c71;
    private final double sin\u03c71;
    private final double cos\u03c71;

    public static MathTransform2D create(OperationMethod descriptor, ParameterValueGroup values) {
        Parameters parameters = Parameters.castOrWrap((ParameterValueGroup)values);
        double latitudeOfOrigin = Math.toRadians(parameters.doubleValue(org.geotoolkit.referencing.operation.provider.Stereographic.LATITUDE_OF_ORIGIN));
        DefaultMathTransformFactory factory = (DefaultMathTransformFactory)DefaultFactories.forBuildin(MathTransformFactory.class, DefaultMathTransformFactory.class);
        try {
            Object projection;
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                projection = new PolarStereographic(factory.getOperationMethod("Polar Stereographic (variant A)"), parameters);
            } else {
                boolean isSpherical = Stereographic.isSpherical(parameters);
                projection = Math.abs(latitudeOfOrigin) < 1.0E-6 ? (isSpherical ? new EquatorialStereographic.Spherical(descriptor, parameters) : new EquatorialStereographic(descriptor, parameters)) : (isSpherical ? new Spherical(descriptor, parameters) : new Stereographic(descriptor, parameters));
            }
            return (MathTransform2D)projection.createMapProjection((MathTransformFactory)factory);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Stereographic(OperationMethod method, Parameters parameters) {
        this(method, parameters, Double.NaN);
        double k0 = 2.0 * this.msfn(this.sin\u03c60, this.cos\u03c60) / this.cos\u03c71;
        if (this.eccentricity == 0.0) {
            k0 = 2.0;
        }
        this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertBefore(0, (Number)k0, null);
        this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertBefore(1, (Number)k0, null);
    }

    Stereographic(OperationMethod method, Parameters parameters, double latitudeOfOrigin) {
        super(method, parameters, null);
        double phi0;
        if (Double.isNaN(latitudeOfOrigin)) {
            latitudeOfOrigin = this.getAndStore(parameters, org.geotoolkit.referencing.operation.provider.Stereographic.LATITUDE_OF_ORIGIN);
        }
        if (Math.abs(phi0 = Math.toRadians(latitudeOfOrigin)) < 1.0E-6) {
            phi0 = 0.0;
            this.cos\u03c60 = 1.0;
            this.sin\u03c60 = 0.0;
            this.\u03c71 = 0.0;
            this.cos\u03c71 = 1.0;
            this.sin\u03c71 = 0.0;
        } else {
            this.cos\u03c60 = Math.cos(phi0);
            this.sin\u03c60 = Math.sin(phi0);
            this.\u03c71 = 2.0 * Math.atan(this.ssfn(phi0, this.sin\u03c60)) - 1.5707963267948966;
            this.cos\u03c71 = Math.cos(this.\u03c71);
            this.sin\u03c71 = Math.sin(this.\u03c71);
        }
        this.\u03c60 = phi0;
    }

    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double A;
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double ssfn = this.ssfn(\u03c6, sin\u03c6);
        if (dstPts != null) {
            double \u03c7 = 2.0 * Math.atan(ssfn) - 1.5707963267948966;
            double sin\u03c7 = Math.sin(\u03c7);
            double cos\u03c7 = Math.cos(\u03c7);
            double cos\u03c7_cos\u03bb = cos\u03c7 * cos\u03bb;
            A = 1.0 + this.sin\u03c71 * sin\u03c7 + this.cos\u03c71 * cos\u03c7_cos\u03bb;
            dstPts[dstOff] = cos\u03c7 * sin\u03bb / A;
            dstPts[dstOff + 1] = (this.cos\u03c71 * sin\u03c7 - this.sin\u03c71 * cos\u03c7_cos\u03bb) / A;
        }
        if (!derivate) {
            return null;
        }
        double cos\u03c6 = Math.cos(\u03c6);
        double sd = ssfn - 1.0 / ssfn;
        double s2p = 1.0 + ssfn * ssfn;
        double d\u03c7\u03c6 = 2.0 * this.dssfn_d\u03c6(\u03c6, sin\u03c6, cos\u03c6) * ssfn;
        A = s2p / ssfn + sd * this.sin\u03c71 + 2.0 * cos\u03bb * this.cos\u03c71;
        double dA\u03bb = -2.0 * this.cos\u03c71 * sin\u03bb / A;
        double dA\u03c6 = (2.0 * this.sin\u03c71 - sd * cos\u03bb * this.cos\u03c71) / (s2p * A);
        double d = this.cos\u03c71 * sd - 2.0 * cos\u03bb * this.sin\u03c71;
        return new Matrix2(2.0 * (cos\u03bb - sin\u03bb * dA\u03bb) / A, -sin\u03bb * d\u03c7\u03c6 * (sd / s2p + 2.0 * dA\u03c6) / A, (2.0 * sin\u03bb * this.sin\u03c71 - dA\u03bb * d) / A, d\u03c7\u03c6 * ((2.0 * this.cos\u03c71 + this.sin\u03c71 * cos\u03bb * sd) / s2p - dA\u03c6 * d) / A);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double \u03c6;
        double ct;
        double t;
        block1: {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double \u03c1 = Math.hypot(x, y);
            double ce = 2.0 * Math.atan(\u03c1);
            double cosce = Math.cos(ce);
            double since = Math.sin(ce);
            double \u03c7 = \u03c1 < 1.0E-6 ? this.\u03c71 : Math.asin(cosce * this.sin\u03c71 + y * since * this.cos\u03c71 / \u03c1);
            double tp = Math.tan(0.7853981633974483 + 0.5 * \u03c7);
            t = x * since;
            ct = \u03c1 * this.cos\u03c71 * cosce - y * this.sin\u03c71 * since;
            double halfe = 0.5 * this.eccentricity;
            \u03c6 = \u03c7;
            int i = 15;
            do {
                double d;
                double esin\u03c6 = this.eccentricity * Math.sin(\u03c6);
                double next = 2.0 * Math.atan(tp * Math.pow((1.0 + esin\u03c6) / (1.0 - esin\u03c6), halfe)) - 1.5707963267948966;
                double d2 = \u03c6;
                \u03c6 = next;
                if (Math.abs(d2 - d) < 1.0E-10) break block1;
            } while (--i >= 0);
            throw new ProjectionException(Errors.format((short)104));
        }
        dstPts[dstOff] = Math.atan2(t, ct);
        dstPts[dstOff + 1] = \u03c6;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            Stereographic that = (Stereographic)((Object)object);
            return InternalUtilities.epsilonEqual(this.\u03c60, that.\u03c60, mode);
        }
        return false;
    }

    static final class Spherical
    extends Stereographic {
        private static final long serialVersionUID = -8558594307755820783L;

        protected Spherical(OperationMethod method, Parameters parameters) {
            super(method, parameters);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03bb = Math.cos(\u03bb);
            double c0c\u03c6 = this.cos\u03c60 * cos\u03c6;
            double s0s\u03c6 = this.sin\u03c60 * sin\u03c6;
            double F = 1.0 + c0c\u03c6 * cos\u03bb + s0s\u03c6;
            double x = cos\u03c6 * sin\u03bb / F;
            double y = (this.cos\u03c60 * sin\u03c6 - this.sin\u03c60 * cos\u03c6 * cos\u03bb) / F;
            Matrix2 derivative = null;
            if (derivate) {
                double c0s\u03c6 = this.cos\u03c60 * sin\u03c6;
                double s0c\u03c6 = this.sin\u03c60 * cos\u03c6;
                double dFd\u03bb = c0c\u03c6 * sin\u03bb / F;
                double dFd\u03c6 = (c0s\u03c6 * cos\u03bb - s0c\u03c6) / F;
                double dcs\u03c6 = c0s\u03c6 - s0c\u03c6 * cos\u03bb;
                derivative = new Matrix2(cos\u03c6 * (dFd\u03bb * sin\u03bb + cos\u03bb) / F, sin\u03bb * (dFd\u03c6 * cos\u03c6 - sin\u03c6) / F, (dFd\u03bb * dcs\u03c6 + s0c\u03c6 * sin\u03bb) / F, (dFd\u03c6 * dcs\u03c6 + (s0s\u03c6 * cos\u03bb + c0c\u03c6)) / F);
            }
            assert (Assertions.checkDerivative(derivative, super.transform(srcPts, srcOff, dstPts, dstOff, derivate)) && Assertions.checkTransform(dstPts, dstOff, x, y));
            if (dstPts != null) {
                dstPts[dstOff] = x;
                dstPts[dstOff + 1] = y;
            }
            return derivative;
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
            double \u03bb;
            double \u03c6;
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double \u03c1 = Math.hypot(x, y);
            if (Math.abs(\u03c1) < 1.0E-6) {
                \u03c6 = this.\u03c60;
                \u03bb = 0.0;
            } else {
                double c = 2.0 * Math.atan(\u03c1);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                double ct = \u03c1 * this.cos\u03c60 * cosc - y * this.sin\u03c60 * sinc;
                double t = x * sinc;
                \u03c6 = Math.asin(cosc * this.sin\u03c60 + y * sinc * this.cos\u03c60 / \u03c1);
                \u03bb = Math.atan2(t, ct);
            }
            assert (this.checkInverseTransform(srcPts, srcOff, dstPts, dstOff, \u03bb, \u03c6));
            dstPts[dstOff] = \u03bb;
            dstPts[dstOff + 1] = \u03c6;
        }

        private boolean checkInverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, double \u03bb, double \u03c6) throws ProjectionException {
            super.inverseTransform(srcPts, srcOff, dstPts, dstOff);
            return Assertions.checkInverseTransform(dstPts, dstOff, \u03bb, \u03c6);
        }
    }
}

