/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.SampledByPoints;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.AbstractJTSGenericCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPointArray;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurveBoundary;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPoint;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.geotoolkit.internal.jaxb.DirectPositionAdapter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.complex.Composite;
import org.opengis.geometry.coordinate.ParamForPoint;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.CurveInterpolation;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSLineString
extends AbstractJTSGenericCurve
implements org.opengis.geometry.coordinate.LineString,
Primitive,
SampledByPoints {
    private PointArray controlPoints = new JTSPointArray();

    public JTSLineString() {
        ((JTSPointArray)this.controlPoints).setJTSParent(this);
    }

    public JTSLineString(CoordinateReferenceSystem crs) {
        super(crs);
        ((JTSPointArray)this.controlPoints).setJTSParent(this);
    }

    public PointArray getControlPoints() {
        return this.controlPoints;
    }

    public List asLineSegments() {
        return null;
    }

    @Override
    public CurveBoundary getBoundary() {
        return new JTSCurveBoundary(null, new JTSPoint(this.getStartPoint()), new JTSPoint(this.getEndPoint()));
    }

    public Curve getCurve() {
        return null;
    }

    public CurveInterpolation getInterpolation() {
        return CurveInterpolation.LINEAR;
    }

    public int getNumDerivativeInterior() {
        return 0;
    }

    public int getNumDerivativesAtEnd() {
        return Integer.MAX_VALUE;
    }

    public int getNumDerivativesAtStart() {
        return Integer.MAX_VALUE;
    }

    @Override
    public PointArray getSamplePoints() {
        return this.controlPoints;
    }

    public CurveSegment reverse() {
        PointArray pa;
        JTSLineString result = new JTSLineString();
        PointArray list = pa = result.getSamplePoints();
        int n = this.controlPoints.size();
        for (int i = n - 1; i >= 0; --i) {
            list.add(new GeneralDirectPosition(((Position)this.controlPoints.get(i)).getDirectPosition()));
        }
        return result;
    }

    public DirectPosition getStartPoint() {
        return (DirectPosition)this.controlPoints.get(0);
    }

    public DirectPosition getEndPoint() {
        return (DirectPosition)this.controlPoints.get(this.controlPoints.size() - 1);
    }

    public double[] getTangent(double s) {
        return null;
    }

    public double getStartParam() {
        return 0.0;
    }

    public double getEndParam() {
        return 1.0;
    }

    public double getStartConstructiveParam() {
        return 0.0;
    }

    public double getEndConstructiveParam() {
        return 1.0;
    }

    public ParamForPoint getParamForPoint(DirectPosition p) {
        return null;
    }

    public double length(DirectPosition point1, DirectPosition point2) {
        return 0.0;
    }

    public double length(double cparam1, double cparam2) {
        return 0.0;
    }

    public org.opengis.geometry.coordinate.LineString asLineString(double maxSpacing, double maxOffset) {
        return null;
    }

    @Override
    protected Geometry computeJTSPeer() {
        int n = this.controlPoints.size();
        Coordinate[] coords = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            coords[i] = JTSUtils.directPositionToCoordinate((DirectPosition)this.controlPoints.get(i));
        }
        LineString result = JTSUtils.GEOMETRY_FACTORY.createLineString(coords);
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            int srid = SRIDGenerator.toSRID(crs, SRIDGenerator.Version.V1);
            result.setSRID(srid);
        }
        return result;
    }

    public int getNumDerivativesInterior() {
        return 0;
    }

    public DirectPosition forConstructiveParam(double cp) {
        return null;
    }

    public DirectPosition forParam(double s) {
        return null;
    }

    public void applyCRSOnChild() {
        if (this.controlPoints != null) {
            ArrayList<Position> newPositions = new ArrayList<Position>();
            for (Position pos : this.controlPoints) {
                if (!(pos instanceof GeneralDirectPosition)) continue;
                ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                newPositions.add(pos);
            }
            this.controlPoints.clear();
            this.controlPoints.addAll(newPositions);
        }
    }

    @XmlElement(name="pos", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=DirectPositionAdapter.class)
    public List<Position> getPositions() {
        return this.controlPoints;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JTSLineString{");
        if (!this.controlPoints.isEmpty()) {
            sb.append("\n");
            for (Position pos : this.controlPoints) {
                sb.append("\t").append(pos.toString()).append("\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTSLineString & super.equals(object)) {
            JTSLineString that = (JTSLineString)object;
            return Objects.equals(this.controlPoints, that.controlPoints);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.controlPoints != null ? this.controlPoints.hashCode() : 0);
        return hash;
    }

    public Set<Primitive> getContainedPrimitives() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<Primitive> getContainingPrimitives() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<Complex> getComplexes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Composite getComposite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OrientablePrimitive[] getProxy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

