/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.util.HashSet;
import java.util.function.DoubleToIntFunction;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.IllegalSampleDimensionException;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.MathFunctions;

final class ToNaN
extends HashSet<Integer>
implements DoubleToIntFunction {
    Number background;

    ToNaN() {
    }

    @Override
    public void clear() {
        super.clear();
        this.background = null;
    }

    private boolean isBackground(double value) {
        return this.background != null && value == this.background.doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int applyAsInt(double value) {
        if (this.isBackground(value) && this.add(0)) {
            return 0;
        }
        int ordinal = Math.round((float)value);
        if (ordinal > 0x1FFFFF) {
            ordinal = 0x100000;
        } else if (ordinal < -2097152) {
            ordinal = -1048576;
        }
        if (this.add(ordinal)) return ordinal;
        if (ordinal >= 0) {
            while (!this.add(++ordinal)) {
                if (ordinal < 0x1FFFFF) continue;
                throw new IllegalSampleDimensionException(Resources.format((short)62));
            }
            return ordinal;
        }
        while (!this.add(--ordinal)) {
            if (ordinal > -2097152) continue;
            throw new IllegalSampleDimensionException(Resources.format((short)62));
        }
        return ordinal;
    }

    void remove(Category c) {
        float converted = (float)c.converse.range.getMinDouble();
        if (Float.isNaN(converted) && super.remove(MathFunctions.toNanOrdinal(converted)) && this.isBackground(c.range.getMinDouble())) {
            this.background = null;
        }
    }
}

