/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.feature.PropertyView;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.util.GenericName;

class AttributeView<V>
extends PropertyView<V>
implements Attribute<V> {
    private static final long serialVersionUID = 3617999929561826634L;
    final AttributeType<V> type;

    private AttributeView(Feature feature, AttributeType<V> type) {
        super(feature, type.getName().toString());
        this.type = type;
    }

    static <V> Attribute<V> create(Feature feature, AttributeType<V> type) {
        if (AttributeView.isSingleton(type.getMaximumOccurs())) {
            return new Singleton<V>(feature, type);
        }
        return new AttributeView<V>(feature, type);
    }

    public final GenericName getName() {
        return this.type.getName();
    }

    public final AttributeType<V> getType() {
        return this.type;
    }

    @Override
    final Class<V> getValueClass() {
        return this.type.getValueClass();
    }

    public final Map<String, Attribute<?>> characteristics() {
        return Collections.emptyMap();
    }

    private static final class Singleton<V>
    extends AttributeView<V> {
        private static final long serialVersionUID = -808239726590009163L;

        Singleton(Feature feature, AttributeType<V> type) {
            super(feature, type);
        }

        @Override
        public V getValue() {
            return (V)this.type.getValueClass().cast(this.feature.getPropertyValue(this.name));
        }

        @Override
        public void setValue(V value) {
            this.feature.setPropertyValue(this.name, value);
        }

        @Override
        public Collection<V> getValues() {
            return Singleton.singletonOrEmpty(this.getValue());
        }
    }
}

