/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.opengis.feature.Attribute;
import org.opengis.feature.FeatureAssociation;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;

final class SparseFeature
extends AbstractFeature
implements Cloneable {
    private static final long serialVersionUID = 2954323576287152427L;
    private static final byte VALUES = 0;
    private static final byte PROPERTIES = 1;
    private static final byte CORRUPTED = 2;
    private final Map<String, Integer> indices;
    private HashMap<Integer, Object> properties;
    private byte valuesKind;

    public SparseFeature(DefaultFeatureType type) {
        super(type);
        this.indices = type.indices();
        this.properties = new HashMap();
    }

    private Integer getIndex(String name) throws PropertyNotFoundException {
        Integer index = this.indices.get(name);
        if (index != null) {
            return index;
        }
        throw new PropertyNotFoundException(SparseFeature.propertyNotFound(this.type, this.getName(), name));
    }

    private String nameOf(Integer index) {
        for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
            if (!index.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        throw new AssertionError(index);
    }

    private void requireMapOfProperties() {
        if (this.valuesKind != 1) {
            if (!this.properties.isEmpty()) {
                if (this.valuesKind != 0) {
                    throw new CorruptedObjectException(this.getName());
                }
                this.valuesKind = (byte)2;
                for (Map.Entry<Integer, Object> entry : this.properties.entrySet()) {
                    Object value;
                    String key;
                    if (entry.setValue(this.createProperty(key = this.nameOf(entry.getKey()), value = entry.getValue())) == value) continue;
                    throw new ConcurrentModificationException(key);
                }
            }
            this.valuesKind = 1;
        }
    }

    @Override
    public Property getProperty(String name) throws PropertyNotFoundException {
        ArgumentChecks.ensureNonNull("name", name);
        this.requireMapOfProperties();
        return this.getPropertyInstance(name);
    }

    private Property getPropertyInstance(String name) throws PropertyNotFoundException {
        assert (this.valuesKind == 1) : this.valuesKind;
        Integer index = this.getIndex(name);
        if (index < 0) {
            return this.getOperationResult(name);
        }
        Property property = (Property)this.properties.get(index);
        if (property == null) {
            property = this.createProperty(name);
            this.replace(index, null, property);
        }
        return property;
    }

    @Override
    public void setProperty(Property property) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("property", property);
        String name = property.getName().toString();
        this.verifyPropertyType(name, property);
        this.requireMapOfProperties();
        this.properties.put(this.indices.get(name), property);
    }

    @Override
    public Object getPropertyValue(String name) throws PropertyNotFoundException {
        Object value = this.getValueOrFallback(name, MISSING);
        if (value != MISSING) {
            return value;
        }
        throw new PropertyNotFoundException(SparseFeature.propertyNotFound(this.type, this.getName(), name));
    }

    @Override
    public final Object getValueOrFallback(String name, Object missingPropertyFallback) {
        ArgumentChecks.ensureNonNull("name", name);
        Integer index = this.indices.get(name);
        if (index == null) {
            return missingPropertyFallback;
        }
        if (index < 0) {
            return this.getOperationValue(name);
        }
        Object element = this.properties.get(index);
        if (element != null) {
            if (this.valuesKind == 0) {
                return element;
            }
            if (element instanceof Attribute) {
                return SparseFeature.getAttributeValue((Attribute)element);
            }
            if (element instanceof FeatureAssociation) {
                return SparseFeature.getAssociationValue((FeatureAssociation)element);
            }
            if (this.valuesKind == 1) {
                throw new IllegalArgumentException(SparseFeature.unsupportedPropertyType(((Property)element).getName()));
            }
            throw new CorruptedObjectException(this.getName());
        }
        if (this.properties.containsKey(index)) {
            return null;
        }
        return this.getDefaultValue(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(String name, Object value) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("name", name);
        Integer index = this.getIndex(name);
        if (index < 0) {
            this.setOperationValue(name, value);
            return;
        }
        if (this.valuesKind == 0) {
            Object previous = this.properties.put(index, value);
            if (!SparseFeature.canSkipVerification(previous, value)) {
                Object toStore = previous;
                try {
                    toStore = this.verifyPropertyValue(name, value);
                }
                finally {
                    if (toStore != value) {
                        this.replace(index, value, toStore);
                    }
                }
            }
        } else if (this.valuesKind == 1) {
            SparseFeature.setPropertyValue(this.getPropertyInstance(name), value);
        } else {
            throw new CorruptedObjectException(this.getName());
        }
    }

    private void replace(Integer index, Object oldValue, Object newValue) {
        if (this.properties.put(index, newValue) != oldValue) {
            throw new ConcurrentModificationException(this.nameOf(index));
        }
    }

    @Override
    public DataQuality quality() {
        if (this.valuesKind == 0) {
            Validator v = new Validator(ScopeCode.FEATURE);
            for (Map.Entry<String, Integer> entry : this.indices.entrySet()) {
                v.validateAny(this.type.getProperty(entry.getKey()), this.properties.get(entry.getValue()));
            }
            return v.quality;
        }
        return super.quality();
    }

    public SparseFeature clone() throws CloneNotSupportedException {
        SparseFeature clone = (SparseFeature)super.clone();
        clone.properties = (HashMap)clone.properties.clone();
        switch (clone.valuesKind) {
            default: {
                throw new AssertionError(clone.valuesKind);
            }
            case 2: {
                throw new CorruptedObjectException(clone.getName());
            }
            case 0: {
                break;
            }
            case 1: {
                Cloner cloner = new Cloner();
                for (Map.Entry<Integer, Object> entry : clone.properties.entrySet()) {
                    Property property = (Property)entry.getValue();
                    if (!(property instanceof Cloneable)) continue;
                    entry.setValue(cloner.clone(property));
                }
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int code = this.type.hashCode() * 37;
        if (this.comparisonStart()) {
            try {
                if (this.valuesKind == 1) {
                    for (Map.Entry<Integer, Object> entry : this.properties.entrySet()) {
                        Object p = entry.getValue();
                        Object value = p instanceof Attribute ? SparseFeature.getAttributeValue((Attribute)p) : (p instanceof FeatureAssociation ? SparseFeature.getAssociationValue((FeatureAssociation)p) : null);
                        code += Objects.hashCode(entry.getKey()) ^ Objects.hashCode(value);
                    }
                } else {
                    code += this.properties.hashCode();
                }
            }
            finally {
                this.comparisonEnd();
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SparseFeature) {
            SparseFeature that = (SparseFeature)obj;
            if (this.type.equals((Object)that.type)) {
                boolean asProperties = this.valuesKind == 1;
                if (asProperties != (that.valuesKind == 1)) {
                    if (asProperties) {
                        that.requireMapOfProperties();
                    } else {
                        this.requireMapOfProperties();
                    }
                }
                if (this.comparisonStart()) {
                    try {
                        boolean bl = this.properties.equals(that.properties);
                        return bl;
                    }
                    finally {
                        this.comparisonEnd();
                    }
                }
                return true;
            }
        }
        return false;
    }
}

