/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.WritablePixelIterator;
import org.opengis.coverage.grid.SequenceType;

final class BandedIterator
extends WritablePixelIterator {
    private DataBuffer buffer;
    private DataBuffer destBuffer;
    private int sampleModelTranslateX;
    private int sampleModelTranslateY;
    private int xToBuffer;
    private final int scanlineStride;

    BandedIterator(Raster input, WritableRaster output, Rectangle subArea, Dimension window, SequenceType order, int scanlineStride) {
        super(input, output, subArea, window, order);
        this.scanlineStride = scanlineStride;
        this.acquiredTile(input);
        this.changedRowOrTile();
    }

    BandedIterator(RenderedImage input, WritableRenderedImage output, Rectangle subArea, Dimension window, SequenceType order, int scanlineStride) {
        super(input, output, subArea, window, order);
        this.scanlineStride = scanlineStride;
    }

    @Override
    final void changedRowOrTile() {
        this.xToBuffer = (this.y - this.sampleModelTranslateY) * this.scanlineStride - this.sampleModelTranslateX;
    }

    @Override
    public void moveTo(int px, int py) {
        if (this.isSameRowAndTile(px, py)) {
            this.x = px;
        } else {
            super.moveTo(px, py);
            this.changedRowOrTile();
        }
    }

    @Override
    final void acquiredTile(Raster tile) {
        assert (PixelIterator.Builder.getScanlineStride(tile.getSampleModel()) == this.scanlineStride);
        this.sampleModelTranslateY = tile.getSampleModelTranslateY();
        this.sampleModelTranslateX = tile.getSampleModelTranslateX();
        this.buffer = tile.getDataBuffer();
        tile = this.destination();
        if (tile != null) {
            this.destBuffer = tile.getDataBuffer();
            assert (PixelIterator.Builder.getScanlineStride(tile.getSampleModel()) == this.scanlineStride && tile.getSampleModelTranslateX() == this.sampleModelTranslateX && tile.getSampleModelTranslateY() == this.sampleModelTranslateY);
        }
    }

    @Override
    final void releaseTile() {
        if (this.image != null) {
            this.buffer = null;
            this.destBuffer = null;
        }
        super.releaseTile();
    }

    @Override
    public int getSample(int band) {
        return this.buffer.getElem(band, this.x + this.xToBuffer);
    }

    @Override
    public float getSampleFloat(int band) {
        return this.buffer.getElemFloat(band, this.x + this.xToBuffer);
    }

    @Override
    public double getSampleDouble(int band) {
        return this.buffer.getElemDouble(band, this.x + this.xToBuffer);
    }

    @Override
    public void setSample(int band, int value) {
        this.destBuffer.setElem(band, this.x + this.xToBuffer, value);
    }

    @Override
    public void setSample(int band, float value) {
        this.destBuffer.setElemFloat(band, this.x + this.xToBuffer, value);
    }

    @Override
    public void setSample(int band, double value) {
        this.destBuffer.setElemDouble(band, this.x + this.xToBuffer, value);
    }

    @Override
    public int[] getPixel(int[] dest) {
        if (dest == null) {
            dest = new int[this.numBands];
        }
        int index = this.x + this.xToBuffer;
        dest[0] = this.buffer.getElem(index);
        for (int i = 1; i < this.numBands; ++i) {
            dest[i] = this.buffer.getElem(i, index);
        }
        return dest;
    }

    @Override
    public float[] getPixel(float[] dest) {
        if (dest == null) {
            dest = new float[this.numBands];
        }
        int index = this.x + this.xToBuffer;
        dest[0] = this.buffer.getElemFloat(index);
        for (int i = 1; i < this.numBands; ++i) {
            dest[i] = this.buffer.getElemFloat(i, index);
        }
        return dest;
    }

    @Override
    public double[] getPixel(double[] dest) {
        if (dest == null) {
            dest = new double[this.numBands];
        }
        int index = this.x + this.xToBuffer;
        dest[0] = this.buffer.getElemDouble(index);
        for (int i = 1; i < this.numBands; ++i) {
            dest[i] = this.buffer.getElemDouble(i, index);
        }
        return dest;
    }

    @Override
    public void setPixel(int[] values) {
        int index = this.x + this.xToBuffer;
        this.destBuffer.setElem(index, values[0]);
        for (int i = 1; i < this.numBands; ++i) {
            this.destBuffer.setElem(i, index, values[i]);
        }
    }

    @Override
    public void setPixel(float[] values) {
        int index = this.x + this.xToBuffer;
        this.destBuffer.setElemFloat(index, values[0]);
        for (int i = 1; i < this.numBands; ++i) {
            this.destBuffer.setElemFloat(i, index, values[i]);
        }
    }

    @Override
    public void setPixel(double[] values) {
        int index = this.x + this.xToBuffer;
        this.destBuffer.setElemDouble(index, values[0]);
        for (int i = 1; i < this.numBands; ++i) {
            this.destBuffer.setElemDouble(i, index, values[i]);
        }
    }

    @Override
    PixelIterator.Window<FloatBuffer> createWindow(float[] data, float[] transfer) {
        return new FloatWindow(data, transfer);
    }

    @Override
    PixelIterator.Window<DoubleBuffer> createWindow(double[] data, double[] transfer) {
        return new DoubleWindow(data, transfer);
    }

    private final class FloatWindow
    extends PixelIterator.Window<FloatBuffer> {
        private final float[] data;
        private final float[] transfer;

        FloatWindow(float[] data, float[] transfer) {
            super(FloatBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        final PixelIterator owner() {
            return BandedIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, int mode) {
            float[] target;
            float[] fArray = target = mode == 0 ? this.data : this.transfer;
            if (mode != 2 && subY == BandedIterator.this.y) {
                DataBuffer source = BandedIterator.this.buffer;
                int toNext = BandedIterator.this.scanlineStride - subWidth;
                int numBds = BandedIterator.this.numBands;
                int srcOff = subX + BandedIterator.this.xToBuffer;
                int tgtOff = 0;
                do {
                    int c = subWidth;
                    do {
                        target[tgtOff++] = source.getElemFloat(srcOff);
                        for (int b = 1; b < numBds; ++b) {
                            target[tgtOff++] = source.getElemFloat(b, srcOff);
                        }
                        ++srcOff;
                    } while (--c != 0);
                    srcOff += toNext;
                } while (--subHeight != 0);
                return target;
            }
            return raster.getPixels(subX, subY, subWidth, subHeight, target);
        }

        @Override
        public void update() {
            ((FloatBuffer)this.values).clear();
            BandedIterator.this.fetchValues(this, this.data);
        }
    }

    private final class DoubleWindow
    extends PixelIterator.Window<DoubleBuffer> {
        private final double[] data;
        private final double[] transfer;

        DoubleWindow(double[] data, double[] transfer) {
            super(DoubleBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        final PixelIterator owner() {
            return BandedIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, int mode) {
            double[] target;
            double[] dArray = target = mode == 0 ? this.data : this.transfer;
            if (mode != 2 && subY == BandedIterator.this.y) {
                DataBuffer source = BandedIterator.this.buffer;
                int toNext = BandedIterator.this.scanlineStride - subWidth;
                int numBds = BandedIterator.this.numBands;
                int srcOff = subX + BandedIterator.this.xToBuffer;
                int tgtOff = 0;
                do {
                    int c = subWidth;
                    do {
                        target[tgtOff++] = source.getElemDouble(srcOff);
                        for (int b = 1; b < numBds; ++b) {
                            target[tgtOff++] = source.getElemDouble(b, srcOff);
                        }
                        ++srcOff;
                    } while (--c != 0);
                    srcOff += toNext;
                } while (--subHeight != 0);
                return target;
            }
            return raster.getPixels(subX, subY, subWidth, subHeight, target);
        }

        @Override
        public void update() {
            ((DoubleBuffer)this.values).clear();
            BandedIterator.this.fetchValues(this, this.data);
        }
    }
}

