/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.logging.Logging;

final class GeometryFactories {
    static final Geometries<?> implementation = GeometryFactories.link(GeometryFactories.link(GeometryFactories.link(null, "j2d"), "esri"), "jts");

    private GeometryFactories() {
    }

    private static Geometries<?> link(Geometries<?> previous, String name) {
        Geometries factory;
        String classname = GeometryFactories.class.getPackageName() + "." + name + ".Factory";
        try {
            factory = (Geometries)Class.forName(classname).getField("INSTANCE").get(null);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            LogRecord record = Resources.forLocale(null).getLogRecord(Level.CONFIG, (short)56, name, e.toString());
            Logging.completeAndLog(Geometries.LOGGER, Geometries.class, "register", record);
            return previous;
        }
        factory.fallback = previous;
        return factory;
    }
}

