/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Locale;

public enum GeometryType {
    GEOMETRY,
    POINT,
    LINESTRING,
    POLYGON,
    MULTI_POINT,
    MULTI_LINESTRING,
    MULTI_POLYGON,
    GEOMETRY_COLLECTION;


    public final int binaryType() {
        return this.ordinal();
    }

    public final boolean isCollection() {
        return this.ordinal() >= MULTI_POINT.ordinal();
    }

    public static GeometryType forName(String name) {
        int length;
        if (name != null && (length = (name = name.trim().toUpperCase(Locale.US)).length()) > 0) {
            if (name.charAt(length - 1) == 'M') {
                --length;
            }
            if (length > 0 && name.charAt(length - 1) == 'Z') {
                --length;
            }
            switch (name = name.substring(0, length)) {
                case "MULTIPOINT": {
                    return MULTI_POINT;
                }
                case "MULTILINESTRING": {
                    return MULTI_LINESTRING;
                }
                case "MULTIPOLYGON": {
                    return MULTI_POLYGON;
                }
                case "GEOMCOLLECTION": {
                    return GEOMETRY_COLLECTION;
                }
            }
            return GeometryType.valueOf(name);
        }
        return null;
    }

    public static GeometryType forBinaryType(int type) {
        if (type >= 1000 && type < 4000) {
            type %= 1000;
        }
        switch (type) {
            default: {
                return null;
            }
            case 0: {
                return GEOMETRY;
            }
            case 1: {
                return POINT;
            }
            case 2: {
                return LINESTRING;
            }
            case 3: {
                return POLYGON;
            }
            case 4: {
                return MULTI_POINT;
            }
            case 5: {
                return MULTI_LINESTRING;
            }
            case 6: {
                return MULTI_POLYGON;
            }
            case 7: 
        }
        return GEOMETRY_COLLECTION;
    }
}

