/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.jts.JTS;
import org.apache.sis.internal.feature.jts.PackedCoordinateSequence;
import org.apache.sis.internal.feature.jts.PackedCoordinateSequenceFactory;
import org.apache.sis.internal.feature.jts.Wrapper;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 3457343016410620076L;
    public static final Factory INSTANCE = new Factory();
    private final transient GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(true));
    private final transient GeometryFactory fctry32 = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(false));

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.JTS, Geometry.class, Point.class, LineString.class, Polygon.class);
    }

    @Override
    public Class<?> getGeometryClass(GeometryType type) {
        switch (type) {
            default: {
                return this.rootClass;
            }
            case POINT: {
                return this.pointClass;
            }
            case LINESTRING: {
                return this.polylineClass;
            }
            case POLYGON: {
                return this.polygonClass;
            }
            case MULTI_POINT: {
                return MultiPoint.class;
            }
            case MULTI_LINESTRING: {
                return MultiLineString.class;
            }
            case MULTI_POLYGON: 
        }
        return MultiPolygon.class;
    }

    @Override
    public GeometryWrapper<Geometry> castOrWrap(Object geometry) {
        return geometry == null || geometry instanceof Wrapper ? (Wrapper)geometry : new Wrapper((Geometry)geometry);
    }

    @Override
    protected GeometryWrapper<Geometry> createWrapper(Geometry geometry) {
        return new Wrapper(geometry);
    }

    static boolean isFloat(CoordinateSequence cs) {
        return cs instanceof PackedCoordinateSequence.Float || cs instanceof PackedCoordinateSequence.Float;
    }

    static boolean isFloat(boolean previous, Point geometry) {
        return previous && Factory.isFloat(geometry.getCoordinateSequence());
    }

    public final GeometryFactory factory(boolean isFloat) {
        return isFloat ? this.fctry32 : this.factory;
    }

    @Override
    public Object createPoint(float x, float y) {
        return this.fctry32.createPoint((Coordinate)new CoordinateXY((double)x, (double)y));
    }

    @Override
    public Object createPoint(double x, double y) {
        return this.factory.createPoint((Coordinate)new CoordinateXY(x, y));
    }

    @Override
    public Object createPoint(double x, double y, double z) {
        return this.factory.createPoint(new Coordinate(x, y, z));
    }

    @Override
    public Geometry createPolyline(boolean polygon, int dimension, Vector ... coordinates) {
        boolean is3D;
        boolean bl = is3D = dimension == 3;
        if (!is3D && dimension != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(dimension));
        }
        boolean isFloat = true;
        for (Vector v : coordinates) {
            if (v == null || v.isSinglePrecision()) continue;
            isFloat = false;
            break;
        }
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>(32);
        ArrayList<Geometry> lines = new ArrayList<Geometry>();
        for (Vector v : coordinates) {
            if (v == null) continue;
            int size = v.size();
            int i = 0;
            while (i < size) {
                double x = v.doubleValue(i++);
                double y = v.doubleValue(i++);
                if (!Double.isNaN(x) && !Double.isNaN(y)) {
                    Object c = is3D ? new Coordinate(x, y, v.doubleValue(i++)) : new CoordinateXY(x, y);
                    coordList.add((Coordinate)c);
                    continue;
                }
                if (is3D) {
                    ++i;
                }
                this.toLineString(coordList, lines, polygon, isFloat);
                coordList.clear();
            }
        }
        this.toLineString(coordList, lines, polygon, isFloat);
        return this.toGeometry(lines, polygon, isFloat);
    }

    @Override
    public GeometryWrapper<Geometry> createMultiPolygon(Object[] geometries) {
        Polygon[] polygons = new Polygon[geometries.length];
        boolean isFloat = true;
        for (int i = 0; i < geometries.length; ++i) {
            Polygon polygon;
            Object polyline = Factory.unwrap(geometries[i]);
            if (polyline instanceof Polygon) {
                polygon = (Polygon)polyline;
            } else {
                boolean fs;
                CoordinateSequence cs;
                if (polyline instanceof LinearRing) {
                    LinearRing ring = (LinearRing)polyline;
                    cs = ring.getCoordinateSequence();
                    fs = Factory.isFloat(cs);
                    polygon = this.factory(fs).createPolygon(ring);
                } else if (polyline instanceof LineString) {
                    cs = ((LineString)polyline).getCoordinateSequence();
                    fs = Factory.isFloat(cs);
                    polygon = this.factory(fs).createPolygon(cs);
                } else {
                    throw new ClassCastException(Errors.format((short)43, Strings.bracket("geometries", (Object)i), Polygon.class, Classes.getClass(polyline)));
                }
                JTS.copyMetadata((Geometry)polyline, (Geometry)polygon);
                isFloat &= fs;
            }
            polygons[i] = polygon;
        }
        return new Wrapper((Geometry)this.factory(isFloat).createMultiPolygon(polygons));
    }

    final void toLineString(List<Coordinate> coordinates, List<Geometry> addTo, boolean polygon, boolean isFloat) {
        int s = coordinates.size();
        if (s >= 2) {
            Coordinate[] ca = coordinates.toArray(new Coordinate[s]);
            GeometryFactory gf = this.factory(isFloat);
            Object geometry = polygon ? gf.createPolygon(ca) : (ca.length > 3 && ca[0].equals2D(ca[s - 1]) ? gf.createLinearRing(ca) : gf.createLineString(ca));
            addTo.add((Geometry)geometry);
        }
    }

    final Geometry toGeometry(List<Geometry> lines, boolean polygon, boolean isFloat) {
        int s = lines.size();
        switch (s) {
            case 0: {
                GeometryFactory gf = this.factory(isFloat);
                return polygon ? gf.createPolygon((Coordinate[])null) : gf.createLinearRing((Coordinate[])null);
            }
            case 1: {
                return lines.get(0);
            }
        }
        GeometryFactory gf = this.factory(isFloat);
        return polygon ? gf.createMultiPolygon(lines.toArray(new Polygon[s])) : gf.createMultiLineString(lines.toArray(new LineString[s]));
    }

    private <G extends Geometry> Geometry createFromComponents(G[] geometries, Function<G, CoordinateSequence> csGetter, BiFunction<GeometryFactory, G[], Geometry> builder) {
        boolean isFloat = true;
        for (G geometry : geometries) {
            if (Factory.isFloat(csGetter.apply(geometry))) continue;
            isFloat = false;
            break;
        }
        return builder.apply(this.factory(isFloat), geometries);
    }

    @Override
    public GeometryWrapper<Geometry> createFromComponents(GeometryType type, Object components) {
        GeometryCollection geometry;
        block0 : switch (type) {
            case GEOMETRY_COLLECTION: {
                geometry = this.factory.createGeometryCollection((Geometry[])components);
                break;
            }
            case MULTI_LINESTRING: {
                geometry = this.createFromComponents((Geometry[])((LineString[])components), LineString::getCoordinateSequence, GeometryFactory::createMultiLineString);
                break;
            }
            case MULTI_POLYGON: {
                geometry = this.createFromComponents((Geometry[])((Polygon[])components), g -> g.getExteriorRing().getCoordinateSequence(), GeometryFactory::createMultiPolygon);
                break;
            }
            case MULTI_POINT: {
                if (components instanceof Point[]) {
                    geometry = this.createFromComponents((Geometry[])((Point[])components), Point::getCoordinateSequence, GeometryFactory::createMultiPoint);
                    break;
                }
            }
            default: {
                GeometryFactory gf;
                CoordinateSequence cs;
                if (components instanceof CoordinateSequence) {
                    cs = (CoordinateSequence)components;
                    gf = this.factory(Factory.isFloat(cs));
                } else {
                    Coordinate[] coordinates;
                    if (components instanceof Coordinate[]) {
                        coordinates = (Coordinate[])components;
                        gf = this.factory;
                    } else {
                        List<Object> source = components instanceof Collection ? (List<Object>)components : Arrays.asList((Object[])components);
                        coordinates = new Coordinate[source.size()];
                        boolean isFloat = true;
                        int n = 0;
                        for (Object e : source) {
                            Coordinate c;
                            if (e instanceof Point) {
                                Point p = (Point)e;
                                isFloat = Factory.isFloat(isFloat, p);
                                c = p.getCoordinate();
                            } else {
                                c = (Coordinate)e;
                                isFloat = false;
                            }
                            coordinates[n++] = c;
                        }
                        gf = this.factory(isFloat);
                    }
                    cs = gf.getCoordinateSequenceFactory().create(coordinates);
                }
                switch (type) {
                    case MULTI_POINT: 
                    case GEOMETRY: {
                        geometry = gf.createMultiPoint(cs);
                        break block0;
                    }
                    case LINESTRING: {
                        geometry = gf.createLineString(cs);
                        break block0;
                    }
                    case POLYGON: {
                        geometry = gf.createPolygon(cs);
                        break block0;
                    }
                    case POINT: {
                        geometry = gf.createMultiPoint(cs).getCentroid();
                        break block0;
                    }
                }
                throw new AssertionError((Object)type);
            }
        }
        return new Wrapper((Geometry)geometry);
    }

    @Override
    public GeometryWrapper<Geometry> parseWKT(String wkt) throws ParseException {
        WKTReader reader = new WKTReader(this.factory);
        reader.setIsOldJtsCoordinateSyntaxAllowed(false);
        return new Wrapper(reader.read(wkt));
    }

    @Override
    public GeometryWrapper<Geometry> parseWKB(ByteBuffer data) throws ParseException {
        byte[] array;
        if (data.hasArray()) {
            array = data.array();
            int lower = data.arrayOffset();
            int upper = data.limit() + lower;
            if ((lower += data.position()) != 0 || upper != array.length) {
                array = Arrays.copyOfRange(array, lower, upper);
            }
        } else {
            array = new byte[data.remaining()];
            data.get(array);
        }
        return new Wrapper(new WKBReader(this.factory).read(array));
    }
}

