/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.filter.sqlmm.SpatialFunction;
import org.opengis.filter.Expression;

class OneGeometry<R, G>
extends SpatialFunction<R> {
    private static final long serialVersionUID = 3895562608419096524L;
    final Expression<R, GeometryWrapper<G>> geometry;

    OneGeometry(SQLMM operation, Expression<R, ?>[] parameters, Geometries<G> library) {
        super(operation, parameters);
        this.geometry = OneGeometry.toGeometryWrapper(library, parameters[0]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new OneGeometry(this.operation, effective, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return OneGeometry.getGeometryLibrary(this.geometry);
    }

    public Class<? super R> getResourceClass() {
        return this.geometry.getResourceClass();
    }

    public List<Expression<R, ?>> getParameters() {
        return List.of(OneGeometry.unwrap(this.geometry));
    }

    public Object apply(R input) {
        GeometryWrapper value = (GeometryWrapper)this.geometry.apply(input);
        if (value != null) {
            try {
                return value.operation(this.operation);
            }
            catch (RuntimeException e) {
                this.warning(e, false);
            }
        }
        return null;
    }

    static final class WithArgument<R, G>
    extends OneGeometry<R, G> {
        private static final long serialVersionUID = 2422322830405666146L;
        final Expression<R, ?> argument;

        WithArgument(SQLMM operation, Expression<R, ?>[] parameters, Geometries<G> library) {
            super(operation, parameters, library);
            this.argument = parameters[1];
        }

        @Override
        public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
            return new WithArgument(this.operation, effective, this.getGeometryLibrary());
        }

        @Override
        public Class<? super R> getResourceClass() {
            return WithArgument.specializedClass(super.getResourceClass(), this.argument.getResourceClass());
        }

        @Override
        public List<Expression<R, ?>> getParameters() {
            return List.of(WithArgument.unwrap(this.geometry), this.argument);
        }

        @Override
        public Object apply(R input) {
            GeometryWrapper value = (GeometryWrapper)this.geometry.apply(input);
            if (value != null) {
                try {
                    return value.operationWithArgument(this.operation, this.argument.apply(input));
                }
                catch (RuntimeException e) {
                    this.warning(e, false);
                }
            }
            return null;
        }
    }
}

