/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.temporal.object.DefaultInstant;
import org.geotoolkit.temporal.object.DefaultTemporalNode;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.temporal.OrdinalEra;

@XmlType(name="TimeOrdinalEra_Type", propOrder={"start", "endd", "member", "groupp"})
@XmlRootElement(name="TimeOrdinalEra")
public class DefaultOrdinalEra
extends AbstractIdentifiedObject
implements OrdinalEra {
    private Date begin;
    private Date end;
    private Collection<OrdinalEra> member;
    private DefaultOrdinalEra group;

    public DefaultOrdinalEra(Map<String, ?> properties, Date beginning, Date end) {
        super(properties);
        if (!beginning.before(end)) {
            throw new IllegalArgumentException("The beginning date of the OrdinalEra must be less than (i.e. earlier than) the end date of this OrdinalEra.");
        }
        this.begin = beginning;
        this.end = end;
    }

    public DefaultOrdinalEra(Map<String, ?> properties, Date beginning, Date end, Collection<OrdinalEra> member) {
        super(properties);
        this.begin = beginning;
        this.end = end;
        this.member = member;
        if (member != null) {
            for (OrdinalEra ordinalEra : this.member) {
                ((DefaultOrdinalEra)ordinalEra).setGroup(this);
            }
        }
    }

    private DefaultOrdinalEra() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    private DefaultOrdinalEra(OrdinalEra object) {
        super((IdentifiedObject)object);
        if (object != null) {
            this.begin = object.getBegin();
            this.end = object.getEnd();
            this.member = object.getMember();
            if (this.member != null) {
                for (OrdinalEra ordinalEra : this.member) {
                    ((DefaultOrdinalEra)ordinalEra).setGroup(this);
                }
            }
        }
    }

    public static DefaultOrdinalEra castOrCopy(OrdinalEra object) {
        if (object == null || object instanceof DefaultOrdinalEra) {
            return (DefaultOrdinalEra)object;
        }
        return new DefaultOrdinalEra(object);
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    @XmlElement(name="member")
    public Collection<OrdinalEra> getMember() {
        return this.member;
    }

    public DefaultOrdinalEra getGroup() {
        return this.group;
    }

    @XmlElement(name="start")
    private DefaultTemporalNode getStart() {
        Identifier iden = this.getName();
        HashMap<String, NamedIdentifier> instantProp = new HashMap<String, NamedIdentifier>();
        instantProp.put("name", new NamedIdentifier(null, (CharSequence)(iden.getCode() + "_begin instant")));
        HashMap<String, NamedIdentifier> nodeProp = new HashMap<String, NamedIdentifier>();
        nodeProp.put("name", new NamedIdentifier(null, (CharSequence)(iden.getCode() + "_start node")));
        DefaultTemporalNode start = new DefaultTemporalNode(nodeProp, new DefaultInstant(instantProp, this.begin), null, null);
        return start;
    }

    @XmlElement(name="end")
    private DefaultTemporalNode getEndd() {
        Identifier iden = this.getName();
        HashMap<String, NamedIdentifier> instantProp = new HashMap<String, NamedIdentifier>();
        instantProp.put("name", new NamedIdentifier(null, (CharSequence)(iden.getCode() + "_end instant")));
        HashMap<String, NamedIdentifier> nodeProp = new HashMap<String, NamedIdentifier>();
        nodeProp.put("name", new NamedIdentifier(null, (CharSequence)(iden.getCode() + "_end node")));
        DefaultTemporalNode start = new DefaultTemporalNode(nodeProp, new DefaultInstant(instantProp, this.begin), null, null);
        return start;
    }

    @XmlElement(name="group")
    private DefaultOrdinalEra getGroupp() {
        return null;
    }

    public void setGroup(DefaultOrdinalEra group) {
        this.group = group;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object instanceof DefaultOrdinalEra) {
            DefaultOrdinalEra that = (DefaultOrdinalEra)((Object)object);
            return Objects.equals(this.begin, that.begin) && Objects.equals(this.end, that.end) && Objects.equals(this.member, that.member) && Objects.equals((Object)this.group, (Object)that.group);
        }
        return false;
    }

    protected long computeHashCode() {
        int hash = 5;
        hash = 37 * hash + (this.begin != null ? this.begin.hashCode() : 0);
        hash = 37 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 37 * hash + (this.member != null ? this.member.hashCode() : 0);
        hash = 37 * hash + (this.group != null ? this.group.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(super.toString()).append('\n').append("OrdinalEra:").append('\n');
        if (this.begin != null) {
            s.append("beginning:").append(this.begin).append('\n');
        }
        if (this.end != null) {
            s.append("end:").append(this.end).append('\n');
        }
        if (this.member != null) {
            s.append("composition:").append(this.member).append('\n');
        }
        if (this.group != null) {
            s.append("group:").append(this.group.getName().toString()).append('\n');
        }
        return s.toString();
    }
}

