/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.MultiSourceArgument;
import org.apache.sis.internal.coverage.RangeArgument;
import org.apache.sis.internal.storage.MemoryGridResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

final class BandAggregateGridResource
extends AbstractGridCoverageResource
implements AggregatedResource {
    private GenericName identifier;
    private final GridCoverageResource[] sources;
    private final GridGeometry gridGeometry;
    private double[][] resolutions;
    private final List<SampleDimension> sampleDimensions;
    private final int[][] bandsPerSource;
    private final GridCoverageProcessor processor;

    private BandAggregateGridResource(StoreListeners parentListeners, MultiSourceArgument<GridCoverageResource> aggregate, GridCoverageProcessor processor) {
        super(parentListeners, false);
        this.sources = aggregate.sources();
        this.gridGeometry = aggregate.domain(BandAggregateGridResource::domain);
        this.sampleDimensions = List.copyOf(aggregate.ranges());
        this.bandsPerSource = aggregate.bandsPerSource(false);
        this.processor = processor;
    }

    static GridCoverageResource create(StoreListeners parentListeners, GridCoverageResource[] sources, int[][] bandsPerSource, GridCoverageProcessor processor) throws DataStoreException {
        GridCoverage[] coverages = new GridCoverage[sources.length];
        Object coverageBands = new int[sources.length][];
        int firstBand = 0;
        int count = 0;
        for (int i = 0; i < sources.length; ++i) {
            int[] bands;
            GridCoverageResource source = sources[i];
            ArgumentChecks.ensureNonNullElement("sources", i, source);
            if (!(source instanceof MemoryGridResource)) continue;
            if (count == 0) {
                sources = (GridCoverageResource[])sources.clone();
                bandsPerSource = bandsPerSource != null ? (int[][])bandsPerSource.clone() : (int[][])new int[sources.length][];
            }
            int numBands = (bands = bandsPerSource[i]) != null ? bands.length : source.getSampleDimensions().size();
            coverages[count] = ((MemoryGridResource)source).coverage;
            coverageBands[count] = bands;
            bandsPerSource[i] = ArraysExt.range(firstBand, firstBand + numBands);
            sources[i] = null;
            firstBand += numBands;
            ++count;
        }
        if (count != 0) {
            coverages = ArraysExt.resize(coverages, count);
            coverageBands = (int[][])ArraysExt.resize(coverageBands, count);
            MemoryGridResource aggregate = new MemoryGridResource(parentListeners, processor.aggregateRanges(coverages, (int[][])coverageBands), processor);
            for (int i = 0; i < sources.length; ++i) {
                if (sources[i] != null) continue;
                sources[i] = aggregate;
            }
        }
        try {
            MultiSourceArgument<GridCoverageResource> aggregate = new MultiSourceArgument<GridCoverageResource>(sources, bandsPerSource);
            aggregate.unwrap(BandAggregateGridResource::unwrap);
            aggregate.validate(BandAggregateGridResource::range);
            aggregate.mergeConsecutiveSources();
            if (aggregate.isIdentity()) {
                return aggregate.sources()[0];
            }
            return new BandAggregateGridResource(parentListeners, aggregate, processor);
        }
        catch (BackingStoreException e) {
            throw e.unwrapOrRethrow(DataStoreException.class);
        }
    }

    private static GridGeometry domain(GridCoverageResource source) {
        try {
            return source.getGridGeometry();
        }
        catch (DataStoreException e) {
            throw new BackingStoreException(e);
        }
    }

    private static List<SampleDimension> range(GridCoverageResource source) {
        try {
            return source.getSampleDimensions();
        }
        catch (DataStoreException e) {
            throw new BackingStoreException(e);
        }
    }

    private static void unwrap(MultiSourceArgument.Unwrapper unwrapper) {
        if (unwrapper.source instanceof BandAggregateGridResource) {
            BandAggregateGridResource aggregate = (BandAggregateGridResource)unwrapper.source;
            unwrapper.applySubset(aggregate.sources, aggregate.bandsPerSource, BandAggregateGridResource::range);
        }
    }

    @Override
    public Resource apply(MergeStrategy strategy) {
        return this;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setIdentifier(GenericName identifier) {
        this.identifier = identifier;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.ofNullable(this.identifier);
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreException {
        return this.gridGeometry;
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.sampleDimensions;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        for (GridCoverageResource source : this.sources) {
            builder.addSource(source.getMetadata());
        }
        return builder.build();
    }

    @Override
    public synchronized List<double[]> getResolutions() throws DataStoreException {
        if (this.resolutions == null) {
            this.resolutions = ConcatenatedGridResource.commonResolutions(this.sources);
        }
        return UnmodifiableArrayList.wrap(this.resolutions);
    }

    @Override
    public synchronized RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        RasterLoadingStrategy conservative = RasterLoadingStrategy.AT_GET_TILE_TIME;
        for (GridCoverageResource source : this.sources) {
            RasterLoadingStrategy s = source.getLoadingStrategy();
            if (s.ordinal() >= conservative.ordinal()) continue;
            conservative = s;
            if (s.ordinal() == 0) break;
        }
        return conservative;
    }

    @Override
    public synchronized boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        boolean accepted = true;
        for (GridCoverageResource source : this.sources) {
            accepted &= source.setLoadingStrategy(strategy);
        }
        return accepted;
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        RangeArgument validator = RangeArgument.validate(this.sampleDimensions.size(), ranges, this.listeners);
        int numBands = validator.getNumBands();
        GridCoverage[] coverages = new GridCoverage[numBands];
        int[][] coverageBands = new int[numBands][];
        int[] bandsToLoad = new int[numBands];
        int numBandsToLoad = 0;
        int coverageCursor = 0;
        int bandCursor = 0;
        int cursorBase = 0;
        int cursorIndex = 0;
        int pendingIndex = 0;
        for (int i = 0; i <= numBands; ++i) {
            int[] bandsForCurrentSource;
            int bandCursorMax;
            int source = i != numBands ? validator.getSourceIndex(i) : this.sampleDimensions.size();
            bandCursor += source - cursorIndex;
            while (bandCursor >= (bandCursorMax = (bandsForCurrentSource = this.bandsPerSource[coverageCursor]).length)) {
                if (numBandsToLoad != 0) {
                    GridCoverage data = this.sources[coverageCursor].read(domain, Arrays.copyOf(bandsToLoad, numBandsToLoad));
                    numBandsToLoad = 0;
                    int b = 0;
                    do {
                        int target = validator.getTargetIndex(pendingIndex);
                        coverageBands[target] = new int[]{b++};
                        coverages[target] = data;
                    } while (++pendingIndex != i);
                }
                bandCursor -= bandCursorMax;
                cursorBase += bandCursorMax;
                if (++coverageCursor < this.bandsPerSource.length) continue;
            }
            cursorIndex = source;
            bandsToLoad[numBandsToLoad++] = bandsForCurrentSource[cursorIndex - cursorBase];
        }
        return this.processor.aggregateRanges(coverages, coverageBands);
    }
}

