/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public enum DataDirectory {
    DATABASES,
    DATUM_CHANGES,
    DOMAINS_OF_VALIDITY,
    SCHEMAS,
    TESTS;

    public static final String ENV = "SIS_DATA";
    private static short lastWarning;
    private static Path rootDirectory;
    private Path directory;

    public static void quiet() {
        lastWarning = (short)16;
    }

    private static void warning(Exception e, short key, Object ... parameters) {
        if (key != lastWarning) {
            lastWarning = key;
            DataDirectory.log(Level.WARNING, e, key, parameters);
        }
    }

    private static void log(Level level, Exception e, short key, Object ... parameters) {
        LogRecord record = Messages.getResources(null).getLogRecord(level, key, parameters);
        if (e != null) {
            record.setThrown(e);
        }
        Logging.completeAndLog(SystemListener.LOGGER, null, null, record);
    }

    public static String getenv() throws SecurityException {
        return System.getenv(ENV);
    }

    public static synchronized boolean isUndefined() {
        if (rootDirectory == null) {
            try {
                return DataDirectory.getenv() == null;
            }
            catch (SecurityException e) {
                Logging.recoverableException(SystemListener.LOGGER, DataDirectory.class, "isUndefined", e);
            }
        }
        return false;
    }

    public static synchronized Path getRootDirectory() {
        block8: {
            if (rootDirectory == null) {
                try {
                    String dir = DataDirectory.getenv();
                    if (dir == null || dir.isEmpty()) {
                        DataDirectory.warning(null, (short)16, ENV);
                        break block8;
                    }
                    try {
                        Path path = Path.of(dir, new String[0]);
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            DataDirectory.warning(null, (short)12, ENV, path);
                            break block8;
                        }
                        if (!Files.isReadable(path)) {
                            DataDirectory.warning(null, (short)15, ENV, path);
                            break block8;
                        }
                        DataDirectory.log(Level.CONFIG, null, (short)18, ENV, path);
                        rootDirectory = path;
                    }
                    catch (InvalidPathException e) {
                        DataDirectory.warning(e, (short)12, ENV, dir);
                    }
                }
                catch (SecurityException e) {
                    DataDirectory.warning(e, (short)14, ENV);
                }
            }
        }
        return rootDirectory;
    }

    public synchronized Path getDirectory() {
        Path root;
        if (this.directory == null && (root = DataDirectory.getRootDirectory()) != null) {
            StringBuilder buffer = new StringBuilder(this.name());
            for (int i = 1; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (c == '_') {
                    buffer.deleteCharAt(i);
                    continue;
                }
                buffer.setCharAt(i, Character.toLowerCase(c));
            }
            String name = buffer.toString();
            Path dir = root.resolve(name).normalize();
            try {
                if (Files.isDirectory(dir, new LinkOption[0])) {
                    this.directory = dir;
                } else if (Files.isWritable(root)) {
                    try {
                        this.directory = Files.createDirectory(dir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        DataDirectory.warning(e, (short)17, ENV, root);
                    }
                } else {
                    DataDirectory.warning(null, (short)17, ENV, root);
                }
            }
            catch (SecurityException e) {
                DataDirectory.warning(e, (short)13, ENV, name);
            }
        }
        return this.directory;
    }
}

