/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.temporal;

import java.util.Date;
import org.apache.sis.internal.temporal.DefaultTemporalFactory;
import org.apache.sis.internal.temporal.Primitive;
import org.opengis.temporal.Instant;
import org.opengis.temporal.TemporalPosition;

final class DefaultInstant
extends Primitive
implements Instant {
    private final long millis;

    DefaultInstant(Date time) {
        this.millis = time.getTime();
    }

    @Override
    public Date getDate() {
        return new Date(this.millis);
    }

    @Override
    public TemporalPosition getTemporalPosition() {
        throw DefaultTemporalFactory.unsupported();
    }

    public String toString() {
        return java.time.Instant.ofEpochMilli(this.millis).toString();
    }

    public int hashCode() {
        return Long.hashCode(this.millis) ^ 0x39;
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultInstant && ((DefaultInstant)obj).millis == this.millis;
    }
}

