/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Messages;

abstract class WeakEntry<E>
extends WeakReference<E>
implements Disposable {
    static final int MIN_CAPACITY = 7;
    static final int HASH_MASK = Integer.MAX_VALUE;
    static final long REHASH_DELAY = 4000000000L;
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.util");
    WeakEntry<E> next;
    final int hash;

    WeakEntry(E obj, WeakEntry<E> next, int hash) {
        super(obj, ReferenceQueueConsumer.QUEUE);
        this.next = next;
        this.hash = hash;
    }

    static <E> int count(WeakEntry<E>[] table) {
        int n = 0;
        for (WeakEntry<E> e : table) {
            while (e != null) {
                ++n;
                e = e.next;
            }
        }
        return n;
    }

    final boolean removeFrom(WeakEntry<E>[] table, int removeAt) {
        WeakEntry<E> prev = null;
        WeakEntry<E> e = table[removeAt];
        while (e != null) {
            if (e == this) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    table[removeAt] = e.next;
                }
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    static <E> WeakEntry<E>[] rehash(WeakEntry<E>[] oldTable, int count, String callerMethod) {
        int capacity = Math.max(count * 2, 7);
        if (capacity < 65521) {
            capacity = MathFunctions.nextPrimeNumber(capacity);
        }
        if (capacity == oldTable.length) {
            return oldTable;
        }
        Class<?> entryType = oldTable.getClass().getComponentType();
        WeakEntry[] table = (WeakEntry[])Array.newInstance(entryType, capacity);
        for (WeakEntry<E> next : oldTable) {
            while (next != null) {
                WeakEntry<E> e = next;
                next = next.next;
                int index = e.hash % table.length;
                e.next = table[index];
                table[index] = e;
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LogRecord record = Messages.getResources(null).getLogRecord(Level.FINEST, (short)4, oldTable.length, table.length);
            record.setSourceMethodName(callerMethod);
            record.setSourceClassName(entryType.getEnclosingClass().getName());
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        return table;
    }

    static int lowerCapacityThreshold(int capacity) {
        return capacity >>> 2;
    }

    static int upperCapacityThreshold(int capacity) {
        return capacity - (capacity >>> 2);
    }
}

