/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.WeakEntry;

public class WeakHashSet<E>
extends AbstractSet<E>
implements CheckedContainer<E> {
    private Entry[] table;
    private int count;
    private final Class<E> elementType;
    private final boolean mayContainArrays;
    private transient long lastTimeNormalCapacity;
    private static final int REMOVE = -1;
    private static final int GET = 0;
    private static final int ADD = 1;
    private static final int INTERN = 2;

    public WeakHashSet(Class<E> type) {
        this.elementType = type;
        this.mayContainArrays = type.isArray() || type.equals(Object.class);
        this.lastTimeNormalCapacity = System.nanoTime();
        this.table = new Entry[7];
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    private synchronized void removeEntry(Entry toRemove) {
        assert (this.isValid());
        int capacity = this.table.length;
        if (toRemove.removeFrom(this.table, toRemove.hash % capacity)) {
            long currentTime;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(capacity) && (currentTime = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count, "remove");
                this.lastTimeNormalCapacity = currentTime;
                assert (this.isValid());
            }
        }
    }

    private boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    @Override
    public synchronized boolean add(E element) throws NullArgumentException {
        ArgumentChecks.ensureNonNull("element", element);
        return this.intern(element, 1) == null;
    }

    @Override
    public synchronized boolean remove(Object element) {
        return this.intern(element, -1) != null;
    }

    public synchronized E get(Object element) {
        return this.intern(element, 0);
    }

    @Override
    public synchronized boolean contains(Object element) {
        return this.intern(element, 0) != null;
    }

    public synchronized <T extends E> T unique(T element) {
        return (T)this.intern(element, 2);
    }

    private E intern(Object obj, int operation) {
        assert (this.isValid());
        if (obj != null) {
            Entry[] table = this.table;
            int hash = (this.mayContainArrays ? Utilities.deepHashCode(obj) : obj.hashCode()) & Integer.MAX_VALUE;
            int index = hash % table.length;
            Entry e = table[index];
            while (e != null) {
                Object candidate = e.get();
                if (this.mayContainArrays ? Objects.deepEquals(candidate, obj) : obj.equals(candidate)) {
                    if (operation == -1) {
                        e.dispose();
                    }
                    return (E)candidate;
                }
                e = (Entry)e.next;
            }
            if (operation >= 1) {
                if (++this.count >= WeakEntry.lowerCapacityThreshold(table.length)) {
                    if (this.count > WeakEntry.upperCapacityThreshold(table.length)) {
                        this.table = table = (Entry[])WeakEntry.rehash(table, this.count, "add");
                        index = hash % table.length;
                    }
                    this.lastTimeNormalCapacity = System.nanoTime();
                }
                E element = this.elementType.cast(obj);
                table[index] = new Entry(element, table[index], hash);
                assert (this.isValid());
                if (operation == 2) {
                    return element;
                }
            }
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized E[] toArray() {
        assert (this.isValid());
        Object[] elements = (Object[])Array.newInstance(this.elementType, this.count);
        int index = 0;
        for (Entry el : this.table) {
            while (el != null) {
                elements[index] = el.get();
                if (elements[index] != null) {
                    ++index;
                }
                el = (Entry)el.next;
            }
        }
        return ArraysExt.resize(elements, index);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    private final class Entry
    extends WeakEntry<E> {
        Entry(E obj, Entry next, int hash) {
            super(obj, next, hash);
        }

        @Override
        public void dispose() {
            super.clear();
            WeakHashSet.this.removeEntry(this);
        }
    }
}

