/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.nsg.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataTests
extends CommonFixture {
    private static final Logger LOG = Logger.getLogger(MetadataTests.class.getName());
    private Schema schema;
    private DocumentBuilder builder;

    @BeforeClass
    public void initSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/opengis/cite/gpkg12/nsg/metadata/NMIS_v2.X_Schema/nas/nmis.xsd");
        this.schema = schemaFactory.newSchema(resource);
    }

    @BeforeClass
    public void initDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        this.builder = factory.newDocumentBuilder();
    }

    @Test(description="Validate against NMIS schema")
    public void metadataSchemaValidation() throws SQLException {
        block14: {
            if (this.schema == null) {
                throw new SkipException("Schema required for validation could not be loaded.");
            }
            if (DatabaseUtility.doesTableOrViewExist((Connection)this.databaseConnection, (String)"gpkg_metadata")) {
                try (Statement statement = this.databaseConnection.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT metadata FROM gpkg_metadata;");){
                    List<String> xmlEntries = this.findXmlEntries(resultSet);
                    this.validateXmlEntries(xmlEntries);
                    break block14;
                }
            }
            throw new SkipException("Table gpkg_metadata required to evaluate metadata.");
        }
    }

    void validateXmlEntries(List<String> xmlEntries) {
        if (xmlEntries.isEmpty()) {
            throw new AssertionError((Object)"GeoPackage does not contain a NMIS v2.2 metadata as XML.");
        }
        if (xmlEntries.size() == 1) {
            this.validateXmlEntry(xmlEntries.get(0));
        } else {
            boolean hasValidMetadataEntry = this.hasValidEntry(xmlEntries);
            if (!hasValidMetadataEntry) {
                throw new AssertionError((Object)"GeoPackage does not contain at least one valid NMIS v2.2 metadata as XML.");
            }
        }
    }

    private void validateXmlEntry(String xmlEntry) {
        try {
            ValidationErrorHandler validationResult = this.validate(xmlEntry);
            if (validationResult.errorsDetected()) {
                String errors = validationResult.getErrors().stream().map(Object::toString).collect(Collectors.joining(","));
                throw new AssertionError((Object)("GeoPackage does not contain a valid NMIS v2.2 metadata as XML. Results of the schema validation: " + errors));
            }
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.WARNING, "An error occurred during validation.", e);
            throw new AssertionError((Object)("Validation of the NMIS v2.2 metadata as XML failed: " + e.getMessage()));
        }
    }

    List<String> findXmlEntries(ResultSet resultSet) throws SQLException {
        ArrayList<String> xmlEntries = new ArrayList<String>();
        while (resultSet.next()) {
            String metadataEntry = resultSet.getString("metadata");
            try (StringReader reader = new StringReader(metadataEntry);){
                InputSource inputSource = new InputSource(reader);
                this.builder.parse(inputSource);
                xmlEntries.add(metadataEntry);
            }
            catch (IOException | SAXException exception) {}
        }
        return xmlEntries;
    }

    private boolean hasValidEntry(List<String> metadataEntries) {
        for (String metadataEntry : metadataEntries) {
            if (!this.isEntryValid(metadataEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean isEntryValid(String metadataEntry) {
        try {
            ValidationErrorHandler validationResult = this.validate(metadataEntry);
            if (!validationResult.errorsDetected()) {
                return true;
            }
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.WARNING, "An error occurred during validation.", e);
        }
        return false;
    }

    private ValidationErrorHandler validate(String metadataEntry) throws IOException, SAXException {
        Validator validator = this.schema.newValidator();
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        StreamSource source = new StreamSource(new ByteArrayInputStream(metadataEntry.getBytes()));
        validator.validate(source);
        return errHandler;
    }
}

