/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.nsg.tiles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.opengis.cite.gpkg12.util.DatabaseUtility;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class NSG_TileTests
extends CommonFixture {
    private static final int MIN_ZOOM = 0;
    private static final int MAX_ZOOM = 24;
    private static final double TOLERANCE = 1.0E-10;

    public static String ValidateStringInput(String inputString) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder(50);
        for (int ii = 0; ii < inputString.length(); ++ii) {
            char cleanedchar = NSG_TileTests.cleanChar(inputString.charAt(ii));
            if (cleanedchar == '^') {
                throw new IllegalArgumentException(String.format("Illegal parameter provided within SQL statement. Error in %s at character %c", inputString, Character.valueOf(inputString.charAt(ii))));
            }
            sb.append(cleanedchar);
        }
        return sb.toString();
    }

    private static char cleanChar(char inputChar) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (inputChar != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (inputChar != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (inputChar != i) continue;
            return (char)i;
        }
        switch (inputChar) {
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
        }
        return '^';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(groups={"NSG"}, description="NSG Req 19-D (Data Validity: gpkg_tile_matrix)")
    public void dataValidity_gpkg_tile_matrix() throws SQLException {
        String queryStr = "SELECT table_name FROM gpkg_contents WHERE data_type='tiles';";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryStr);){
            while (resultSet.next()) {
                ResultSet tileResultSet;
                String tableName = NSG_TileTests.ValidateStringInput(resultSet.getString("table_name").trim());
                int firstZoom = 999;
                int lastZoom = -1;
                try (Statement tileStatement = this.databaseConnection.createStatement();){
                    tileResultSet = tileStatement.executeQuery("SELECT DISTINCT zoom_level FROM " + tableName + " ORDER BY zoom_level;");
                    try {
                        while (tileResultSet.next()) {
                            int zoom = tileResultSet.getInt("zoom_level");
                            firstZoom = Math.min(firstZoom, zoom);
                            lastZoom = Math.max(lastZoom, zoom);
                        }
                    }
                    finally {
                        if (tileResultSet != null) {
                            tileResultSet.close();
                        }
                    }
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = Integer.toString(firstZoom);
                objectArray[1] = Integer.toString(0);
                Assert.assertTrue((firstZoom >= 0 ? 1 : 0) != 0, (String)MessageFormat.format("The " + tableName + " table contains an invalid minimum zoom_level: {0}, should be: {1}", objectArray));
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = Integer.toString(firstZoom);
                objectArray2[1] = Integer.toString(24);
                Assert.assertTrue((lastZoom <= 24 ? 1 : 0) != 0, (String)MessageFormat.format("The " + tableName + " table contains an invalid maximum zoom_level: {0}, should be: {1}", objectArray2));
                tileStatement = this.databaseConnection.createStatement();
                try {
                    tileResultSet = tileStatement.executeQuery("SELECT zoom_level, tile_width, tile_height, pixel_x_size, pixel_y_size FROM gpkg_tile_matrix WHERE table_name='" + tableName + "' ORDER BY zoom_level;");
                    try {
                        boolean firstFound = false;
                        boolean lastFound = false;
                        double pixelSzX = 0.0;
                        double pixelSzY = 0.0;
                        while (tileResultSet.next()) {
                            int zoom = tileResultSet.getInt("zoom_level");
                            if (zoom < firstZoom || zoom > lastZoom) continue;
                            int tileWidth = tileResultSet.getInt("tile_width");
                            int tileHeight = tileResultSet.getInt("tile_height");
                            double lastPixelSzX = pixelSzX;
                            double lastPixelSzY = pixelSzY;
                            pixelSzX = tileResultSet.getDouble("pixel_x_size");
                            pixelSzY = tileResultSet.getDouble("pixel_y_size");
                            Assert.assertTrue((0 <= zoom && zoom <= lastZoom ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid zoom_level: {0} for {1}, should be between {2} and {3}", Integer.toString(zoom), tableName, Integer.toString(firstZoom), Integer.toString(lastZoom)));
                            if (!firstFound) {
                                boolean bl = firstFound = zoom == firstZoom;
                            }
                            if (!lastFound) {
                                lastFound = zoom == lastZoom;
                            }
                            Assert.assertTrue((tileWidth == 256 ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid tile_width: {0} for {1}, should be 256", Integer.toString(tileWidth), tableName));
                            Assert.assertTrue((tileHeight == 256 ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid tile_height: {0} for {1}, should be 256", Integer.toString(tileHeight), tableName));
                            double deltaX = Math.abs(pixelSzX * 2.0 - lastPixelSzX);
                            Assert.assertTrue((zoom == firstZoom || deltaX < 1.0E-10 ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid pixel_x_size: {0} for {1}", String.format("%.10f", pixelSzX), tableName));
                            double deltaY = Math.abs(pixelSzY * 2.0 - lastPixelSzY);
                            Assert.assertTrue((zoom == firstZoom || deltaY < 1.0E-10 ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid pixel_y_size: {0} for {1}", String.format("%.10f", pixelSzY), tableName));
                        }
                        Assert.assertTrue((boolean)firstFound, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid zoom_level: no zoom level 0 for {0}", tableName));
                        Assert.assertTrue((boolean)lastFound, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid zoom_level: no max zoom level for {0}", tableName));
                    }
                    finally {
                        if (tileResultSet == null) continue;
                        tileResultSet.close();
                    }
                }
                finally {
                    if (tileStatement == null) continue;
                    tileStatement.close();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(groups={"NSG"}, description="NSG Req 20 & 21 (Tile widths and heights)")
    public void tileSizeTests() throws SQLException, IOException {
        if (!DatabaseUtility.doesTableOrViewExist((Connection)this.databaseConnection, (String)"gpkg_tile_matrix")) throw new SkipException("Table gpkg_tile_matrix required to perform this test.");
        Collection<String> tableNameAndExtents = this.collectTableNameAndExtents();
        Assert.assertTrue((boolean)tableNameAndExtents.isEmpty(), (String)MessageFormat.format("The gpkg_tile_matrix table contains invalid tile width/height values for tables: {0}", tableNameAndExtents.stream().map(Object::toString).collect(Collectors.joining(", "))));
        String tableNameQuery = "SELECT DISTINCT table_name FROM gpkg_tile_matrix;";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(tableNameQuery);){
            block20: while (resultSet.next()) {
                String tableName = NSG_TileTests.ValidateStringInput(resultSet.getString("table_name").trim());
                Statement subStatement = this.databaseConnection.createStatement();
                try {
                    ResultSet subResultSet = subStatement.executeQuery("SELECT zoom_level, tile_column, tile_row, tile_data FROM " + tableName);
                    try {
                        block21: while (true) {
                            if (!subResultSet.next()) continue block20;
                            byte[] image = subResultSet.getBytes("tile_data");
                            ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(image));
                            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                            while (true) {
                                if (!readers.hasNext()) continue block21;
                                ImageReader read = readers.next();
                                read.setInput(iis, true);
                                int width = read.getWidth(0);
                                int height = read.getHeight(0);
                                Assert.assertTrue((width == 256 ? 1 : 0) != 0, (String)MessageFormat.format("The pyramid data table (for {0}) contains a tile image (at zoom_level:  {1}, (col,row): {2},{3}) with an invalid tile_width: {4}", tableName, Integer.toString(subResultSet.getInt("zoom_level")), Integer.toString(subResultSet.getInt("tile_column")), Integer.toString(subResultSet.getInt("tile_row")), Integer.toString(width)));
                                Assert.assertTrue((height == 256 ? 1 : 0) != 0, (String)MessageFormat.format("The pyramid data table (for {0}) contains a tile image (at zoom_level:  {1}, (col,row): {2},{3}) with an invalid tile_height: {4}", tableName, Integer.toString(subResultSet.getInt("zoom_level")), Integer.toString(subResultSet.getInt("tile_column")), Integer.toString(subResultSet.getInt("tile_row")), Integer.toString(height)));
                            }
                            break;
                        }
                    }
                    finally {
                        if (subResultSet == null) continue;
                        subResultSet.close();
                    }
                }
                finally {
                    if (subStatement == null) continue;
                    subStatement.close();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(groups={"NSG"}, description="NSG Req 22 (pixels sizes factor of 2)")
    public void pixelsSizeTests() throws SQLException {
        String queryStr = "SELECT table_name FROM gpkg_contents WHERE data_type='tiles';";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryStr);){
            block20: while (resultSet.next()) {
                String tableName = NSG_TileTests.ValidateStringInput(resultSet.getString("table_name").trim());
                String subQueryStr = "SELECT pixel_x_size, pixel_y_size FROM gpkg_tile_matrix WHERE table_name='" + tableName + "' ORDER BY zoom_level;";
                Statement subStatement = this.databaseConnection.createStatement();
                try {
                    ResultSet subResultSet = subStatement.executeQuery(subQueryStr);
                    try {
                        double pixelSzX = -1.0;
                        double pixelSzY = -1.0;
                        while (true) {
                            if (!subResultSet.next()) continue block20;
                            double lastPixelSzX = pixelSzX;
                            double lastPixelSzY = pixelSzY;
                            pixelSzX = subResultSet.getDouble("pixel_x_size");
                            pixelSzY = subResultSet.getDouble("pixel_y_size");
                            if (lastPixelSzX < 0.0) {
                                lastPixelSzX = pixelSzX * 2.0;
                                lastPixelSzY = pixelSzY * 2.0;
                            }
                            double deltaX = Math.abs(pixelSzX * 2.0 - lastPixelSzX);
                            Assert.assertTrue((deltaX < 1.0E-10 ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid pixel_x_size: {0} for {1}", String.format("%.10f", pixelSzX), tableName));
                            double deltaY = Math.abs(pixelSzY * 2.0 - lastPixelSzY);
                            Assert.assertTrue((deltaY < 1.0E-10 ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix contains an invalid pixel_y_size: {0} for {1}", String.format("%.10f", pixelSzY), tableName));
                        }
                    }
                    finally {
                        if (subResultSet == null) continue;
                        subResultSet.close();
                    }
                }
                finally {
                    if (subStatement == null) continue;
                    subStatement.close();
                }
            }
            return;
        }
    }

    @Test(groups={"NSG"}, description="NSG Req 23 (bounding box in gpkg_tile_matrix_set)")
    public void boundingBoxTests() throws SQLException {
        block14: {
            if (DatabaseUtility.doesTableOrViewExist((Connection)this.databaseConnection, (String)"gpkg_tile_matrix_set")) {
                String queryStr = "SELECT table_name, srs_id, min_x, min_y, max_x, max_y FROM gpkg_tile_matrix_set;";
                try (Statement statement = this.databaseConnection.createStatement();
                     ResultSet resultSet = statement.executeQuery(queryStr);){
                    while (resultSet.next()) {
                        String srsID = resultSet.getString("srs_id").trim();
                        String tableName = resultSet.getString("table_name").trim();
                        double[] mbr = this.findMbrBySrsId(srsID);
                        Assert.assertTrue((mbr != null ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix_set contains an invalid CRS definition: {0} for table {1}", srsID, tableName));
                        double minX = resultSet.getDouble("min_x");
                        Assert.assertTrue((minX == mbr[0] ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix_set contains an invalid min_x value: {0} for table {1} (should be {2})", minX, tableName, mbr[0]));
                        double minY = resultSet.getDouble("min_y");
                        Assert.assertTrue((minY == mbr[1] ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix_set contains an invalid min_y value: {0} for table {1} (should be {2})", minY, tableName, mbr[1]));
                        double maxX = resultSet.getDouble("max_x");
                        Assert.assertTrue((maxX == mbr[2] ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix_set contains an invalid max_x value: {0} for table {1} (should be {2})", maxX, tableName, mbr[2]));
                        double maxY = resultSet.getDouble("max_y");
                        Assert.assertTrue((maxY == mbr[3] ? 1 : 0) != 0, (String)MessageFormat.format("The gpkg_tile_matrix_set contains an invalid max_y value: {0} for table {1} (should be {2})", maxY, tableName, mbr[3]));
                    }
                    break block14;
                }
            }
            throw new SkipException("Table gpkg_tile_matrix_set required to perform this test.");
        }
    }

    private Collection<String> collectTableNameAndExtents() throws SQLException {
        LinkedList<String> tableNamesAndExtents;
        block14: {
            tableNamesAndExtents = new LinkedList<String>();
            if (DatabaseUtility.doesTableOrViewExist((Connection)this.databaseConnection, (String)"gpkg_tile_matrix_set")) {
                String tableNameAndExtentsQuery = "SELECT table_name, zoom_level, tile_width, tile_height FROM gpkg_tile_matrix WHERE NOT ((tile_width=256) AND (tile_height=256));";
                try (Statement statement = this.databaseConnection.createStatement();
                     ResultSet resultSet = statement.executeQuery(tableNameAndExtentsQuery);){
                    while (resultSet.next()) {
                        String tableName = resultSet.getString("table_name");
                        int tileWidth = resultSet.getInt("tile_width");
                        int tileHeight = resultSet.getInt("tile_height");
                        tableNamesAndExtents.add(tableName + ": (tile_width)" + tileWidth + ", (tile_height)" + tileHeight);
                    }
                    break block14;
                }
            }
            throw new SkipException("Table gpkg_tile_matrix_set required to perform this test.");
        }
        return tableNamesAndExtents;
    }

    private double[] findMbrBySrsId(String srsID) {
        if (srsID.equals("3395")) {
            return new double[]{-2.0037508342789244E7, -2.0037508342789244E7, 2.0037508342789244E7, 2.0037508342789244E7};
        }
        if (srsID.equals("5041")) {
            return new double[]{-1.4440759350252E7, -1.4440759350252E7, 1.8440759350252E7, 1.8440759350252E7};
        }
        if (srsID.equals("4326")) {
            return new double[]{-180.0, -90.0, 180.0, 90.0};
        }
        return null;
    }

    @Test(groups={"NSG"}, description="NSG Req 19-B (Data Validity: gpkg_contents, tiles)")
    public void dataValidity_gpkg_contents() throws SQLException {
        String queryStr = "SELECT srs_id,table_name,min_x,min_y,max_x,max_y FROM 'gpkg_contents' WHERE (data_type='tiles');";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryStr);){
            LinkedList<String> invalidMinX = new LinkedList<String>();
            LinkedList<String> invalidMinY = new LinkedList<String>();
            LinkedList<String> invalidMaxX = new LinkedList<String>();
            LinkedList<String> invalidMaxY = new LinkedList<String>();
            while (resultSet.next()) {
                String srsTabNam = resultSet.getString("table_name");
                this.collectInvalidMinValues(resultSet, invalidMinX, srsTabNam, "min_x");
                this.collectInvalidMinValues(resultSet, invalidMinY, srsTabNam, "min_y");
                this.collectInvalidMaxValues(resultSet, invalidMaxX, srsTabNam, "max_x");
                this.collectInvalidMaxValues(resultSet, invalidMaxY, srsTabNam, "max_y");
            }
            Assert.assertTrue((boolean)invalidMinX.isEmpty(), (String)MessageFormat.format("The gpkg_contents table contains invalid minimum X bounds values for tables: {0}", invalidMinX.stream().map(Object::toString).collect(Collectors.joining(", "))));
            Assert.assertTrue((boolean)invalidMinY.isEmpty(), (String)MessageFormat.format("The gpkg_contents table contains invalid minimum Y bounds values for tables: {0}", invalidMinY.stream().map(Object::toString).collect(Collectors.joining(", "))));
            Assert.assertTrue((boolean)invalidMaxX.isEmpty(), (String)MessageFormat.format("The gpkg_contents table contains invalid maximum X bounds values for tables: {0}", invalidMaxX.stream().map(Object::toString).collect(Collectors.joining(", "))));
            Assert.assertTrue((boolean)invalidMaxY.isEmpty(), (String)MessageFormat.format("The gpkg_contents table contains invalid maximum Y bounds values for tables: {0}", invalidMaxY.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }

    private void collectInvalidMaxValues(ResultSet resultSet, Collection<String> invalidValue, String srsTabNam, String testBoundsColumn) throws SQLException {
        double bnd;
        double val;
        if (resultSet.getString(testBoundsColumn) != null && (val = resultSet.getDouble(testBoundsColumn)) > (bnd = this.checkTileBounds(NSG_TileTests.ValidateStringInput(srsTabNam), testBoundsColumn))) {
            invalidValue.add(srsTabNam + ":" + val + ", should be: " + bnd);
        }
    }

    private void collectInvalidMinValues(ResultSet resultSet, Collection<String> invalidValue, String srsTabNam, String testBoundsColumn) throws SQLException {
        double bnd;
        double val;
        if (resultSet.getString(testBoundsColumn) != null && (val = resultSet.getDouble(testBoundsColumn)) < (bnd = this.checkTileBounds(NSG_TileTests.ValidateStringInput(srsTabNam), testBoundsColumn))) {
            invalidValue.add(srsTabNam + ":" + val + ", should be: " + bnd);
        }
    }

    private double checkTileBounds(String tableName, String boundsColumn) throws SQLException {
        try (Statement statement = this.databaseConnection.createStatement();){
            double d;
            block12: {
                ResultSet resultSet = statement.executeQuery("SELECT " + boundsColumn + " FROM gpkg_tile_matrix_set WHERE table_name = '" + tableName + "';");
                try {
                    Assert.assertTrue((boolean)resultSet.next(), (String)ErrorMessage.format((String)"BadTileMatrixSetTableDefinition", (Object[])new Object[0]));
                    d = resultSet.getDouble(boundsColumn);
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return d;
        }
    }
}

