/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.opengis.cite.gpkg12.CommonFixture;
import org.opengis.cite.gpkg12.ErrorMessage;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpatialReferenceSystemsTests
extends CommonFixture {
    @Test(description="See OGC 12-128r12: Requirement 10")
    public void srsTableDefinition() throws SQLException {
        String tableName = "gpkg_spatial_ref_sys";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet resultSet = statement.executeQuery("PRAGMA table_info('gpkg_spatial_ref_sys');");){
            int passFlag = 0;
            int flagMask = 63;
            this.checkPrimaryKey("gpkg_spatial_ref_sys", "srs_id");
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if ("srs_id".equals(name)) {
                    passFlag |= 1;
                    continue;
                }
                if ("srs_name".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("InvalidColumnDefinition", "srs_name", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidColumnDefinition", "srs_name", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getInt("notnull")));
                    passFlag |= 2;
                    continue;
                }
                if ("organization".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("InvalidColumnDefinition", "organization", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidColumnDefinition", "organization", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getInt("notnull")));
                    passFlag |= 4;
                    continue;
                }
                if ("organization_coordsys_id".equals(name)) {
                    Assert.assertTrue((boolean)"INTEGER".equals(resultSet.getString("type")), (String)ErrorMessage.format("InvalidColumnDefinition", "organization_coordsys_id", "gpkg_spatial_ref_sys", "type", "INTEGER", resultSet.getString("type")));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidColumnDefinition", "organization_coordsys_id", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getInt("notnull")));
                    passFlag |= 8;
                    continue;
                }
                if ("definition".equals(name)) {
                    Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("InvalidColumnDefinition", "definition", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                    Assert.assertTrue((resultSet.getInt("notnull") == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidColumnDefinition", "definition", "gpkg_spatial_ref_sys", "notnull", "1", resultSet.getString("notnull")));
                    passFlag |= 0x10;
                    continue;
                }
                if (!"description".equals(name)) continue;
                Assert.assertTrue((boolean)"TEXT".equals(resultSet.getString("type")), (String)ErrorMessage.format("InvalidColumnDefinition", "description", "gpkg_spatial_ref_sys", "type", "TEXT", resultSet.getString("type")));
                Assert.assertTrue((resultSet.getInt("notnull") == 0 ? 1 : 0) != 0, (String)ErrorMessage.format("InvalidColumnDefinition", "description", "gpkg_spatial_ref_sys", "notnull", "0", resultSet.getString("notnull")));
                passFlag |= 0x20;
            }
            Assert.assertTrue(((passFlag & 0x3F) == 63 ? 1 : 0) != 0, (String)ErrorMessage.format("MissingColumn", "gpkg_spatial_ref_sys"));
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 11")
    public void requiredSrsEntries() throws SQLException {
        Throwable throwable;
        ResultSet srsDefaultValue;
        try (Statement statement = this.databaseConnection.createStatement();){
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization_coordsys_id = 4326 AND (organization = 'EPSG' OR organization = 'epsg');");
            throwable = null;
            try {
                Assert.assertTrue((boolean)srsDefaultValue.next(), (String)ErrorMessage.format("NoGeographicSrs", new Object[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (srsDefaultValue != null) {
                    if (throwable != null) {
                        try {
                            srsDefaultValue.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        srsDefaultValue.close();
                    }
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = -1 AND organization = 'NONE' AND organization_coordsys_id = -1 AND definition = 'undefined';");
            throwable = null;
            try {
                Assert.assertTrue((boolean)srsDefaultValue.next(), (String)ErrorMessage.format("NoUndefinedCartesianSrs", new Object[0]));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (srsDefaultValue != null) {
                    if (throwable != null) {
                        try {
                            srsDefaultValue.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        srsDefaultValue.close();
                    }
                }
            }
        }
        catch (Throwable srsDefaultValue2) {
            var2_2 = srsDefaultValue2;
            throw srsDefaultValue2;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable srsDefaultValue2) {
                        var2_2.addSuppressed(srsDefaultValue2);
                    }
                } else {
                    statement.close();
                }
            }
        }
        statement = this.databaseConnection.createStatement();
        var2_2 = null;
        try {
            srsDefaultValue = statement.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE srs_id = 0 AND organization = 'NONE' AND organization_coordsys_id =  0 AND definition = 'undefined';");
            throwable = null;
            try {
                Assert.assertTrue((boolean)srsDefaultValue.next(), (String)ErrorMessage.format("NoUndefinedGeographicSrs", new Object[0]));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (srsDefaultValue != null) {
                    if (throwable != null) {
                        try {
                            srsDefaultValue.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        srsDefaultValue.close();
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            var2_2 = throwable8;
            throw throwable8;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable9) {
                        var2_2.addSuppressed(throwable9);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    @Test(description="See OGC 12-128r12: Requirement 12")
    public void checkContentSrs() throws SQLException {
        this.checkContentSrs("'tiles','features'");
    }

    protected void checkContentSrs(String types) throws SQLException {
        String query = "SELECT DISTINCT gc.srs_id, srs.srs_id FROM gpkg_contents AS gc LEFT OUTER JOIN gpkg_spatial_ref_sys AS srs ON srs.srs_id = gc.srs_id WHERE gc.data_type IN(" + types + ")";
        try (Statement statement = this.databaseConnection.createStatement();
             ResultSet srsDefined = statement.executeQuery(query);){
            LinkedList<String> invalidSrsIds = new LinkedList<String>();
            while (srsDefined.next()) {
                if (srsDefined.getString(2) != null) continue;
                invalidSrsIds.add(srsDefined.getString(1));
            }
            Assert.assertTrue((boolean)invalidSrsIds.isEmpty(), (String)ErrorMessage.format("UndefinedSrs", invalidSrsIds.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
    }
}

